/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.BalanceContract;
import org.tron.protos.contract.Common;

public class FreezeBalanceV2Actuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public FreezeBalanceV2Actuator() {
        super(Protocol.Transaction.Contract.ContractType.FreezeBalanceV2Contract, BalanceContract.FreezeBalanceV2Contract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        BalanceContract.FreezeBalanceV2Contract freezeBalanceV2Contract;
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        try {
            freezeBalanceV2Contract = (BalanceContract.FreezeBalanceV2Contract)this.any.unpack(BalanceContract.FreezeBalanceV2Contract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        AccountCapsule accountCapsule = accountStore.get(freezeBalanceV2Contract.getOwnerAddress().toByteArray());
        if (dynamicStore.supportAllowNewResourceModel() && accountCapsule.oldTronPowerIsNotInitialized()) {
            accountCapsule.initializeOldTronPower();
        }
        long frozenBalance = freezeBalanceV2Contract.getFrozenBalance();
        long newBalance = accountCapsule.getBalance() - frozenBalance;
        switch (freezeBalanceV2Contract.getResource()) {
            case BANDWIDTH: {
                long oldNetWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.BANDWIDTH) / 1000000L;
                accountCapsule.addFrozenBalanceForBandwidthV2(frozenBalance);
                long newNetWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.BANDWIDTH) / 1000000L;
                dynamicStore.addTotalNetWeight(newNetWeight - oldNetWeight);
                break;
            }
            case ENERGY: {
                long oldEnergyWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.ENERGY) / 1000000L;
                accountCapsule.addFrozenBalanceForEnergyV2(frozenBalance);
                long newEnergyWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.ENERGY) / 1000000L;
                dynamicStore.addTotalEnergyWeight(newEnergyWeight - oldEnergyWeight);
                break;
            }
            case TRON_POWER: {
                long oldTPWeight = accountCapsule.getTronPowerFrozenV2Balance() / 1000000L;
                accountCapsule.addFrozenForTronPowerV2(frozenBalance);
                long newTPWeight = accountCapsule.getTronPowerFrozenV2Balance() / 1000000L;
                dynamicStore.addTotalTronPowerWeight(newTPWeight - oldTPWeight);
                break;
            }
            default: {
                logger.debug("Resource Code Error.");
            }
        }
        accountCapsule.setBalance(newBalance);
        accountStore.put(accountCapsule.createDbKey(), accountCapsule);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    public boolean validate() throws ContractValidateException {
        BalanceContract.FreezeBalanceV2Contract freezeBalanceV2Contract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        if (!this.any.is(BalanceContract.FreezeBalanceV2Contract.class)) {
            throw new ContractValidateException("contract type error,expected type [FreezeBalanceV2Contract],real type[" + this.any.getClass() + "]");
        }
        if (!dynamicStore.supportUnfreezeDelay()) {
            throw new ContractValidateException("Not support FreezeV2 transaction, need to be opened by the committee");
        }
        try {
            freezeBalanceV2Contract = (BalanceContract.FreezeBalanceV2Contract)this.any.unpack(BalanceContract.FreezeBalanceV2Contract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = freezeBalanceV2Contract.getOwnerAddress().toByteArray();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        if (accountCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        long frozenBalance = freezeBalanceV2Contract.getFrozenBalance();
        if (frozenBalance <= 0L) {
            throw new ContractValidateException("frozenBalance must be positive");
        }
        if (frozenBalance < 1000000L) {
            throw new ContractValidateException("frozenBalance must be greater than or equal to 1 TRX");
        }
        if (frozenBalance > accountCapsule.getBalance()) {
            throw new ContractValidateException("frozenBalance must be less than or equal to accountBalance");
        }
        switch (freezeBalanceV2Contract.getResource()) {
            case BANDWIDTH: 
            case ENERGY: {
                break;
            }
            case TRON_POWER: {
                if (dynamicStore.supportAllowNewResourceModel()) break;
                throw new ContractValidateException("ResourceCode error, valid ResourceCode[BANDWIDTH\u3001ENERGY]");
            }
            default: {
                if (dynamicStore.supportAllowNewResourceModel()) {
                    throw new ContractValidateException("ResourceCode error, valid ResourceCode[BANDWIDTH\u3001ENERGY\u3001TRON_POWER]");
                }
                throw new ContractValidateException("ResourceCode error, valid ResourceCode[BANDWIDTH\u3001ENERGY]");
            }
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((BalanceContract.FreezeBalanceV2Contract)this.any.unpack(BalanceContract.FreezeBalanceV2Contract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

