/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.trace;

import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.utils.ByteArray;
import org.tron.core.vm.config.VMConfig;
import org.tron.core.vm.program.invoke.ProgramInvoke;
import org.tron.core.vm.trace.Op;
import org.tron.core.vm.trace.OpActions;
import org.tron.core.vm.trace.Serializers;

public class ProgramTrace {
    private List<Op> ops = new ArrayList<Op>();
    private String result;
    private String error;
    private String contractAddress;

    public ProgramTrace() {
        this(null);
    }

    public ProgramTrace(ProgramInvoke programInvoke) {
        if (programInvoke != null && VMConfig.vmTrace()) {
            this.contractAddress = Hex.toHexString((byte[])programInvoke.getContractAddress().toTronAddress());
        }
    }

    public List<Op> getOps() {
        return this.ops;
    }

    public void setOps(List<Op> ops) {
        this.ops = ops;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public ProgramTrace result(byte[] result) {
        this.setResult(ByteArray.toHexString((byte[])result));
        return this;
    }

    public ProgramTrace error(Exception error) {
        this.setError(error == null ? "" : String.format("%s: %s", error.getClass(), error.getMessage()));
        return this;
    }

    public Op addOp(byte code2, int pc, int deep, DataWord energy, OpActions actions) {
        Op op = new Op();
        op.setActions(actions);
        op.setCode(code2 & 0xFF);
        op.setDeep(deep);
        op.setEnergy(energy.value());
        op.setPc(pc);
        this.ops.add(op);
        return op;
    }

    public void merge(ProgramTrace programTrace) {
        this.ops.addAll(programTrace.ops);
    }

    public String asJsonString(boolean formatted) {
        return Serializers.serializeFieldsOnly(this, formatted);
    }

    public String toString() {
        return this.asJsonString(true);
    }
}

