/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.repository;

import java.util.Arrays;
import java.util.Objects;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.vm.config.VMConfig;
import org.tron.core.vm.repository.Type;

public class Value<T> {
    private Type type;
    private T value;

    private Value(T value, int type) {
        if (value != null) {
            this.value = value;
            this.type = new Type(type);
        } else if (VMConfig.allowMultiSign()) {
            this.type = new Type(-4);
        }
    }

    public static <T> Value<T> create(ProtoCapsule<T> capsule, int type) {
        return new Value<Object>(capsule.getInstance(), type);
    }

    public static <T> Value<T> create(ProtoCapsule<T> capsule) {
        return Value.create(capsule, 0);
    }

    public static Value<byte[]> create(byte[] value, int type) {
        return value == null || value.length == 0 ? new Value<Object>(null, type) : new Value<byte[]>(Arrays.copyOf(value, value.length), type);
    }

    public static Value<byte[]> create(byte[] value) {
        return Value.create(value, 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Value other = (Value)obj;
        return Objects.equals(this.getValue(), other.getValue());
    }

    public int hashCode() {
        return new Integer(this.type.hashCode() + Objects.hashCode(this.value)).hashCode();
    }

    public Type getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }
}

