/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.program;

import java.util.HashMap;
import java.util.Map;
import org.tron.common.crypto.Hash;
import org.tron.common.runtime.vm.DataWord;
import org.tron.common.utils.ByteUtil;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.StorageRowCapsule;
import org.tron.core.store.StorageRowStore;

public class Storage {
    private static final int PREFIX_BYTES = 16;
    private final Map<DataWord, StorageRowCapsule> rowCache = new HashMap<DataWord, StorageRowCapsule>();
    private byte[] addrHash;
    private StorageRowStore store;
    private byte[] address;
    private int contractVersion;

    public Storage(byte[] address, StorageRowStore store) {
        this.addrHash = Storage.addrHash(address);
        this.address = address;
        this.store = store;
    }

    public Storage(Storage storage) {
        this.addrHash = (byte[])storage.addrHash.clone();
        this.address = (byte[])storage.getAddress().clone();
        this.store = storage.store;
        this.contractVersion = storage.contractVersion;
        storage.getRowCache().forEach((rowKey, row) -> {
            StorageRowCapsule newRow = new StorageRowCapsule(row);
            this.rowCache.put(rowKey.clone(), newRow);
        });
    }

    private byte[] compose(byte[] key, byte[] addrHash) {
        if (this.contractVersion == 1) {
            key = Hash.sha3((byte[])key);
        }
        byte[] result = new byte[key.length];
        System.arraycopy(addrHash, 0, result, 0, 16);
        System.arraycopy(key, 16, result, 16, 16);
        return result;
    }

    private static byte[] addrHash(byte[] address) {
        return Hash.sha3((byte[])address);
    }

    private static byte[] addrHash(byte[] address, byte[] trxHash) {
        if (ByteUtil.isNullOrZeroArray((byte[])trxHash)) {
            return Hash.sha3((byte[])address);
        }
        return Hash.sha3((byte[])ByteUtil.merge((byte[][])new byte[][]{address, trxHash}));
    }

    public void generateAddrHash(byte[] trxId) {
        this.addrHash = Storage.addrHash(this.address, trxId);
    }

    public DataWord getValue(DataWord key) {
        if (this.rowCache.containsKey(key)) {
            return new DataWord(this.rowCache.get(key).getValue());
        }
        StorageRowCapsule row = this.store.get(this.compose(key.getData(), this.addrHash));
        if (row == null || row.getInstance() == null) {
            return null;
        }
        this.rowCache.put(key, row);
        return new DataWord(row.getValue());
    }

    public void put(DataWord key, DataWord value) {
        if (this.rowCache.containsKey(key)) {
            this.rowCache.get(key).setValue(value.getData());
        } else {
            byte[] rowKey = this.compose(key.getData(), this.addrHash);
            StorageRowCapsule row = new StorageRowCapsule(rowKey, value.getData());
            this.rowCache.put(key, row);
        }
    }

    public void commit() {
        this.rowCache.forEach((rowKey, row) -> {
            if (row.isDirty()) {
                if (new DataWord(row.getValue()).isZero()) {
                    this.store.delete(row.getRowKey());
                } else {
                    this.store.put(row.getRowKey(), (ProtoCapsule)row);
                }
            }
        });
    }

    public Map<DataWord, StorageRowCapsule> getRowCache() {
        return this.rowCache;
    }

    public byte[] getAddrHash() {
        return this.addrHash;
    }

    public StorageRowStore getStore() {
        return this.store;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setContractVersion(int contractVersion) {
        this.contractVersion = contractVersion;
    }
}

