/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm.nativecontract;

import com.google.common.primitives.Bytes;
import com.google.protobuf.ByteString;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.ChainBaseManager;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.DelegatedResourceAccountIndexCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.db.BandwidthProcessor;
import org.tron.core.db.EnergyProcessor;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.DelegatedResourceAccountIndexStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.vm.nativecontract.param.DelegateResourceParam;
import org.tron.core.vm.repository.Repository;
import org.tron.protos.Protocol;

public class DelegateResourceProcessor {
    private static final Logger logger = LoggerFactory.getLogger((String)"VMProcessor");

    public void validate(DelegateResourceParam param, Repository repo) throws ContractValidateException {
        byte[] receiverAddress;
        if (repo == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        byte[] ownerAddress = param.getOwnerAddress();
        DynamicPropertiesStore dynamicStore = repo.getDynamicPropertiesStore();
        if (!dynamicStore.supportDR()) {
            throw new ContractValidateException("No support for resource delegate");
        }
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule ownerCapsule = repo.getAccount(ownerAddress);
        if (ownerCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        long delegateBalance = param.getDelegateBalance();
        if (delegateBalance < 1000000L) {
            throw new ContractValidateException("delegateBalance must be more than 1TRX");
        }
        switch (param.getResourceType()) {
            case BANDWIDTH: {
                BandwidthProcessor processor = new BandwidthProcessor(ChainBaseManager.getInstance());
                processor.updateUsageForDelegated(ownerCapsule);
                long netUsage = (long)((double)(ownerCapsule.getNetUsage() * 1000000L) * ((double)repo.getTotalNetWeight() / (double)dynamicStore.getTotalNetLimit()));
                long remainNetUsage = netUsage - ownerCapsule.getFrozenBalance() - ownerCapsule.getAcquiredDelegatedFrozenBalanceForBandwidth() - ownerCapsule.getAcquiredDelegatedFrozenV2BalanceForBandwidth();
                remainNetUsage = Math.max(0L, remainNetUsage);
                if (ownerCapsule.getFrozenV2BalanceForBandwidth() - remainNetUsage >= delegateBalance) break;
                throw new ContractValidateException("delegateBalance must be less than available FreezeBandwidthV2 balance");
            }
            case ENERGY: {
                BandwidthProcessor processor = new EnergyProcessor(dynamicStore, ChainBaseManager.getInstance().getAccountStore());
                processor.updateUsage(ownerCapsule);
                long energyUsage = (long)((double)(ownerCapsule.getEnergyUsage() * 1000000L) * ((double)repo.getTotalEnergyWeight() / (double)dynamicStore.getTotalEnergyCurrentLimit()));
                long remainEnergyUsage = energyUsage - ownerCapsule.getEnergyFrozenBalance() - ownerCapsule.getAcquiredDelegatedFrozenBalanceForEnergy() - ownerCapsule.getAcquiredDelegatedFrozenV2BalanceForEnergy();
                remainEnergyUsage = Math.max(0L, remainEnergyUsage);
                if (ownerCapsule.getFrozenV2BalanceForEnergy() - remainEnergyUsage >= delegateBalance) break;
                throw new ContractValidateException("delegateBalance must be less than available FreezeEnergyV2 balance");
            }
            default: {
                throw new ContractValidateException("Unknown ResourceCode, valid ResourceCode[BANDWIDTH\u3001ENERGY]");
            }
        }
        if (ArrayUtils.isEmpty((byte[])(receiverAddress = param.getReceiverAddress())) || !DecodeUtil.addressValid((byte[])receiverAddress)) {
            throw new ContractValidateException("Invalid receiverAddress");
        }
        if (Arrays.equals(receiverAddress, ownerAddress)) {
            throw new ContractValidateException("receiverAddress must not be the same as ownerAddress");
        }
        AccountCapsule receiverCapsule = repo.getAccount(receiverAddress);
        if (receiverCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString((byte[])receiverAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        if (receiverCapsule.getType() == Protocol.AccountType.Contract) {
            throw new ContractValidateException("Do not allow delegate resources to contract addresses");
        }
    }

    public void execute(DelegateResourceParam param, Repository repo) {
        byte[] ownerAddress = param.getOwnerAddress();
        AccountCapsule ownerCapsule = repo.getAccount(param.getOwnerAddress());
        long delegateBalance = param.getDelegateBalance();
        byte[] receiverAddress = param.getReceiverAddress();
        switch (param.getResourceType()) {
            case BANDWIDTH: {
                this.delegateResource(ownerAddress, receiverAddress, true, delegateBalance, repo);
                ownerCapsule.addDelegatedFrozenV2BalanceForBandwidth(delegateBalance);
                ownerCapsule.addFrozenBalanceForBandwidthV2(-delegateBalance);
                break;
            }
            case ENERGY: {
                this.delegateResource(ownerAddress, receiverAddress, false, delegateBalance, repo);
                ownerCapsule.addDelegatedFrozenV2BalanceForEnergy(delegateBalance);
                ownerCapsule.addFrozenBalanceForEnergyV2(-delegateBalance);
                break;
            }
            default: {
                logger.debug("Resource Code Error.");
            }
        }
        repo.updateAccount(ownerCapsule.createDbKey(), ownerCapsule);
    }

    private void delegateResource(byte[] ownerAddress, byte[] receiverAddress, boolean isBandwidth, long delegateBalance, Repository repo) {
        byte[] key = DelegatedResourceCapsule.createDbKeyV2((byte[])ownerAddress, (byte[])receiverAddress, (boolean)false);
        DelegatedResourceCapsule delegatedResourceCapsule = repo.getDelegatedResource(key);
        if (delegatedResourceCapsule == null) {
            delegatedResourceCapsule = new DelegatedResourceCapsule(ByteString.copyFrom((byte[])ownerAddress), ByteString.copyFrom((byte[])receiverAddress));
        }
        if (isBandwidth) {
            delegatedResourceCapsule.addFrozenBalanceForBandwidth(delegateBalance, 0L);
        } else {
            delegatedResourceCapsule.addFrozenBalanceForEnergy(delegateBalance, 0L);
        }
        long now = repo.getDynamicPropertiesStore().getLatestBlockHeaderTimestamp();
        byte[] fromKey = Bytes.concat((byte[][])new byte[][]{DelegatedResourceAccountIndexStore.getV2_FROM_PREFIX(), ownerAddress, receiverAddress});
        DelegatedResourceAccountIndexCapsule toIndexCapsule = new DelegatedResourceAccountIndexCapsule(ByteString.copyFrom((byte[])receiverAddress));
        toIndexCapsule.setTimestamp(now);
        repo.updateDelegatedResourceAccountIndex(fromKey, toIndexCapsule);
        byte[] toKey = Bytes.concat((byte[][])new byte[][]{DelegatedResourceAccountIndexStore.getV2_TO_PREFIX(), receiverAddress, ownerAddress});
        DelegatedResourceAccountIndexCapsule fromIndexCapsule = new DelegatedResourceAccountIndexCapsule(ByteString.copyFrom((byte[])ownerAddress));
        fromIndexCapsule.setTimestamp(now);
        repo.updateDelegatedResourceAccountIndex(toKey, fromIndexCapsule);
        AccountCapsule receiverCapsule = repo.getAccount(receiverAddress);
        if (isBandwidth) {
            receiverCapsule.addAcquiredDelegatedFrozenV2BalanceForBandwidth(delegateBalance);
        } else {
            receiverCapsule.addAcquiredDelegatedFrozenV2BalanceForEnergy(delegateBalance);
        }
        repo.updateDelegatedResource(key, delegatedResourceCapsule);
        repo.updateAccount(receiverCapsule.createDbKey(), receiverCapsule);
    }
}

