/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.logsfilter.trigger.ContractTrigger;
import org.tron.common.runtime.vm.LogInfo;
import org.tron.common.utils.StringUtil;
import org.tron.core.capsule.AbiCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.db.TransactionTrace;
import org.tron.core.store.StoreFactory;
import org.tron.core.vm.repository.Repository;
import org.tron.protos.contract.SmartContractOuterClass;

public class LogInfoTriggerParser {
    private static final Logger logger = LoggerFactory.getLogger(LogInfoTriggerParser.class);
    private Long blockNum;
    private Long blockTimestamp;
    private String txId;
    private String originAddress;

    public LogInfoTriggerParser(Long blockNum, Long blockTimestamp, byte[] txId, byte[] originAddress) {
        this.blockNum = blockNum;
        this.blockTimestamp = blockTimestamp;
        this.txId = ArrayUtils.isEmpty((byte[])txId) ? "" : Hex.toHexString((byte[])txId);
        this.originAddress = ArrayUtils.isEmpty((byte[])originAddress) ? "" : StringUtil.encode58Check((byte[])originAddress);
    }

    public static String getEntrySignature(SmartContractOuterClass.SmartContract.ABI.Entry entry) {
        String signature = entry.getName() + "(";
        StringBuilder builder = new StringBuilder();
        for (SmartContractOuterClass.SmartContract.ABI.Entry.Param param : entry.getInputsList()) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(param.getType());
        }
        signature = signature + builder.toString() + ")";
        return signature;
    }

    public List<ContractTrigger> parseLogInfos(List<LogInfo> logInfos, Repository deposit) {
        String creatorAddr;
        LinkedList<ContractTrigger> list = new LinkedList<ContractTrigger>();
        if (logInfos == null || logInfos.size() <= 0) {
            return list;
        }
        HashMap<String, String> addrMap = new HashMap<String, String>();
        HashMap<String, SmartContractOuterClass.SmartContract.ABI> abiMap = new HashMap<String, SmartContractOuterClass.SmartContract.ABI>();
        for (LogInfo logInfo : logInfos) {
            byte[] contractAddress = TransactionTrace.convertToTronAddress((byte[])logInfo.getAddress());
            String strContractAddr = ArrayUtils.isEmpty((byte[])contractAddress) ? "" : StringUtil.encode58Check((byte[])contractAddress);
            if (addrMap.get(strContractAddr) != null) continue;
            ContractCapsule contract = deposit.getContract(contractAddress);
            if (contract == null) {
                addrMap.put(strContractAddr, this.originAddress);
                abiMap.put(strContractAddr, SmartContractOuterClass.SmartContract.ABI.getDefaultInstance());
                continue;
            }
            AbiCapsule abiCapsule = StoreFactory.getInstance().getChainBaseManager().getAbiStore().get(contractAddress);
            SmartContractOuterClass.SmartContract.ABI abi = abiCapsule == null || abiCapsule.getInstance() == null ? SmartContractOuterClass.SmartContract.ABI.getDefaultInstance() : abiCapsule.getInstance();
            creatorAddr = StringUtil.encode58Check((byte[])TransactionTrace.convertToTronAddress((byte[])contract.getInstance().getOriginAddress().toByteArray()));
            addrMap.put(strContractAddr, creatorAddr);
            abiMap.put(strContractAddr, abi);
        }
        int index = 1;
        for (LogInfo logInfo : logInfos) {
            byte[] contractAddress = TransactionTrace.convertToTronAddress((byte[])logInfo.getAddress());
            String strContractAddr = ArrayUtils.isEmpty((byte[])contractAddress) ? "" : StringUtil.encode58Check((byte[])contractAddress);
            SmartContractOuterClass.SmartContract.ABI abi = (SmartContractOuterClass.SmartContract.ABI)abiMap.get(strContractAddr);
            ContractTrigger event = new ContractTrigger();
            creatorAddr = (String)addrMap.get(strContractAddr);
            event.setUniqueId(this.txId + "_" + index);
            event.setTransactionId(this.txId);
            event.setContractAddress(strContractAddr);
            event.setOriginAddress(this.originAddress);
            event.setCallerAddress("");
            event.setCreatorAddress(StringUtils.isEmpty((CharSequence)creatorAddr) ? "" : creatorAddr);
            event.setBlockNumber(this.blockNum);
            event.setTimeStamp(this.blockTimestamp.longValue());
            event.setLogInfo(logInfo);
            event.setAbi(abi);
            list.add(event);
            ++index;
        }
        return list;
    }
}

