/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.vm;

import java.math.BigInteger;
import org.tron.common.runtime.vm.DataWord;
import org.tron.core.vm.Op;
import org.tron.core.vm.config.VMConfig;
import org.tron.core.vm.program.Program;
import org.tron.core.vm.program.Stack;

public class EnergyCost {
    private static final long ZERO_TIER = 0L;
    private static final long BASE_TIER = 2L;
    private static final long VERY_LOW_TIER = 3L;
    private static final long LOW_TIER = 5L;
    private static final long MID_TIER = 8L;
    private static final long HIGH_TIER = 10L;
    private static final long EXT_TIER = 20L;
    private static final long SPECIAL_TIER = 1L;
    private static final long EXP_ENERGY = 10L;
    private static final long EXP_BYTE_ENERGY = 10L;
    private static final long SHA3 = 30L;
    private static final BigInteger MEM_LIMIT = BigInteger.valueOf(0x300000L);
    private static final long MEMORY = 3L;
    private static final long COPY_ENERGY = 3L;
    private static final long SHA3_WORD = 6L;
    private static final long SLOAD = 50L;
    private static final long CLEAR_SSTORE = 5000L;
    private static final long SET_SSTORE = 20000L;
    private static final long RESET_SSTORE = 5000L;
    private static final long LOG_DATA_ENERGY = 8L;
    private static final long LOG_ENERGY = 375L;
    private static final long LOG_TOPIC_ENERGY = 375L;
    private static final long BALANCE = 20L;
    private static final long FREEZE = 20000L;
    private static final long NEW_ACCT_CALL = 25000L;
    private static final long UNFREEZE = 20000L;
    private static final long FREEZE_EXPIRE_TIME = 50L;
    private static final long FREEZE_V2 = 10000L;
    private static final long UNFREEZE_V2 = 10000L;
    private static final long WITHDRAW_EXPIRE_UNFREEZE = 10000L;
    private static final long CANCEL_ALL_UNFREEZE_V2 = 10000L;
    private static final long DELEGATE_RESOURCE = 10000L;
    private static final long UN_DELEGATE_RESOURCE = 10000L;
    private static final long VOTE_WITNESS = 30000L;
    private static final long WITHDRAW_REWARD = 20000L;
    private static final long CREATE = 32000L;
    private static final long CALL_ENERGY = 40L;
    private static final long VT_CALL = 9000L;
    private static final long STIPEND_CALL = 2300L;
    private static final long EXT_CODE_COPY = 20L;
    private static final long EXT_CODE_SIZE = 20L;
    private static final long EXT_CODE_HASH = 400L;
    private static final long SUICIDE = 0L;
    private static final long STOP = 0L;
    private static final long CREATE_DATA = 200L;

    public static long getZeroTierCost(Program ignored) {
        return 0L;
    }

    public static long getVeryLowTierCost(Program ignored) {
        return 3L;
    }

    public static long getLowTierCost(Program ignored) {
        return 5L;
    }

    public static long getMidTierCost(Program ignored) {
        return 8L;
    }

    public static long getBaseTierCost(Program ignored) {
        return 2L;
    }

    public static long getExtTierCost(Program ignored) {
        return 20L;
    }

    public static long getHighTierCost(Program ignored) {
        return 10L;
    }

    public static long getSpecialTierCost(Program ignored) {
        return 1L;
    }

    public static long getStipendCallCost() {
        return 2300L;
    }

    public static long getExpCost(Program program) {
        Stack stack = program.getStack();
        DataWord exp = (DataWord)stack.get(stack.size() - 2);
        int bytesOccupied = exp.bytesOccupied();
        return 10L + 10L * (long)bytesOccupied;
    }

    public static long getExtCodeSizeCost(Program ignored) {
        return 20L;
    }

    public static long getSha3Cost(Program program) {
        Stack stack = program.getStack();
        long oldMemSize = program.getMemSize();
        long energyCost = 30L + EnergyCost.calcMemEnergy(oldMemSize, EnergyCost.memNeeded((DataWord)stack.peek(), (DataWord)stack.get(stack.size() - 2)), 0L, 32);
        DataWord size = (DataWord)stack.get(stack.size() - 2);
        long chunkUsed = (size.longValueSafe() + 31L) / 32L;
        return energyCost += chunkUsed * 6L;
    }

    public static long getCodeCopyCost(Program program) {
        Stack stack = program.getStack();
        long oldMemSize = program.getMemSize();
        long energyCost = EnergyCost.calcMemEnergy(oldMemSize, EnergyCost.memNeeded((DataWord)stack.peek(), (DataWord)stack.get(stack.size() - 3)), ((DataWord)stack.get(stack.size() - 3)).longValueSafe(), 57);
        return energyCost;
    }

    public static long getReturnDataCopyCost(Program program) {
        Stack stack = program.getStack();
        long oldMemSize = program.getMemSize();
        long energyCost = EnergyCost.calcMemEnergy(oldMemSize, EnergyCost.memNeeded((DataWord)stack.peek(), (DataWord)stack.get(stack.size() - 3)), ((DataWord)stack.get(stack.size() - 3)).longValueSafe(), 62);
        return energyCost;
    }

    public static long getCallDataCopyCost(Program program) {
        Stack stack = program.getStack();
        long oldMemSize = program.getMemSize();
        long energyCost = EnergyCost.calcMemEnergy(oldMemSize, EnergyCost.memNeeded((DataWord)stack.peek(), (DataWord)stack.get(stack.size() - 3)), ((DataWord)stack.get(stack.size() - 3)).longValueSafe(), 55);
        return energyCost;
    }

    public static long getExtCodeCopyCost(Program program) {
        Stack stack = program.getStack();
        long oldMemSize = program.getMemSize();
        long energyCost = 20L + EnergyCost.calcMemEnergy(oldMemSize, EnergyCost.memNeeded((DataWord)stack.get(stack.size() - 2), (DataWord)stack.get(stack.size() - 4)), ((DataWord)stack.get(stack.size() - 4)).longValueSafe(), 60);
        return energyCost;
    }

    public static long getExtCodeHashCost(Program ignored) {
        return 400L;
    }

    public static long getMloadCost(Program program) {
        Stack stack = program.getStack();
        long oldMemSize = program.getMemSize();
        return EnergyCost.calcMemEnergy(oldMemSize, EnergyCost.memNeeded((DataWord)stack.peek(), new DataWord(32)), 0L, 81);
    }

    public static long getMloadCost2(Program program) {
        return 1L + EnergyCost.getMloadCost(program);
    }

    public static long getMStoreCost(Program program) {
        Stack stack = program.getStack();
        long oldMemSize = program.getMemSize();
        return EnergyCost.calcMemEnergy(oldMemSize, EnergyCost.memNeeded((DataWord)stack.peek(), new DataWord(32)), 0L, 82);
    }

    public static long getMStoreCost2(Program program) {
        return 1L + EnergyCost.getMStoreCost(program);
    }

    public static long getMStore8Cost(Program program) {
        Stack stack = program.getStack();
        long oldMemSize = program.getMemSize();
        return EnergyCost.calcMemEnergy(oldMemSize, EnergyCost.memNeeded((DataWord)stack.peek(), DataWord.ONE()), 0L, 83);
    }

    public static long getMStore8Cost2(Program program) {
        return 1L + EnergyCost.getMStore8Cost(program);
    }

    public static long getSloadCost(Program ignored) {
        return 50L;
    }

    public static long getReturnCost(Program program) {
        Stack stack = program.getStack();
        long oldMemSize = program.getMemSize();
        long energyCost = 0L + EnergyCost.calcMemEnergy(oldMemSize, EnergyCost.memNeeded((DataWord)stack.peek(), (DataWord)stack.get(stack.size() - 2)), 0L, 243);
        return energyCost;
    }

    public static long getRevertCost(Program program) {
        Stack stack = program.getStack();
        long oldMemSize = program.getMemSize();
        long energyCost = 0L + EnergyCost.calcMemEnergy(oldMemSize, EnergyCost.memNeeded((DataWord)stack.peek(), (DataWord)stack.get(stack.size() - 2)), 0L, 253);
        return energyCost;
    }

    public static long getSstoreCost(Program program) {
        Stack stack = program.getStack();
        DataWord newValue = (DataWord)stack.get(stack.size() - 2);
        DataWord oldValue = program.storageLoad((DataWord)stack.peek());
        if (oldValue == null && !newValue.isZero()) {
            return 20000L;
        }
        if (oldValue != null && newValue.isZero()) {
            return 5000L;
        }
        return 5000L;
    }

    public static long getLogCost(Program program) {
        Stack stack = program.getStack();
        long oldMemSize = program.getMemSize();
        int opIntValue = program.getCurrentOpIntValue();
        int nTopics = opIntValue - 160;
        BigInteger dataSize = ((DataWord)stack.get(stack.size() - 2)).value();
        BigInteger dataCost = dataSize.multiply(BigInteger.valueOf(8L));
        if (program.getEnergyLimitLeft().value().compareTo(dataCost) < 0) {
            throw new Program.OutOfEnergyException("Not enough energy for '%s' operation executing: opEnergy[%d], programEnergy[%d]", Op.getNameOf(opIntValue), dataCost.longValueExact(), program.getEnergyLimitLeft().longValueSafe());
        }
        long energyCost = 375L + 375L * (long)nTopics + 8L * ((DataWord)stack.get(stack.size() - 2)).longValue() + EnergyCost.calcMemEnergy(oldMemSize, EnergyCost.memNeeded((DataWord)stack.peek(), (DataWord)stack.get(stack.size() - 2)), 0L, opIntValue);
        EnergyCost.checkMemorySize(opIntValue, EnergyCost.memNeeded((DataWord)stack.peek(), (DataWord)stack.get(stack.size() - 2)));
        return energyCost;
    }

    public static long getSuicideCost(Program ignored) {
        return 0L;
    }

    public static long getBalanceCost(Program ignored) {
        return 20L;
    }

    public static long getFreezeCost(Program program) {
        Stack stack = program.getStack();
        DataWord receiverAddressWord = (DataWord)stack.get(stack.size() - 3);
        if (EnergyCost.isDeadAccount(program, receiverAddressWord)) {
            return 45000L;
        }
        return 20000L;
    }

    public static long getUnfreezeCost(Program ignored) {
        return 20000L;
    }

    public static long getFreezeExpireTimeCost(Program ignored) {
        return 50L;
    }

    public static long getFreezeBalanceV2Cost(Program ignored) {
        return 10000L;
    }

    public static long getUnfreezeBalanceV2Cost(Program ignored) {
        return 10000L;
    }

    public static long getWithdrawExpireUnfreezeCost(Program ignored) {
        return 10000L;
    }

    public static long getCancelAllUnfreezeV2Cost(Program ignored) {
        return 10000L;
    }

    public static long getDelegateResourceCost(Program ignored) {
        return 10000L;
    }

    public static long getUnDelegateResourceCost(Program ignored) {
        return 10000L;
    }

    public static long getVoteWitnessCost(Program program) {
        Stack stack = program.getStack();
        long oldMemSize = program.getMemSize();
        DataWord amountArrayLength = ((DataWord)stack.get(stack.size() - 1)).clone();
        DataWord amountArrayOffset = (DataWord)stack.get(stack.size() - 2);
        DataWord witnessArrayLength = ((DataWord)stack.get(stack.size() - 3)).clone();
        DataWord witnessArrayOffset = (DataWord)stack.get(stack.size() - 4);
        DataWord wordSize = new DataWord(32);
        amountArrayLength.mul(wordSize);
        BigInteger amountArrayMemoryNeeded = EnergyCost.memNeeded(amountArrayOffset, amountArrayLength);
        witnessArrayLength.mul(wordSize);
        BigInteger witnessArrayMemoryNeeded = EnergyCost.memNeeded(witnessArrayOffset, witnessArrayLength);
        return 30000L + EnergyCost.calcMemEnergy(oldMemSize, amountArrayMemoryNeeded.compareTo(witnessArrayMemoryNeeded) > 0 ? amountArrayMemoryNeeded : witnessArrayMemoryNeeded, 0L, 216);
    }

    public static long getWithdrawRewardCost(Program ignored) {
        return 20000L;
    }

    public static long getCreateCost(Program program) {
        Stack stack = program.getStack();
        long oldMemSize = program.getMemSize();
        return 32000L + EnergyCost.calcMemEnergy(oldMemSize, EnergyCost.memNeeded((DataWord)stack.get(stack.size() - 2), (DataWord)stack.get(stack.size() - 3)), 0L, 240);
    }

    public static long getCreate2Cost(Program program) {
        Stack stack = program.getStack();
        long oldMemSize = program.getMemSize();
        DataWord codeSize = (DataWord)stack.get(stack.size() - 3);
        long energyCost = 32000L;
        return (energyCost += EnergyCost.calcMemEnergy(oldMemSize, EnergyCost.memNeeded((DataWord)stack.get(stack.size() - 2), (DataWord)stack.get(stack.size() - 3)), 0L, 245)) + DataWord.sizeInWords((long)codeSize.intValueSafe()) * 6L;
    }

    public static long getCallCost(Program program) {
        Stack stack = program.getStack();
        long energyCost = 40L;
        DataWord callAddressWord = (DataWord)stack.get(stack.size() - 2);
        DataWord value = (DataWord)stack.get(stack.size() - 3);
        int opOff = 4;
        if (!value.isZero()) {
            energyCost += 9000L;
            if (EnergyCost.isDeadAccount(program, callAddressWord)) {
                energyCost += 25000L;
            }
        }
        return EnergyCost.getCalculateCallCost(stack, program, energyCost, opOff);
    }

    public static long getStaticCallCost(Program program) {
        Stack stack = program.getStack();
        long energyCost = 40L;
        int opOff = 3;
        return EnergyCost.getCalculateCallCost(stack, program, energyCost, opOff);
    }

    public static long getDelegateCallCost(Program program) {
        Stack stack = program.getStack();
        long energyCost = 40L;
        int opOff = 3;
        return EnergyCost.getCalculateCallCost(stack, program, energyCost, opOff);
    }

    public static long getCallCodeCost(Program program) {
        Stack stack = program.getStack();
        long energyCost = 40L;
        DataWord value = (DataWord)stack.get(stack.size() - 3);
        int opOff = 4;
        if (!value.isZero()) {
            energyCost += 9000L;
        }
        return EnergyCost.getCalculateCallCost(stack, program, energyCost, opOff);
    }

    public static long getCallTokenCost(Program program) {
        Stack stack = program.getStack();
        long energyCost = 40L;
        DataWord callAddressWord = (DataWord)stack.get(stack.size() - 2);
        DataWord value = (DataWord)stack.get(stack.size() - 3);
        int opOff = 5;
        if (!value.isZero()) {
            energyCost += 9000L;
            if (EnergyCost.isDeadAccount(program, callAddressWord)) {
                energyCost += 25000L;
            }
        }
        return EnergyCost.getCalculateCallCost(stack, program, energyCost, opOff);
    }

    public static long getCalculateCallCost(Stack stack, Program program, long energyCost, int opOff) {
        long factor;
        int op = program.getCurrentOpIntValue();
        long oldMemSize = program.getMemSize();
        DataWord callEnergyWord = (DataWord)stack.get(stack.size() - 1);
        BigInteger in = EnergyCost.memNeeded((DataWord)stack.get(stack.size() - opOff), (DataWord)stack.get(stack.size() - opOff - 1));
        BigInteger out = EnergyCost.memNeeded((DataWord)stack.get(stack.size() - opOff - 2), (DataWord)stack.get(stack.size() - opOff - 3));
        energyCost += EnergyCost.calcMemEnergy(oldMemSize, in.max(out), 0L, op);
        if (VMConfig.allowDynamicEnergy() && (factor = program.getContextContractFactor()) > 10000L) {
            long penalty = energyCost * factor / 10000L - energyCost;
            if (penalty < 0L) {
                penalty = 0L;
            }
            program.setCallPenaltyEnergy(penalty);
            energyCost += penalty;
        }
        if (energyCost > program.getEnergyLimitLeft().longValueSafe()) {
            throw new Program.OutOfEnergyException("Not enough energy for '%s' operation executing: opEnergy[%d], programEnergy[%d]", Op.getNameOf(op), energyCost, program.getEnergyLimitLeft().longValueSafe());
        }
        DataWord getEnergyLimitLeft = program.getEnergyLimitLeft().clone();
        getEnergyLimitLeft.sub(new DataWord(energyCost));
        DataWord adjustedCallEnergy = program.getCallEnergy(callEnergyWord, getEnergyLimitLeft);
        program.setAdjustedCallEnergy(adjustedCallEnergy);
        return energyCost += adjustedCallEnergy.longValueSafe();
    }

    public static long getNewAcctCall() {
        return 25000L;
    }

    public static long getCreateData() {
        return 200L;
    }

    private static long calcMemEnergy(long oldMemSize, BigInteger newMemSize, long copySize, int op) {
        long energyCost = 0L;
        EnergyCost.checkMemorySize(op, newMemSize);
        long memoryUsage = (newMemSize.longValueExact() + 31L) / 32L * 32L;
        if (memoryUsage > oldMemSize) {
            long memWords = memoryUsage / 32L;
            long memWordsOld = oldMemSize / 32L;
            long memEnergy = 3L * memWords + memWords * memWords / 512L - (3L * memWordsOld + memWordsOld * memWordsOld / 512L);
            energyCost += memEnergy;
        }
        if (copySize > 0L) {
            long copyEnergy = 3L * ((copySize + 31L) / 32L);
            energyCost += copyEnergy;
        }
        return energyCost;
    }

    private static void checkMemorySize(int op, BigInteger newMemSize) {
        if (newMemSize.compareTo(MEM_LIMIT) > 0) {
            throw Program.Exception.memoryOverflow(op);
        }
    }

    private static BigInteger memNeeded(DataWord offset, DataWord size) {
        return size.isZero() ? BigInteger.ZERO : offset.value().add(size.value());
    }

    private static boolean isDeadAccount(Program program, DataWord address) {
        return program.getContractState().getAccount(address.toTronAddress()) == null;
    }
}

