/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.common.math.LongMath;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.parameter.CommonParameter;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.service.MortgageService;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.BalanceContract;

public class WithdrawBalanceActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public WithdrawBalanceActuator() {
        super(Protocol.Transaction.Contract.ContractType.WithdrawBalanceContract, BalanceContract.WithdrawBalanceContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        BalanceContract.WithdrawBalanceContract withdrawBalanceContract;
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        MortgageService mortgageService = this.chainBaseManager.getMortgageService();
        try {
            withdrawBalanceContract = (BalanceContract.WithdrawBalanceContract)this.any.unpack(BalanceContract.WithdrawBalanceContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        mortgageService.withdrawReward(withdrawBalanceContract.getOwnerAddress().toByteArray());
        AccountCapsule accountCapsule = accountStore.get(withdrawBalanceContract.getOwnerAddress().toByteArray());
        long oldBalance = accountCapsule.getBalance();
        long allowance = accountCapsule.getAllowance();
        long now = dynamicStore.getLatestBlockHeaderTimestamp();
        accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().setBalance(oldBalance + allowance).setAllowance(0L).setLatestWithdrawTime(now).build());
        accountStore.put(accountCapsule.createDbKey(), accountCapsule);
        ret.setWithdrawAmount(allowance);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    public boolean validate() throws ContractValidateException {
        long witnessAllowanceFrozenTime;
        BalanceContract.WithdrawBalanceContract withdrawBalanceContract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        MortgageService mortgageService = this.chainBaseManager.getMortgageService();
        if (!this.any.is(BalanceContract.WithdrawBalanceContract.class)) {
            throw new ContractValidateException("contract type error, expected type [WithdrawBalanceContract], real type[" + this.any.getClass() + "]");
        }
        try {
            withdrawBalanceContract = (BalanceContract.WithdrawBalanceContract)this.any.unpack(BalanceContract.WithdrawBalanceContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = withdrawBalanceContract.getOwnerAddress().toByteArray();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        if (accountCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
        boolean isGP = CommonParameter.getInstance().getGenesisBlock().getWitnesses().stream().anyMatch(witness -> Arrays.equals(ownerAddress, witness.getAddress()));
        if (isGP) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] is a guard representative and is not allowed to withdraw Balance");
        }
        long latestWithdrawTime = accountCapsule.getLatestWithdrawTime();
        long now = dynamicStore.getLatestBlockHeaderTimestamp();
        if (now - latestWithdrawTime < (witnessAllowanceFrozenTime = (long)dynamicStore.getWitnessAllowanceFrozenTime() * 86400000L)) {
            throw new ContractValidateException("The last withdraw time is " + latestWithdrawTime + ", less than 24 hours");
        }
        if (accountCapsule.getAllowance() <= 0L && mortgageService.queryReward(ownerAddress) <= 0L) {
            throw new ContractValidateException("witnessAccount does not have any reward");
        }
        try {
            LongMath.checkedAdd((long)accountCapsule.getBalance(), (long)accountCapsule.getAllowance());
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((BalanceContract.WithdrawBalanceContract)this.any.unpack(BalanceContract.WithdrawBalanceContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

