/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.common.math.LongMath;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Iterator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.service.MortgageService;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.VotesStore;
import org.tron.core.store.WitnessStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.WitnessContract;

public class VoteWitnessActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public VoteWitnessActuator() {
        super(Protocol.Transaction.Contract.ContractType.VoteWitnessContract, WitnessContract.VoteWitnessContract.class);
    }

    public boolean execute(Object object) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)object;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        try {
            WitnessContract.VoteWitnessContract voteContract = (WitnessContract.VoteWitnessContract)this.any.unpack(WitnessContract.VoteWitnessContract.class);
            this.countVoteAccount(voteContract);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        WitnessContract.VoteWitnessContract contract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        WitnessStore witnessStore = this.chainBaseManager.getWitnessStore();
        if (!this.any.is(WitnessContract.VoteWitnessContract.class)) {
            throw new ContractValidateException("contract type error, expected type [VoteWitnessContract], real type[" + this.any.getClass() + "]");
        }
        try {
            contract = (WitnessContract.VoteWitnessContract)this.any.unpack(WitnessContract.VoteWitnessContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        if (!DecodeUtil.addressValid((byte[])contract.getOwnerAddress().toByteArray())) {
            throw new ContractValidateException("Invalid address");
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
        if (contract.getVotesCount() == 0) {
            throw new ContractValidateException("VoteNumber must more than 0");
        }
        int maxVoteNumber = 30;
        if (contract.getVotesCount() > maxVoteNumber) {
            throw new ContractValidateException("VoteNumber more than maxVoteNumber " + maxVoteNumber);
        }
        try {
            Iterator iterator = contract.getVotesList().iterator();
            Long sum = 0L;
            while (iterator.hasNext()) {
                WitnessContract.VoteWitnessContract.Vote vote = (WitnessContract.VoteWitnessContract.Vote)iterator.next();
                byte[] witnessCandidate = vote.getVoteAddress().toByteArray();
                if (!DecodeUtil.addressValid((byte[])witnessCandidate)) {
                    throw new ContractValidateException("Invalid vote address!");
                }
                long voteCount = vote.getVoteCount();
                if (voteCount <= 0L) {
                    throw new ContractValidateException("vote count must be greater than 0");
                }
                String readableWitnessAddress = StringUtil.createReadableString((ByteString)vote.getVoteAddress());
                if (!accountStore.has(witnessCandidate)) {
                    throw new ContractValidateException("Account[" + readableWitnessAddress + "] not exists");
                }
                if (!witnessStore.has(witnessCandidate)) {
                    throw new ContractValidateException("Witness[" + readableWitnessAddress + "] not exists");
                }
                sum = LongMath.checkedAdd((long)sum, (long)vote.getVoteCount());
            }
            AccountCapsule accountCapsule = accountStore.get(ownerAddress);
            if (accountCapsule == null) {
                throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
            }
            DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
            long tronPower = dynamicStore.supportAllowNewResourceModel() ? accountCapsule.getAllTronPower() : accountCapsule.getTronPower();
            if ((sum = Long.valueOf(LongMath.checkedMultiply((long)sum, (long)1000000L))) > tronPower) {
                throw new ContractValidateException("The total number of votes[" + sum + "] is greater than the tronPower[" + tronPower + "]");
            }
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        return true;
    }

    private void countVoteAccount(WitnessContract.VoteWitnessContract voteContract) {
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        VotesStore votesStore = this.chainBaseManager.getVotesStore();
        MortgageService mortgageService = this.chainBaseManager.getMortgageService();
        byte[] ownerAddress = voteContract.getOwnerAddress().toByteArray();
        mortgageService.withdrawReward(ownerAddress);
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        if (dynamicStore.supportAllowNewResourceModel() && accountCapsule.oldTronPowerIsNotInitialized()) {
            accountCapsule.initializeOldTronPower();
        }
        VotesCapsule votesCapsule = !votesStore.has(ownerAddress) ? new VotesCapsule(voteContract.getOwnerAddress(), accountCapsule.getVotesList()) : votesStore.get(ownerAddress);
        accountCapsule.clearVotes();
        votesCapsule.clearNewVotes();
        voteContract.getVotesList().forEach(vote -> {
            logger.debug("countVoteAccount, address[{}]", (Object)ByteArray.toHexString((byte[])vote.getVoteAddress().toByteArray()));
            votesCapsule.addNewVotes(vote.getVoteAddress(), vote.getVoteCount());
            accountCapsule.addVotes(vote.getVoteAddress(), vote.getVoteCount());
        });
        accountStore.put(accountCapsule.createDbKey(), accountCapsule);
        votesStore.put(ownerAddress, (ProtoCapsule)votesCapsule);
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((WitnessContract.VoteWitnessContract)this.any.unpack(WitnessContract.VoteWitnessContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

