/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.DelegatedResourceAccountIndexCapsule;
import org.tron.core.capsule.DelegatedResourceCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.VotesCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.service.MortgageService;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DelegatedResourceAccountIndexStore;
import org.tron.core.store.DelegatedResourceStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.VotesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.BalanceContract;

public class UnfreezeBalanceActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");
    private static final String INVALID_RESOURCE_CODE = "ResourceCode error.valid ResourceCode[BANDWIDTH\u3001Energy]";

    public UnfreezeBalanceActuator() {
        super(Protocol.Transaction.Contract.ContractType.UnfreezeBalanceContract, BalanceContract.UnfreezeBalanceContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        BalanceContract.UnfreezeBalanceContract unfreezeBalanceContract;
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        DelegatedResourceStore delegatedResourceStore = this.chainBaseManager.getDelegatedResourceStore();
        DelegatedResourceAccountIndexStore delegatedResourceAccountIndexStore = this.chainBaseManager.getDelegatedResourceAccountIndexStore();
        VotesStore votesStore = this.chainBaseManager.getVotesStore();
        MortgageService mortgageService = this.chainBaseManager.getMortgageService();
        try {
            unfreezeBalanceContract = (BalanceContract.UnfreezeBalanceContract)this.any.unpack(BalanceContract.UnfreezeBalanceContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        byte[] ownerAddress = unfreezeBalanceContract.getOwnerAddress().toByteArray();
        mortgageService.withdrawReward(ownerAddress);
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        long oldBalance = accountCapsule.getBalance();
        long unfreezeBalance = 0L;
        if (dynamicStore.supportAllowNewResourceModel() && accountCapsule.oldTronPowerIsNotInitialized()) {
            accountCapsule.initializeOldTronPower();
        }
        byte[] receiverAddress = unfreezeBalanceContract.getReceiverAddress().toByteArray();
        long decrease = 0L;
        if (!ArrayUtils.isEmpty((byte[])receiverAddress) && dynamicStore.supportDR()) {
            byte[] key = DelegatedResourceCapsule.createDbKey((byte[])unfreezeBalanceContract.getOwnerAddress().toByteArray(), (byte[])unfreezeBalanceContract.getReceiverAddress().toByteArray());
            DelegatedResourceCapsule delegatedResourceCapsule = delegatedResourceStore.get(key);
            switch (unfreezeBalanceContract.getResource()) {
                case BANDWIDTH: {
                    unfreezeBalance = delegatedResourceCapsule.getFrozenBalanceForBandwidth();
                    delegatedResourceCapsule.setFrozenBalanceForBandwidth(0L, 0L);
                    accountCapsule.addDelegatedFrozenBalanceForBandwidth(-unfreezeBalance);
                    break;
                }
                case ENERGY: {
                    unfreezeBalance = delegatedResourceCapsule.getFrozenBalanceForEnergy();
                    delegatedResourceCapsule.setFrozenBalanceForEnergy(0L, 0L);
                    accountCapsule.addDelegatedFrozenBalanceForEnergy(-unfreezeBalance);
                    break;
                }
            }
            AccountCapsule receiverCapsule = accountStore.get(receiverAddress);
            if (dynamicStore.getAllowTvmConstantinople() == 0L || receiverCapsule != null && receiverCapsule.getType() != Protocol.AccountType.Contract) {
                switch (unfreezeBalanceContract.getResource()) {
                    case BANDWIDTH: {
                        long oldNetWeight = receiverCapsule.getAcquiredDelegatedFrozenBalanceForBandwidth() / 1000000L;
                        if (dynamicStore.getAllowTvmSolidity059() == 1L && receiverCapsule.getAcquiredDelegatedFrozenBalanceForBandwidth() < unfreezeBalance) {
                            oldNetWeight = unfreezeBalance / 1000000L;
                            receiverCapsule.setAcquiredDelegatedFrozenBalanceForBandwidth(0L);
                        } else {
                            receiverCapsule.addAcquiredDelegatedFrozenBalanceForBandwidth(-unfreezeBalance);
                        }
                        long newNetWeight = receiverCapsule.getAcquiredDelegatedFrozenBalanceForBandwidth() / 1000000L;
                        decrease = newNetWeight - oldNetWeight;
                        break;
                    }
                    case ENERGY: {
                        long oldEnergyWeight = receiverCapsule.getAcquiredDelegatedFrozenBalanceForEnergy() / 1000000L;
                        if (dynamicStore.getAllowTvmSolidity059() == 1L && receiverCapsule.getAcquiredDelegatedFrozenBalanceForEnergy() < unfreezeBalance) {
                            oldEnergyWeight = unfreezeBalance / 1000000L;
                            receiverCapsule.setAcquiredDelegatedFrozenBalanceForEnergy(0L);
                        } else {
                            receiverCapsule.addAcquiredDelegatedFrozenBalanceForEnergy(-unfreezeBalance);
                        }
                        long newEnergyWeight = receiverCapsule.getAcquiredDelegatedFrozenBalanceForEnergy() / 1000000L;
                        decrease = newEnergyWeight - oldEnergyWeight;
                        break;
                    }
                }
                accountStore.put(receiverCapsule.createDbKey(), receiverCapsule);
            } else {
                decrease = -unfreezeBalance / 1000000L;
            }
            accountCapsule.setBalance(oldBalance + unfreezeBalance);
            if (delegatedResourceCapsule.getFrozenBalanceForBandwidth() == 0L && delegatedResourceCapsule.getFrozenBalanceForEnergy() == 0L) {
                delegatedResourceStore.delete(key);
                if (!dynamicStore.supportAllowDelegateOptimization()) {
                    DelegatedResourceAccountIndexCapsule receiverIndexCapsule;
                    DelegatedResourceAccountIndexCapsule ownerIndexCapsule = delegatedResourceAccountIndexStore.get(ownerAddress);
                    if (ownerIndexCapsule != null) {
                        ArrayList toAccountsList = new ArrayList(ownerIndexCapsule.getToAccountsList());
                        toAccountsList.remove(ByteString.copyFrom((byte[])receiverAddress));
                        ownerIndexCapsule.setAllToAccounts(toAccountsList);
                        delegatedResourceAccountIndexStore.put(ownerAddress, (ProtoCapsule)ownerIndexCapsule);
                    }
                    if ((receiverIndexCapsule = delegatedResourceAccountIndexStore.get(receiverAddress)) != null) {
                        ArrayList fromAccountsList = new ArrayList(receiverIndexCapsule.getFromAccountsList());
                        fromAccountsList.remove(ByteString.copyFrom((byte[])ownerAddress));
                        receiverIndexCapsule.setAllFromAccounts(fromAccountsList);
                        delegatedResourceAccountIndexStore.put(receiverAddress, (ProtoCapsule)receiverIndexCapsule);
                    }
                } else {
                    delegatedResourceAccountIndexStore.convert(ownerAddress);
                    delegatedResourceAccountIndexStore.convert(receiverAddress);
                    delegatedResourceAccountIndexStore.unDelegate(ownerAddress, receiverAddress);
                }
            } else {
                delegatedResourceStore.put(key, (ProtoCapsule)delegatedResourceCapsule);
            }
        } else {
            switch (unfreezeBalanceContract.getResource()) {
                case BANDWIDTH: {
                    long oldNetWeight = accountCapsule.getFrozenBalance() / 1000000L;
                    ArrayList frozenList = Lists.newArrayList();
                    frozenList.addAll(accountCapsule.getFrozenList());
                    Iterator iterator = frozenList.iterator();
                    long now = dynamicStore.getLatestBlockHeaderTimestamp();
                    while (iterator.hasNext()) {
                        Protocol.Account.Frozen next = (Protocol.Account.Frozen)iterator.next();
                        if (next.getExpireTime() > now) continue;
                        unfreezeBalance += next.getFrozenBalance();
                        iterator.remove();
                    }
                    accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().setBalance(oldBalance + unfreezeBalance).clearFrozen().addAllFrozen((Iterable)frozenList).build());
                    long newNetWeight = accountCapsule.getFrozenBalance() / 1000000L;
                    decrease = newNetWeight - oldNetWeight;
                    break;
                }
                case ENERGY: {
                    long oldEnergyWeight = accountCapsule.getEnergyFrozenBalance() / 1000000L;
                    unfreezeBalance = accountCapsule.getAccountResource().getFrozenBalanceForEnergy().getFrozenBalance();
                    Protocol.Account.AccountResource newAccountResource = accountCapsule.getAccountResource().toBuilder().clearFrozenBalanceForEnergy().build();
                    accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().setBalance(oldBalance + unfreezeBalance).setAccountResource(newAccountResource).build());
                    long newEnergyWeight = accountCapsule.getEnergyFrozenBalance() / 1000000L;
                    decrease = newEnergyWeight - oldEnergyWeight;
                    break;
                }
                case TRON_POWER: {
                    long oldTPWeight = accountCapsule.getTronPowerFrozenBalance() / 1000000L;
                    unfreezeBalance = accountCapsule.getTronPowerFrozenBalance();
                    accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().setBalance(oldBalance + unfreezeBalance).clearTronPower().build());
                    long newTPWeight = accountCapsule.getTronPowerFrozenBalance() / 1000000L;
                    decrease = newTPWeight - oldTPWeight;
                    break;
                }
            }
        }
        long weight = dynamicStore.allowNewReward() ? decrease : -unfreezeBalance / 1000000L;
        switch (unfreezeBalanceContract.getResource()) {
            case BANDWIDTH: {
                dynamicStore.addTotalNetWeight(weight);
                break;
            }
            case ENERGY: {
                dynamicStore.addTotalEnergyWeight(weight);
                break;
            }
            case TRON_POWER: {
                dynamicStore.addTotalTronPowerWeight(weight);
                break;
            }
        }
        boolean needToClearVote = true;
        if (dynamicStore.supportAllowNewResourceModel() && accountCapsule.oldTronPowerIsInvalid()) {
            switch (unfreezeBalanceContract.getResource()) {
                case BANDWIDTH: 
                case ENERGY: {
                    needToClearVote = false;
                    break;
                }
            }
        }
        if (needToClearVote) {
            VotesCapsule votesCapsule = !votesStore.has(ownerAddress) ? new VotesCapsule(unfreezeBalanceContract.getOwnerAddress(), accountCapsule.getVotesList()) : votesStore.get(ownerAddress);
            accountCapsule.clearVotes();
            votesCapsule.clearNewVotes();
            votesStore.put(ownerAddress, (ProtoCapsule)votesCapsule);
        }
        if (dynamicStore.supportAllowNewResourceModel() && !accountCapsule.oldTronPowerIsInvalid()) {
            accountCapsule.invalidateOldTronPower();
        }
        accountStore.put(ownerAddress, accountCapsule);
        ret.setUnfreezeAmount(unfreezeBalance);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    public boolean validate() throws ContractValidateException {
        block32: {
            long now;
            AccountCapsule accountCapsule;
            BalanceContract.UnfreezeBalanceContract unfreezeBalanceContract;
            DynamicPropertiesStore dynamicStore;
            block31: {
                if (this.any == null) {
                    throw new ContractValidateException("No contract!");
                }
                if (this.chainBaseManager == null) {
                    throw new ContractValidateException("No account store or dynamic store!");
                }
                AccountStore accountStore = this.chainBaseManager.getAccountStore();
                dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
                DelegatedResourceStore delegatedResourceStore = this.chainBaseManager.getDelegatedResourceStore();
                if (!this.any.is(BalanceContract.UnfreezeBalanceContract.class)) {
                    throw new ContractValidateException("contract type error, expected type [UnfreezeBalanceContract], real type[" + this.any.getClass() + "]");
                }
                try {
                    unfreezeBalanceContract = (BalanceContract.UnfreezeBalanceContract)this.any.unpack(BalanceContract.UnfreezeBalanceContract.class);
                }
                catch (InvalidProtocolBufferException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    throw new ContractValidateException(e.getMessage());
                }
                byte[] ownerAddress = unfreezeBalanceContract.getOwnerAddress().toByteArray();
                if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
                    throw new ContractValidateException("Invalid address");
                }
                accountCapsule = accountStore.get(ownerAddress);
                if (accountCapsule == null) {
                    String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
                    throw new ContractValidateException("Account[" + readableOwnerAddress + "] does not exist");
                }
                now = dynamicStore.getLatestBlockHeaderTimestamp();
                byte[] receiverAddress = unfreezeBalanceContract.getReceiverAddress().toByteArray();
                if (ArrayUtils.isEmpty((byte[])receiverAddress) || !dynamicStore.supportDR()) break block31;
                if (Arrays.equals(receiverAddress, ownerAddress)) {
                    throw new ContractValidateException("receiverAddress must not be the same as ownerAddress");
                }
                if (!DecodeUtil.addressValid((byte[])receiverAddress)) {
                    throw new ContractValidateException("Invalid receiverAddress");
                }
                AccountCapsule receiverCapsule = accountStore.get(receiverAddress);
                if (dynamicStore.getAllowTvmConstantinople() == 0L && receiverCapsule == null) {
                    String readableReceiverAddress = StringUtil.createReadableString((byte[])receiverAddress);
                    throw new ContractValidateException("Receiver Account[" + readableReceiverAddress + "] does not exist");
                }
                byte[] key = DelegatedResourceCapsule.createDbKey((byte[])unfreezeBalanceContract.getOwnerAddress().toByteArray(), (byte[])unfreezeBalanceContract.getReceiverAddress().toByteArray());
                DelegatedResourceCapsule delegatedResourceCapsule = delegatedResourceStore.get(key);
                if (delegatedResourceCapsule == null) {
                    throw new ContractValidateException("delegated Resource does not exist");
                }
                switch (unfreezeBalanceContract.getResource()) {
                    case BANDWIDTH: {
                        if (delegatedResourceCapsule.getFrozenBalanceForBandwidth() <= 0L) {
                            throw new ContractValidateException("no delegatedFrozenBalance(BANDWIDTH)");
                        }
                        if (dynamicStore.getAllowTvmConstantinople() == 0L ? receiverCapsule.getAcquiredDelegatedFrozenBalanceForBandwidth() < delegatedResourceCapsule.getFrozenBalanceForBandwidth() : dynamicStore.getAllowTvmSolidity059() != 1L && receiverCapsule != null && receiverCapsule.getType() != Protocol.AccountType.Contract && receiverCapsule.getAcquiredDelegatedFrozenBalanceForBandwidth() < delegatedResourceCapsule.getFrozenBalanceForBandwidth()) {
                            throw new ContractValidateException("AcquiredDelegatedFrozenBalanceForBandwidth[" + receiverCapsule.getAcquiredDelegatedFrozenBalanceForBandwidth() + "] < delegatedBandwidth[" + delegatedResourceCapsule.getFrozenBalanceForBandwidth() + "]");
                        }
                        if (delegatedResourceCapsule.getExpireTimeForBandwidth() > now) {
                            throw new ContractValidateException("It's not time to unfreeze.");
                        }
                        break block32;
                    }
                    case ENERGY: {
                        if (delegatedResourceCapsule.getFrozenBalanceForEnergy() <= 0L) {
                            throw new ContractValidateException("no delegateFrozenBalance(Energy)");
                        }
                        if (dynamicStore.getAllowTvmConstantinople() == 0L ? receiverCapsule.getAcquiredDelegatedFrozenBalanceForEnergy() < delegatedResourceCapsule.getFrozenBalanceForEnergy() : dynamicStore.getAllowTvmSolidity059() != 1L && receiverCapsule != null && receiverCapsule.getType() != Protocol.AccountType.Contract && receiverCapsule.getAcquiredDelegatedFrozenBalanceForEnergy() < delegatedResourceCapsule.getFrozenBalanceForEnergy()) {
                            throw new ContractValidateException("AcquiredDelegatedFrozenBalanceForEnergy[" + receiverCapsule.getAcquiredDelegatedFrozenBalanceForEnergy() + "] < delegatedEnergy[" + delegatedResourceCapsule.getFrozenBalanceForEnergy() + "]");
                        }
                        if (delegatedResourceCapsule.getExpireTimeForEnergy(dynamicStore) > now) {
                            throw new ContractValidateException("It's not time to unfreeze.");
                        }
                        break block32;
                    }
                    default: {
                        throw new ContractValidateException(INVALID_RESOURCE_CODE);
                    }
                }
            }
            switch (unfreezeBalanceContract.getResource()) {
                case BANDWIDTH: {
                    if (accountCapsule.getFrozenCount() <= 0) {
                        throw new ContractValidateException("no frozenBalance(BANDWIDTH)");
                    }
                    long allowedUnfreezeCount = accountCapsule.getFrozenList().stream().filter(frozen -> frozen.getExpireTime() <= now).count();
                    if (allowedUnfreezeCount > 0L) break;
                    throw new ContractValidateException("It's not time to unfreeze(BANDWIDTH).");
                }
                case ENERGY: {
                    Protocol.Account.Frozen frozenBalanceForEnergy = accountCapsule.getAccountResource().getFrozenBalanceForEnergy();
                    if (frozenBalanceForEnergy.getFrozenBalance() <= 0L) {
                        throw new ContractValidateException("no frozenBalance(Energy)");
                    }
                    if (frozenBalanceForEnergy.getExpireTime() <= now) break;
                    throw new ContractValidateException("It's not time to unfreeze(Energy).");
                }
                case TRON_POWER: {
                    if (dynamicStore.supportAllowNewResourceModel()) {
                        Protocol.Account.Frozen frozenBalanceForTronPower = accountCapsule.getInstance().getTronPower();
                        if (frozenBalanceForTronPower.getFrozenBalance() <= 0L) {
                            throw new ContractValidateException("no frozenBalance(TronPower)");
                        }
                        if (frozenBalanceForTronPower.getExpireTime() <= now) break;
                        throw new ContractValidateException("It's not time to unfreeze(TronPower).");
                    }
                    throw new ContractValidateException(INVALID_RESOURCE_CODE);
                }
                default: {
                    if (dynamicStore.supportAllowNewResourceModel()) {
                        throw new ContractValidateException("ResourceCode error.valid ResourceCode[BANDWIDTH\u3001Energy\u3001TRON_POWER]");
                    }
                    throw new ContractValidateException(INVALID_RESOURCE_CODE);
                }
            }
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((BalanceContract.UnfreezeBalanceContract)this.any.unpack(BalanceContract.UnfreezeBalanceContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

