/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AssetIssueContractOuterClass;

public class UnfreezeAssetActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public UnfreezeAssetActuator() {
        super(Protocol.Transaction.Contract.ContractType.UnfreezeAssetContract, AssetIssueContractOuterClass.UnfreezeAssetContract.class);
    }

    public boolean execute(Object object) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)object;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        AssetIssueStore assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        try {
            AssetIssueContractOuterClass.UnfreezeAssetContract unfreezeAssetContract = (AssetIssueContractOuterClass.UnfreezeAssetContract)this.any.unpack(AssetIssueContractOuterClass.UnfreezeAssetContract.class);
            byte[] ownerAddress = unfreezeAssetContract.getOwnerAddress().toByteArray();
            AccountCapsule accountCapsule = accountStore.get(ownerAddress);
            long unfreezeAsset = 0L;
            ArrayList frozenList = Lists.newArrayList();
            frozenList.addAll(accountCapsule.getFrozenSupplyList());
            Iterator iterator = frozenList.iterator();
            long now = dynamicStore.getLatestBlockHeaderTimestamp();
            while (iterator.hasNext()) {
                Protocol.Account.Frozen next = (Protocol.Account.Frozen)iterator.next();
                if (next.getExpireTime() > now) continue;
                unfreezeAsset += next.getFrozenBalance();
                iterator.remove();
            }
            if (dynamicStore.getAllowSameTokenName() == 0L) {
                accountCapsule.addAssetAmountV2(accountCapsule.getAssetIssuedName().toByteArray(), unfreezeAsset, dynamicStore, assetIssueStore);
            } else {
                accountCapsule.addAssetAmountV2(accountCapsule.getAssetIssuedID().toByteArray(), unfreezeAsset, dynamicStore, assetIssueStore);
            }
            accountCapsule.setInstance(accountCapsule.getInstance().toBuilder().clearFrozenSupply().addAllFrozenSupply((Iterable)frozenList).build());
            accountStore.put(ownerAddress, accountCapsule);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException | ArithmeticException e) {
            logger.debug(e.getMessage(), e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        AssetIssueContractOuterClass.UnfreezeAssetContract unfreezeAssetContract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        if (!this.any.is(AssetIssueContractOuterClass.UnfreezeAssetContract.class)) {
            throw new ContractValidateException("contract type error, expected type [UnfreezeAssetContract], real type[" + this.any.getClass() + "]");
        }
        try {
            unfreezeAssetContract = (AssetIssueContractOuterClass.UnfreezeAssetContract)this.any.unpack(AssetIssueContractOuterClass.UnfreezeAssetContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = unfreezeAssetContract.getOwnerAddress().toByteArray();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        if (accountCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] does not exist");
        }
        if (accountCapsule.getFrozenSupplyCount() <= 0) {
            throw new ContractValidateException("no frozen supply balance");
        }
        if (dynamicStore.getAllowSameTokenName() == 0L ? accountCapsule.getAssetIssuedName().isEmpty() : accountCapsule.getAssetIssuedID().isEmpty()) {
            throw new ContractValidateException("this account has not issued any asset");
        }
        long now = dynamicStore.getLatestBlockHeaderTimestamp();
        long allowedUnfreezeCount = accountCapsule.getFrozenSupplyList().stream().filter(frozen -> frozen.getExpireTime() <= now).count();
        if (allowedUnfreezeCount <= 0L) {
            throw new ContractValidateException("It's not time to unfreeze asset supply");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((AssetIssueContractOuterClass.UnfreezeAssetContract)this.any.unpack(AssetIssueContractOuterClass.UnfreezeAssetContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

