/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Commons;
import org.tron.common.utils.DecodeUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.AssetIssueV2Store;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AssetIssueContractOuterClass;

public class TransferAssetActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public TransferAssetActuator() {
        super(Protocol.Transaction.Contract.ContractType.TransferAssetContract, AssetIssueContractOuterClass.TransferAssetContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        AssetIssueStore assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        try {
            AssetIssueContractOuterClass.TransferAssetContract transferAssetContract = (AssetIssueContractOuterClass.TransferAssetContract)this.any.unpack(AssetIssueContractOuterClass.TransferAssetContract.class);
            byte[] ownerAddress = transferAssetContract.getOwnerAddress().toByteArray();
            byte[] toAddress = transferAssetContract.getToAddress().toByteArray();
            AccountCapsule toAccountCapsule = accountStore.get(toAddress);
            if (toAccountCapsule == null) {
                boolean withDefaultPermission = dynamicStore.getAllowMultiSign() == 1L;
                toAccountCapsule = new AccountCapsule(ByteString.copyFrom((byte[])toAddress), Protocol.AccountType.Normal, dynamicStore.getLatestBlockHeaderTimestamp(), withDefaultPermission, dynamicStore);
                accountStore.put(toAddress, toAccountCapsule);
                fee += dynamicStore.getCreateNewAccountFeeInSystemContract();
            }
            ByteString assetName = transferAssetContract.getAssetName();
            long amount = transferAssetContract.getAmount();
            AccountCapsule ownerAccountCapsule = accountStore.get(ownerAddress);
            if (!ownerAccountCapsule.reduceAssetAmountV2(assetName.toByteArray(), amount, dynamicStore, assetIssueStore)) {
                throw new ContractExeException("reduceAssetAmount failed !");
            }
            accountStore.put(ownerAddress, ownerAccountCapsule);
            toAccountCapsule.addAssetAmountV2(assetName.toByteArray(), amount, dynamicStore, assetIssueStore);
            accountStore.put(toAddress, toAccountCapsule);
            Commons.adjustBalance((AccountStore)accountStore, (AccountCapsule)ownerAccountCapsule, (long)(-fee));
            if (dynamicStore.supportBlackHoleOptimization()) {
                dynamicStore.burnTrx(fee);
            } else {
                Commons.adjustBalance((AccountStore)accountStore, (AccountCapsule)accountStore.getBlackhole(), (long)fee);
            }
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (BalanceInsufficientException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        catch (InvalidProtocolBufferException | ArithmeticException e) {
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        AssetIssueContractOuterClass.TransferAssetContract transferAssetContract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        AssetIssueStore assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        AssetIssueV2Store assetIssueV2Store = this.chainBaseManager.getAssetIssueV2Store();
        if (!this.any.is(AssetIssueContractOuterClass.TransferAssetContract.class)) {
            throw new ContractValidateException("contract type error, expected type [TransferAssetContract], real type[" + this.any.getClass() + "]");
        }
        try {
            transferAssetContract = (AssetIssueContractOuterClass.TransferAssetContract)this.any.unpack(AssetIssueContractOuterClass.TransferAssetContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        long fee = this.calcFee();
        byte[] ownerAddress = transferAssetContract.getOwnerAddress().toByteArray();
        byte[] toAddress = transferAssetContract.getToAddress().toByteArray();
        byte[] assetName = transferAssetContract.getAssetName().toByteArray();
        long amount = transferAssetContract.getAmount();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        if (!DecodeUtil.addressValid((byte[])toAddress)) {
            throw new ContractValidateException("Invalid toAddress");
        }
        if (amount <= 0L) {
            throw new ContractValidateException("Amount must be greater than 0.");
        }
        if (Arrays.equals(ownerAddress, toAddress)) {
            throw new ContractValidateException("Cannot transfer asset to yourself.");
        }
        AccountCapsule ownerAccount = accountStore.get(ownerAddress);
        if (ownerAccount == null) {
            throw new ContractValidateException("No owner account!");
        }
        if (!Commons.getAssetIssueStoreFinal((DynamicPropertiesStore)dynamicStore, (AssetIssueStore)assetIssueStore, (AssetIssueV2Store)assetIssueV2Store).has(assetName)) {
            throw new ContractValidateException("No asset!");
        }
        Long assetBalance = ownerAccount.getAsset(dynamicStore, ByteArray.toStr((byte[])assetName));
        if (null == assetBalance || assetBalance <= 0L) {
            throw new ContractValidateException("assetBalance must be greater than 0.");
        }
        if (amount > assetBalance) {
            throw new ContractValidateException("assetBalance is not sufficient.");
        }
        AccountCapsule toAccount = accountStore.get(toAddress);
        if (toAccount != null) {
            if (dynamicStore.getForbidTransferToContract() == 1L && toAccount.getType() == Protocol.AccountType.Contract) {
                throw new ContractValidateException("Cannot transfer asset to smartContract.");
            }
            assetBalance = toAccount.getAsset(dynamicStore, ByteArray.toStr((byte[])assetName));
            if (assetBalance != null) {
                try {
                    assetBalance = Math.addExact(assetBalance, amount);
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                    throw new ContractValidateException(e.getMessage());
                }
            }
        } else if (ownerAccount.getBalance() < (fee += dynamicStore.getCreateNewAccountFeeInSystemContract())) {
            throw new ContractValidateException("Validate TransferAssetActuator error, insufficient fee.");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((AssetIssueContractOuterClass.TransferAssetContract)this.any.unpack(AssetIssueContractOuterClass.TransferAssetContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

