/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.ProposalCapsule;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.ProposalStore;
import org.tron.core.store.WitnessStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.ProposalContract;

public class ProposalApproveActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public ProposalApproveActuator() {
        super(Protocol.Transaction.Contract.ContractType.ProposalApproveContract, ProposalContract.ProposalApproveContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        ProposalStore proposalStore = this.chainBaseManager.getProposalStore();
        try {
            ProposalContract.ProposalApproveContract proposalApproveContract = (ProposalContract.ProposalApproveContract)this.any.unpack(ProposalContract.ProposalApproveContract.class);
            ProposalCapsule proposalCapsule = proposalStore.get(ByteArray.fromLong((long)proposalApproveContract.getProposalId()));
            ByteString committeeAddress = proposalApproveContract.getOwnerAddress();
            if (proposalApproveContract.getIsAddApproval()) {
                proposalCapsule.addApproval(committeeAddress);
            } else {
                proposalCapsule.removeApproval(committeeAddress);
            }
            proposalStore.put(proposalCapsule.createDbKey(), (ProtoCapsule)proposalCapsule);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException | ItemNotFoundException e) {
            logger.debug(e.getMessage(), e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        ProposalCapsule proposalCapsule;
        ProposalContract.ProposalApproveContract contract;
        if (Objects.isNull(this.any)) {
            throw new ContractValidateException("No contract!");
        }
        if (Objects.isNull(this.chainBaseManager)) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        WitnessStore witnessStore = this.chainBaseManager.getWitnessStore();
        ProposalStore proposalStore = this.chainBaseManager.getProposalStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        if (!this.any.is(ProposalContract.ProposalApproveContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ProposalApproveContract],real type[" + this.any.getClass() + "]");
        }
        try {
            contract = (ProposalContract.ProposalApproveContract)this.any.unpack(ProposalContract.ProposalApproveContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!accountStore.has(ownerAddress)) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        if (!witnessStore.has(ownerAddress)) {
            throw new ContractValidateException("Witness[" + readableOwnerAddress + "] not exists");
        }
        long latestProposalNum = dynamicStore.getLatestProposalNum();
        if (contract.getProposalId() > latestProposalNum) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] not exists");
        }
        long now = dynamicStore.getLatestBlockHeaderTimestamp();
        try {
            proposalCapsule = proposalStore.get(ByteArray.fromLong((long)contract.getProposalId()));
        }
        catch (ItemNotFoundException ex) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] not exists");
        }
        if (now >= proposalCapsule.getExpirationTime()) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] expired");
        }
        if (proposalCapsule.getState() == Protocol.Proposal.State.CANCELED) {
            throw new ContractValidateException("Proposal[" + contract.getProposalId() + "] canceled");
        }
        if (!contract.getIsAddApproval()) {
            if (!proposalCapsule.getApprovals().contains(contract.getOwnerAddress())) {
                throw new ContractValidateException("Witness[" + readableOwnerAddress + "]has not approved proposal[" + contract.getProposalId() + "] before");
            }
        } else if (proposalCapsule.getApprovals().contains(contract.getOwnerAddress())) {
            throw new ContractValidateException("Witness[" + readableOwnerAddress + "]has approved proposal[" + contract.getProposalId() + "] before");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((ProposalContract.ProposalApproveContract)this.any.unpack(ProposalContract.ProposalApproveContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

