/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Commons;
import org.tron.common.utils.DecodeUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.AssetIssueCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.AssetIssueV2Store;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AssetIssueContractOuterClass;

public class ParticipateAssetIssueActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public ParticipateAssetIssueActuator() {
        super(Protocol.Transaction.Contract.ContractType.ParticipateAssetIssueContract, AssetIssueContractOuterClass.ParticipateAssetIssueContract.class);
    }

    public boolean execute(Object object) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)object;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        AssetIssueStore assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        AssetIssueV2Store assetIssueV2Store = this.chainBaseManager.getAssetIssueV2Store();
        try {
            AssetIssueContractOuterClass.ParticipateAssetIssueContract participateAssetIssueContract = (AssetIssueContractOuterClass.ParticipateAssetIssueContract)this.any.unpack(AssetIssueContractOuterClass.ParticipateAssetIssueContract.class);
            long cost = participateAssetIssueContract.getAmount();
            byte[] ownerAddress = participateAssetIssueContract.getOwnerAddress().toByteArray();
            AccountCapsule ownerAccount = accountStore.get(ownerAddress);
            long balance = Math.subtractExact(ownerAccount.getBalance(), cost);
            balance = Math.subtractExact(balance, fee);
            ownerAccount.setBalance(balance);
            byte[] key = participateAssetIssueContract.getAssetName().toByteArray();
            AssetIssueCapsule assetIssueCapsule = Commons.getAssetIssueStoreFinal((DynamicPropertiesStore)dynamicStore, (AssetIssueStore)assetIssueStore, (AssetIssueV2Store)assetIssueV2Store).get(key);
            long exchangeAmount = Math.multiplyExact(cost, (long)assetIssueCapsule.getNum());
            exchangeAmount = Math.floorDiv(exchangeAmount, (long)assetIssueCapsule.getTrxNum());
            ownerAccount.addAssetAmountV2(key, exchangeAmount, dynamicStore, assetIssueStore);
            byte[] toAddress = participateAssetIssueContract.getToAddress().toByteArray();
            AccountCapsule toAccount = accountStore.get(toAddress);
            toAccount.setBalance(Math.addExact(toAccount.getBalance(), cost));
            if (!toAccount.reduceAssetAmountV2(key, exchangeAmount, dynamicStore, assetIssueStore)) {
                throw new ContractExeException("reduceAssetAmount failed !");
            }
            accountStore.put(ownerAddress, ownerAccount);
            accountStore.put(toAddress, toAccount);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException | ArithmeticException e) {
            logger.debug(e.getMessage(), e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        AssetIssueContractOuterClass.ParticipateAssetIssueContract participateAssetIssueContract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        AssetIssueStore assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        AssetIssueV2Store assetIssueV2Store = this.chainBaseManager.getAssetIssueV2Store();
        if (!this.any.is(AssetIssueContractOuterClass.ParticipateAssetIssueContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ParticipateAssetIssueContract],real type[" + this.any.getClass() + "]");
        }
        try {
            participateAssetIssueContract = (AssetIssueContractOuterClass.ParticipateAssetIssueContract)this.any.unpack(AssetIssueContractOuterClass.ParticipateAssetIssueContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = participateAssetIssueContract.getOwnerAddress().toByteArray();
        byte[] toAddress = participateAssetIssueContract.getToAddress().toByteArray();
        byte[] assetName = participateAssetIssueContract.getAssetName().toByteArray();
        long amount = participateAssetIssueContract.getAmount();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        if (!DecodeUtil.addressValid((byte[])toAddress)) {
            throw new ContractValidateException("Invalid toAddress");
        }
        if (amount <= 0L) {
            throw new ContractValidateException("Amount must greater than 0!");
        }
        if (Arrays.equals(ownerAddress, toAddress)) {
            throw new ContractValidateException("Cannot participate asset Issue yourself !");
        }
        AccountCapsule ownerAccount = accountStore.get(ownerAddress);
        if (ownerAccount == null) {
            throw new ContractValidateException("Account does not exist!");
        }
        try {
            long fee = this.calcFee();
            if (ownerAccount.getBalance() < Math.addExact(amount, fee)) {
                throw new ContractValidateException("No enough balance !");
            }
            AssetIssueCapsule assetIssueCapsule = Commons.getAssetIssueStoreFinal((DynamicPropertiesStore)dynamicStore, (AssetIssueStore)assetIssueStore, (AssetIssueV2Store)assetIssueV2Store).get(assetName);
            if (assetIssueCapsule == null) {
                throw new ContractValidateException("No asset named " + ByteArray.toStr((byte[])assetName));
            }
            if (!Arrays.equals(toAddress, assetIssueCapsule.getOwnerAddress().toByteArray())) {
                throw new ContractValidateException("The asset is not issued by " + ByteArray.toHexString((byte[])toAddress));
            }
            long now = dynamicStore.getLatestBlockHeaderTimestamp();
            if (now >= assetIssueCapsule.getEndTime() || now < assetIssueCapsule.getStartTime()) {
                throw new ContractValidateException("No longer valid period!");
            }
            int trxNum = assetIssueCapsule.getTrxNum();
            int num = assetIssueCapsule.getNum();
            long exchangeAmount = Math.multiplyExact(amount, (long)num);
            if ((exchangeAmount = Math.floorDiv(exchangeAmount, (long)trxNum)) <= 0L) {
                throw new ContractValidateException("Can not process the exchange!");
            }
            AccountCapsule toAccount = accountStore.get(toAddress);
            if (toAccount == null) {
                throw new ContractValidateException("To account does not exist!");
            }
            if (!toAccount.assetBalanceEnoughV2(assetName, exchangeAmount, dynamicStore)) {
                throw new ContractValidateException("Asset balance is not enough !");
            }
        }
        catch (ArithmeticException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((AssetIssueContractOuterClass.ParticipateAssetIssueContract)this.any.unpack(AssetIssueContractOuterClass.ParticipateAssetIssueContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

