/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Commons;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.ExchangeCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.capsule.utils.TransactionUtil;
import org.tron.core.config.Parameter;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.AssetIssueStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.core.store.ExchangeStore;
import org.tron.core.store.ExchangeV2Store;
import org.tron.protos.Protocol;
import org.tron.protos.contract.ExchangeContract;

public class ExchangeWithdrawActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public ExchangeWithdrawActuator() {
        super(Protocol.Transaction.Contract.ContractType.ExchangeWithdrawContract, ExchangeContract.ExchangeWithdrawContract.class);
    }

    public boolean execute(Object object) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)object;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        ExchangeStore exchangeStore = this.chainBaseManager.getExchangeStore();
        ExchangeV2Store exchangeV2Store = this.chainBaseManager.getExchangeV2Store();
        AssetIssueStore assetIssueStore = this.chainBaseManager.getAssetIssueStore();
        try {
            long anotherTokenQuant;
            byte[] anotherTokenID;
            ExchangeContract.ExchangeWithdrawContract exchangeWithdrawContract = (ExchangeContract.ExchangeWithdrawContract)this.any.unpack(ExchangeContract.ExchangeWithdrawContract.class);
            AccountCapsule accountCapsule = accountStore.get(exchangeWithdrawContract.getOwnerAddress().toByteArray());
            ExchangeCapsule exchangeCapsule = Commons.getExchangeStoreFinal((DynamicPropertiesStore)dynamicStore, (ExchangeStore)exchangeStore, (ExchangeV2Store)exchangeV2Store).get(ByteArray.fromLong((long)exchangeWithdrawContract.getExchangeId()));
            byte[] firstTokenID = exchangeCapsule.getFirstTokenId();
            byte[] secondTokenID = exchangeCapsule.getSecondTokenId();
            long firstTokenBalance = exchangeCapsule.getFirstTokenBalance();
            long secondTokenBalance = exchangeCapsule.getSecondTokenBalance();
            byte[] tokenID = exchangeWithdrawContract.getTokenId().toByteArray();
            long tokenQuant = exchangeWithdrawContract.getQuant();
            BigInteger bigFirstTokenBalance = new BigInteger(String.valueOf(firstTokenBalance));
            BigInteger bigSecondTokenBalance = new BigInteger(String.valueOf(secondTokenBalance));
            BigInteger bigTokenQuant = new BigInteger(String.valueOf(tokenQuant));
            if (Arrays.equals(tokenID, firstTokenID)) {
                anotherTokenID = secondTokenID;
                anotherTokenQuant = bigSecondTokenBalance.multiply(bigTokenQuant).divide(bigFirstTokenBalance).longValueExact();
                exchangeCapsule.setBalance(firstTokenBalance - tokenQuant, secondTokenBalance - anotherTokenQuant);
            } else {
                anotherTokenID = firstTokenID;
                anotherTokenQuant = bigFirstTokenBalance.multiply(bigTokenQuant).divide(bigSecondTokenBalance).longValueExact();
                exchangeCapsule.setBalance(firstTokenBalance - anotherTokenQuant, secondTokenBalance - tokenQuant);
            }
            long newBalance = accountCapsule.getBalance() - this.calcFee();
            if (Arrays.equals(tokenID, Parameter.ChainSymbol.TRX_SYMBOL_BYTES)) {
                accountCapsule.setBalance(newBalance + tokenQuant);
            } else {
                accountCapsule.addAssetAmountV2(tokenID, tokenQuant, dynamicStore, assetIssueStore);
            }
            if (Arrays.equals(anotherTokenID, Parameter.ChainSymbol.TRX_SYMBOL_BYTES)) {
                accountCapsule.setBalance(newBalance + anotherTokenQuant);
            } else {
                accountCapsule.addAssetAmountV2(anotherTokenID, anotherTokenQuant, dynamicStore, assetIssueStore);
            }
            accountStore.put(accountCapsule.createDbKey(), accountCapsule);
            Commons.putExchangeCapsule((ExchangeCapsule)exchangeCapsule, (DynamicPropertiesStore)dynamicStore, (ExchangeStore)exchangeStore, (ExchangeV2Store)exchangeV2Store, (AssetIssueStore)assetIssueStore);
            ret.setExchangeWithdrawAnotherAmount(anotherTokenQuant);
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException | ItemNotFoundException e) {
            logger.debug(e.getMessage(), e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        ExchangeCapsule exchangeCapsule;
        ExchangeContract.ExchangeWithdrawContract contract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        ExchangeStore exchangeStore = this.chainBaseManager.getExchangeStore();
        ExchangeV2Store exchangeV2Store = this.chainBaseManager.getExchangeV2Store();
        if (!this.any.is(ExchangeContract.ExchangeWithdrawContract.class)) {
            throw new ContractValidateException("contract type error,expected type [ExchangeWithdrawContract],real type[" + this.any.getClass() + "]");
        }
        try {
            contract = (ExchangeContract.ExchangeWithdrawContract)this.any.unpack(ExchangeContract.ExchangeWithdrawContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        if (!accountStore.has(ownerAddress)) {
            throw new ContractValidateException("account[" + readableOwnerAddress + "] not exists");
        }
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        if (accountCapsule.getBalance() < this.calcFee()) {
            throw new ContractValidateException("No enough balance for exchange withdraw fee!");
        }
        try {
            exchangeCapsule = Commons.getExchangeStoreFinal((DynamicPropertiesStore)dynamicStore, (ExchangeStore)exchangeStore, (ExchangeV2Store)exchangeV2Store).get(ByteArray.fromLong((long)contract.getExchangeId()));
        }
        catch (ItemNotFoundException ex) {
            throw new ContractValidateException("Exchange[" + contract.getExchangeId() + "] not exists");
        }
        if (!accountCapsule.getAddress().equals((Object)exchangeCapsule.getCreatorAddress())) {
            throw new ContractValidateException("account[" + readableOwnerAddress + "] is not creator");
        }
        byte[] firstTokenID = exchangeCapsule.getFirstTokenId();
        byte[] secondTokenID = exchangeCapsule.getSecondTokenId();
        long firstTokenBalance = exchangeCapsule.getFirstTokenBalance();
        long secondTokenBalance = exchangeCapsule.getSecondTokenBalance();
        byte[] tokenID = contract.getTokenId().toByteArray();
        long tokenQuant = contract.getQuant();
        if (dynamicStore.getAllowSameTokenName() == 1L && !Arrays.equals(tokenID, Parameter.ChainSymbol.TRX_SYMBOL_BYTES) && !TransactionUtil.isNumber((byte[])tokenID)) {
            throw new ContractValidateException("token id is not a valid number");
        }
        if (!Arrays.equals(tokenID, firstTokenID) && !Arrays.equals(tokenID, secondTokenID)) {
            throw new ContractValidateException("token is not in exchange");
        }
        if (tokenQuant <= 0L) {
            throw new ContractValidateException("withdraw token quant must greater than zero");
        }
        if (firstTokenBalance == 0L || secondTokenBalance == 0L) {
            throw new ContractValidateException("Token balance in exchange is equal with 0,the exchange has been closed");
        }
        BigDecimal bigFirstTokenBalance = new BigDecimal(String.valueOf(firstTokenBalance));
        BigDecimal bigSecondTokenBalance = new BigDecimal(String.valueOf(secondTokenBalance));
        BigDecimal bigTokenQuant = new BigDecimal(String.valueOf(tokenQuant));
        if (Arrays.equals(tokenID, firstTokenID)) {
            long anotherTokenQuant = bigSecondTokenBalance.multiply(bigTokenQuant).divideToIntegralValue(bigFirstTokenBalance).longValueExact();
            if (firstTokenBalance < tokenQuant || secondTokenBalance < anotherTokenQuant) {
                throw new ContractValidateException("exchange balance is not enough");
            }
            if (anotherTokenQuant <= 0L) {
                throw new ContractValidateException("withdraw another token quant must greater than zero");
            }
            double remainder = bigSecondTokenBalance.multiply(bigTokenQuant).divide(bigFirstTokenBalance, 4, 4).doubleValue() - (double)anotherTokenQuant;
            if (remainder / (double)anotherTokenQuant > 1.0E-4) {
                throw new ContractValidateException("Not precise enough");
            }
        } else {
            long anotherTokenQuant = bigFirstTokenBalance.multiply(bigTokenQuant).divideToIntegralValue(bigSecondTokenBalance).longValueExact();
            if (secondTokenBalance < tokenQuant || firstTokenBalance < anotherTokenQuant) {
                throw new ContractValidateException("exchange balance is not enough");
            }
            if (anotherTokenQuant <= 0L) {
                throw new ContractValidateException("withdraw another token quant must greater than zero");
            }
            double remainder = bigFirstTokenBalance.multiply(bigTokenQuant).divide(bigSecondTokenBalance, 4, 4).doubleValue() - (double)anotherTokenQuant;
            if (remainder / (double)anotherTokenQuant > 1.0E-4) {
                throw new ContractValidateException("Not precise enough");
            }
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((ExchangeContract.ExchangeWithdrawContract)this.any.unpack(ExchangeContract.ExchangeWithdrawContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return 0L;
    }
}

