/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.Commons;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AccountContract;

public class CreateAccountActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public CreateAccountActuator() {
        super(Protocol.Transaction.Contract.ContractType.AccountCreateContract, AccountContract.AccountCreateContract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        try {
            AccountContract.AccountCreateContract accountCreateContract = (AccountContract.AccountCreateContract)this.any.unpack(AccountContract.AccountCreateContract.class);
            boolean withDefaultPermission = dynamicStore.getAllowMultiSign() == 1L;
            AccountCapsule accountCapsule = new AccountCapsule(accountCreateContract, dynamicStore.getLatestBlockHeaderTimestamp(), withDefaultPermission, dynamicStore);
            accountStore.put(accountCreateContract.getAccountAddress().toByteArray(), accountCapsule);
            Commons.adjustBalance((AccountStore)accountStore, (byte[])accountCreateContract.getOwnerAddress().toByteArray(), (long)(-fee));
            if (dynamicStore.supportBlackHoleOptimization()) {
                dynamicStore.burnTrx(fee);
            } else {
                Commons.adjustBalance((AccountStore)accountStore, (AccountCapsule)accountStore.getBlackhole(), (long)fee);
            }
            ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException | BalanceInsufficientException e) {
            logger.debug(e.getMessage(), e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        AccountContract.AccountCreateContract contract;
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or contract store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        if (!this.any.is(AccountContract.AccountCreateContract.class)) {
            throw new ContractValidateException("contract type error,expected type [AccountCreateContract],real type[" + this.any.getClass() + "]");
        }
        try {
            contract = (AccountContract.AccountCreateContract)this.any.unpack(AccountContract.AccountCreateContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = contract.getOwnerAddress().toByteArray();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid ownerAddress");
        }
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        if (accountCapsule == null) {
            String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        long fee = this.calcFee();
        if (accountCapsule.getBalance() < fee) {
            throw new ContractValidateException("Validate CreateAccountActuator error, insufficient fee.");
        }
        byte[] accountAddress = contract.getAccountAddress().toByteArray();
        if (!DecodeUtil.addressValid((byte[])accountAddress)) {
            throw new ContractValidateException("Invalid account address");
        }
        if (accountStore.has(accountAddress)) {
            throw new ContractValidateException("Account has existed");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((AccountContract.AccountCreateContract)this.any.unpack(AccountContract.AccountCreateContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return this.chainBaseManager.getDynamicPropertiesStore().getCreateNewAccountFeeInSystemContract();
    }
}

