/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.DecodeUtil;
import org.tron.common.utils.StringUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.BalanceContract;
import org.tron.protos.contract.Common;

public class CancelAllUnfreezeV2Actuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public CancelAllUnfreezeV2Actuator() {
        super(Protocol.Transaction.Contract.ContractType.CancelAllUnfreezeV2Contract, BalanceContract.CancelAllUnfreezeV2Contract.class);
    }

    public boolean execute(Object result) throws ContractExeException {
        byte[] ownerAddress;
        TransactionResultCapsule ret = (TransactionResultCapsule)result;
        if (Objects.isNull(ret)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        long fee = this.calcFee();
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        try {
            ownerAddress = this.getOwnerAddress().toByteArray();
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            ret.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        AccountCapsule ownerCapsule = accountStore.get(ownerAddress);
        List unfrozenV2List = ownerCapsule.getUnfrozenV2List();
        long now = dynamicStore.getLatestBlockHeaderTimestamp();
        AtomicLong atomicWithdrawExpireBalance = new AtomicLong(0L);
        Triple triple = Triple.of((Object)Pair.of((Object)new AtomicLong(0L), (Object)new AtomicLong(0L)), (Object)Pair.of((Object)new AtomicLong(0L), (Object)new AtomicLong(0L)), (Object)Pair.of((Object)new AtomicLong(0L), (Object)new AtomicLong(0L)));
        for (Protocol.Account.UnFreezeV2 unFreezeV2 : unfrozenV2List) {
            this.updateAndCalculate((Triple<Pair<AtomicLong, AtomicLong>, Pair<AtomicLong, AtomicLong>, Pair<AtomicLong, AtomicLong>>)triple, ownerCapsule, now, atomicWithdrawExpireBalance, unFreezeV2);
        }
        ownerCapsule.clearUnfrozenV2();
        this.addTotalResourceWeight(dynamicStore, (Triple<Pair<AtomicLong, AtomicLong>, Pair<AtomicLong, AtomicLong>, Pair<AtomicLong, AtomicLong>>)triple);
        long withdrawExpireBalance = atomicWithdrawExpireBalance.get();
        if (withdrawExpireBalance > 0L) {
            ownerCapsule.setBalance(ownerCapsule.getBalance() + withdrawExpireBalance);
        }
        accountStore.put(ownerCapsule.createDbKey(), ownerCapsule);
        ret.setWithdrawExpireAmount(withdrawExpireBalance);
        HashMap<String, Long> cancelUnfreezeV2AmountMap = new HashMap<String, Long>();
        cancelUnfreezeV2AmountMap.put(Common.ResourceCode.BANDWIDTH.name(), ((AtomicLong)((Pair)triple.getLeft()).getRight()).get());
        cancelUnfreezeV2AmountMap.put(Common.ResourceCode.ENERGY.name(), ((AtomicLong)((Pair)triple.getMiddle()).getRight()).get());
        cancelUnfreezeV2AmountMap.put(Common.ResourceCode.TRON_POWER.name(), ((AtomicLong)((Pair)triple.getRight()).getRight()).get());
        ret.putAllCancelUnfreezeV2AmountMap(cancelUnfreezeV2AmountMap);
        ret.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        return true;
    }

    private void addTotalResourceWeight(DynamicPropertiesStore dynamicStore, Triple<Pair<AtomicLong, AtomicLong>, Pair<AtomicLong, AtomicLong>, Pair<AtomicLong, AtomicLong>> triple) {
        dynamicStore.addTotalNetWeight(((AtomicLong)((Pair)triple.getLeft()).getLeft()).get());
        dynamicStore.addTotalEnergyWeight(((AtomicLong)((Pair)triple.getMiddle()).getLeft()).get());
        dynamicStore.addTotalTronPowerWeight(((AtomicLong)((Pair)triple.getRight()).getLeft()).get());
    }

    private void updateAndCalculate(Triple<Pair<AtomicLong, AtomicLong>, Pair<AtomicLong, AtomicLong>, Pair<AtomicLong, AtomicLong>> triple, AccountCapsule ownerCapsule, long now, AtomicLong atomicLong, Protocol.Account.UnFreezeV2 unFreezeV2) {
        if (unFreezeV2.getUnfreezeExpireTime() > now) {
            this.updateFrozenInfoAndTotalResourceWeight(ownerCapsule, unFreezeV2, triple);
        } else {
            atomicLong.addAndGet(unFreezeV2.getUnfreezeAmount());
        }
    }

    public boolean validate() throws ContractValidateException {
        byte[] ownerAddress;
        if (Objects.isNull(this.any)) {
            throw new ContractValidateException("No contract!");
        }
        if (Objects.isNull(this.chainBaseManager)) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        if (!this.any.is(BalanceContract.CancelAllUnfreezeV2Contract.class)) {
            throw new ContractValidateException("contract type error, expected type [CancelAllUnfreezeV2Contract], real type[" + this.any.getClass() + "]");
        }
        if (!dynamicStore.supportAllowCancelAllUnfreezeV2()) {
            throw new ContractValidateException("Not support CancelAllUnfreezeV2 transaction, need to be opened by the committee");
        }
        try {
            ownerAddress = this.getOwnerAddress().toByteArray();
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("Invalid address");
        }
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        String readableOwnerAddress = StringUtil.createReadableString((byte[])ownerAddress);
        if (Objects.isNull(accountCapsule)) {
            throw new ContractValidateException("Account[" + readableOwnerAddress + "] not exists");
        }
        List unfrozenV2List = accountCapsule.getUnfrozenV2List();
        if (unfrozenV2List.isEmpty()) {
            throw new ContractValidateException("No unfreezeV2 list to cancel");
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return this.getCancelAllUnfreezeV2Contract().getOwnerAddress();
    }

    private BalanceContract.CancelAllUnfreezeV2Contract getCancelAllUnfreezeV2Contract() throws InvalidProtocolBufferException {
        return (BalanceContract.CancelAllUnfreezeV2Contract)this.any.unpack(BalanceContract.CancelAllUnfreezeV2Contract.class);
    }

    public long calcFee() {
        return 0L;
    }

    public void updateFrozenInfoAndTotalResourceWeight(AccountCapsule accountCapsule, Protocol.Account.UnFreezeV2 unFreezeV2, Triple<Pair<AtomicLong, AtomicLong>, Pair<AtomicLong, AtomicLong>, Pair<AtomicLong, AtomicLong>> triple) {
        switch (unFreezeV2.getType()) {
            case BANDWIDTH: {
                long oldNetWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.BANDWIDTH) / 1000000L;
                accountCapsule.addFrozenBalanceForBandwidthV2(unFreezeV2.getUnfreezeAmount());
                long newNetWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.BANDWIDTH) / 1000000L;
                ((AtomicLong)((Pair)triple.getLeft()).getLeft()).addAndGet(newNetWeight - oldNetWeight);
                ((AtomicLong)((Pair)triple.getLeft()).getRight()).addAndGet(unFreezeV2.getUnfreezeAmount());
                break;
            }
            case ENERGY: {
                long oldEnergyWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.ENERGY) / 1000000L;
                accountCapsule.addFrozenBalanceForEnergyV2(unFreezeV2.getUnfreezeAmount());
                long newEnergyWeight = accountCapsule.getFrozenV2BalanceWithDelegated(Common.ResourceCode.ENERGY) / 1000000L;
                ((AtomicLong)((Pair)triple.getMiddle()).getLeft()).addAndGet(newEnergyWeight - oldEnergyWeight);
                ((AtomicLong)((Pair)triple.getMiddle()).getRight()).addAndGet(unFreezeV2.getUnfreezeAmount());
                break;
            }
            case TRON_POWER: {
                long oldTPWeight = accountCapsule.getTronPowerFrozenV2Balance() / 1000000L;
                accountCapsule.addFrozenForTronPowerV2(unFreezeV2.getUnfreezeAmount());
                long newTPWeight = accountCapsule.getTronPowerFrozenV2Balance() / 1000000L;
                ((AtomicLong)((Pair)triple.getRight()).getLeft()).addAndGet(newTPWeight - oldTPWeight);
                ((AtomicLong)((Pair)triple.getRight()).getRight()).addAndGet(unFreezeV2.getUnfreezeAmount());
                break;
            }
        }
    }
}

