/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.ChainBaseManager;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.actuator.Actuator;
import org.tron.core.actuator.TransactionFactory;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.protos.Protocol;

public class ActuatorFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");
    public static final ActuatorFactory INSTANCE = new ActuatorFactory();

    private ActuatorFactory() {
    }

    public static ActuatorFactory getInstance() {
        return INSTANCE;
    }

    public static List<Actuator> createActuator(TransactionCapsule transactionCapsule, ChainBaseManager chainBaseManager) {
        ArrayList actuatorList = Lists.newArrayList();
        if (null == transactionCapsule || null == transactionCapsule.getInstance()) {
            logger.info("TransactionCapsule or Transaction is null");
            return actuatorList;
        }
        Preconditions.checkNotNull((Object)chainBaseManager, (Object)"manager is null");
        Protocol.Transaction.raw rawData = transactionCapsule.getInstance().getRawData();
        rawData.getContractList().forEach(contract -> {
            try {
                actuatorList.add(ActuatorFactory.getActuatorByContract(contract, chainBaseManager, transactionCapsule));
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        });
        return actuatorList;
    }

    private static Actuator getActuatorByContract(Protocol.Transaction.Contract contract, ChainBaseManager manager, TransactionCapsule tx) throws IllegalAccessException, InstantiationException {
        Class clazz = TransactionFactory.getActuator((Protocol.Transaction.Contract.ContractType)contract.getType());
        AbstractActuator abstractActuator = (AbstractActuator)clazz.newInstance();
        abstractActuator.setChainBaseManager(manager).setContract(contract).setForkUtils(manager.getForkController()).setTx(tx);
        return abstractActuator;
    }
}

