/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.actuator;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.utils.Commons;
import org.tron.common.utils.DecodeUtil;
import org.tron.core.actuator.AbstractActuator;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionResultCapsule;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.store.AccountStore;
import org.tron.core.store.DynamicPropertiesStore;
import org.tron.protos.Protocol;
import org.tron.protos.contract.AccountContract;

public class AccountPermissionUpdateActuator
extends AbstractActuator {
    private static final Logger logger = LoggerFactory.getLogger((String)"actuator");

    public AccountPermissionUpdateActuator() {
        super(Protocol.Transaction.Contract.ContractType.AccountPermissionUpdateContract, AccountContract.AccountPermissionUpdateContract.class);
    }

    public boolean execute(Object object) throws ContractExeException {
        TransactionResultCapsule result = (TransactionResultCapsule)object;
        if (Objects.isNull(result)) {
            throw new RuntimeException("TransactionResultCapsule is null");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        long fee = this.calcFee();
        try {
            AccountContract.AccountPermissionUpdateContract accountPermissionUpdateContract = (AccountContract.AccountPermissionUpdateContract)this.any.unpack(AccountContract.AccountPermissionUpdateContract.class);
            byte[] ownerAddress = accountPermissionUpdateContract.getOwnerAddress().toByteArray();
            AccountCapsule account = accountStore.get(ownerAddress);
            account.updatePermissions(accountPermissionUpdateContract.getOwner(), accountPermissionUpdateContract.getWitness(), accountPermissionUpdateContract.getActivesList());
            accountStore.put(ownerAddress, account);
            Commons.adjustBalance((AccountStore)accountStore, (byte[])ownerAddress, (long)(-fee));
            if (this.chainBaseManager.getDynamicPropertiesStore().supportBlackHoleOptimization()) {
                this.chainBaseManager.getDynamicPropertiesStore().burnTrx(fee);
            } else {
                Commons.adjustBalance((AccountStore)accountStore, (AccountCapsule)accountStore.getBlackhole(), (long)fee);
            }
            result.setStatus(fee, Protocol.Transaction.Result.code.SUCESS);
        }
        catch (InvalidProtocolBufferException | BalanceInsufficientException e) {
            logger.debug(e.getMessage(), e);
            result.setStatus(fee, Protocol.Transaction.Result.code.FAILED);
            throw new ContractExeException(e.getMessage());
        }
        return true;
    }

    private boolean checkPermission(Protocol.Permission permission) throws ContractValidateException {
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        if (permission.getKeysCount() > dynamicStore.getTotalSignNum()) {
            throw new ContractValidateException("number of keys in permission should not be greater than " + dynamicStore.getTotalSignNum());
        }
        if (permission.getKeysCount() == 0) {
            throw new ContractValidateException("key's count should be greater than 0");
        }
        if (permission.getType() == Protocol.Permission.PermissionType.Witness && permission.getKeysCount() != 1) {
            throw new ContractValidateException("Witness permission's key count should be 1");
        }
        if (permission.getThreshold() <= 0L) {
            throw new ContractValidateException("permission's threshold should be greater than 0");
        }
        String name = permission.getPermissionName();
        if (!StringUtils.isEmpty((CharSequence)name) && name.length() > 32) {
            throw new ContractValidateException("permission's name is too long");
        }
        if (permission.getParentId() != 0) {
            throw new ContractValidateException("permission's parent should be owner");
        }
        long weightSum = 0L;
        List addressList = permission.getKeysList().stream().map(x -> x.getAddress()).distinct().collect(Collectors.toList());
        if (addressList.size() != permission.getKeysList().size()) {
            throw new ContractValidateException("address should be distinct in permission " + permission.getType());
        }
        for (Protocol.Key key : permission.getKeysList()) {
            if (!DecodeUtil.addressValid((byte[])key.getAddress().toByteArray())) {
                throw new ContractValidateException("key is not a validate address");
            }
            if (key.getWeight() <= 0L) {
                throw new ContractValidateException("key's weight should be greater than 0");
            }
            try {
                weightSum = Math.addExact(weightSum, key.getWeight());
            }
            catch (ArithmeticException e) {
                throw new ContractValidateException(e.getMessage());
            }
        }
        if (weightSum < permission.getThreshold()) {
            throw new ContractValidateException("sum of all key's weight should not be less than threshold in permission " + permission.getType());
        }
        ByteString operations = permission.getOperations();
        if (permission.getType() != Protocol.Permission.PermissionType.Active) {
            if (!operations.isEmpty()) {
                throw new ContractValidateException(permission.getType() + " permission needn't operations");
            }
            return true;
        }
        if (operations.isEmpty() || operations.size() != 32) {
            throw new ContractValidateException("operations size must 32");
        }
        byte[] types1 = dynamicStore.getAvailableContractType();
        for (int i = 0; i < 256; ++i) {
            boolean t;
            boolean b = (operations.byteAt(i / 8) & 1 << i % 8) != 0;
            boolean bl = t = (types1[i / 8] & 0xFF & 1 << i % 8) != 0;
            if (!b || t) continue;
            throw new ContractValidateException(i + " isn't a validate ContractType");
        }
        return true;
    }

    public boolean validate() throws ContractValidateException {
        AccountContract.AccountPermissionUpdateContract accountPermissionUpdateContract;
        if (this.chainBaseManager == null) {
            throw new ContractValidateException("No account store or dynamic store!");
        }
        if (this.any == null) {
            throw new ContractValidateException("No contract!");
        }
        AccountStore accountStore = this.chainBaseManager.getAccountStore();
        DynamicPropertiesStore dynamicStore = this.chainBaseManager.getDynamicPropertiesStore();
        if (dynamicStore.getAllowMultiSign() != 1L) {
            throw new ContractValidateException("multi sign is not allowed, need to be opened by the committee");
        }
        if (!this.any.is(AccountContract.AccountPermissionUpdateContract.class)) {
            throw new ContractValidateException("contract type error,expected type [AccountPermissionUpdateContract],real type[" + this.any.getClass() + "]");
        }
        try {
            accountPermissionUpdateContract = (AccountContract.AccountPermissionUpdateContract)this.any.unpack(AccountContract.AccountPermissionUpdateContract.class);
        }
        catch (InvalidProtocolBufferException e) {
            logger.debug(e.getMessage(), (Throwable)e);
            throw new ContractValidateException(e.getMessage());
        }
        byte[] ownerAddress = accountPermissionUpdateContract.getOwnerAddress().toByteArray();
        if (!DecodeUtil.addressValid((byte[])ownerAddress)) {
            throw new ContractValidateException("invalidate ownerAddress");
        }
        AccountCapsule accountCapsule = accountStore.get(ownerAddress);
        if (accountCapsule == null) {
            throw new ContractValidateException("ownerAddress account does not exist");
        }
        if (!accountPermissionUpdateContract.hasOwner()) {
            throw new ContractValidateException("owner permission is missed");
        }
        if (accountCapsule.getIsWitness()) {
            if (!accountPermissionUpdateContract.hasWitness()) {
                throw new ContractValidateException("witness permission is missed");
            }
        } else if (accountPermissionUpdateContract.hasWitness()) {
            throw new ContractValidateException("account isn't witness can't set witness permission");
        }
        if (accountPermissionUpdateContract.getActivesCount() == 0) {
            throw new ContractValidateException("active permission is missed");
        }
        if (accountPermissionUpdateContract.getActivesCount() > 8) {
            throw new ContractValidateException("active permission is too many");
        }
        Protocol.Permission owner = accountPermissionUpdateContract.getOwner();
        Protocol.Permission witness = accountPermissionUpdateContract.getWitness();
        List actives = accountPermissionUpdateContract.getActivesList();
        if (owner.getType() != Protocol.Permission.PermissionType.Owner) {
            throw new ContractValidateException("owner permission type is error");
        }
        this.checkPermission(owner);
        if (accountCapsule.getIsWitness()) {
            if (witness.getType() != Protocol.Permission.PermissionType.Witness) {
                throw new ContractValidateException("witness permission type is error");
            }
            this.checkPermission(witness);
        }
        for (Protocol.Permission permission : actives) {
            if (permission.getType() != Protocol.Permission.PermissionType.Active) {
                throw new ContractValidateException("active permission type is error");
            }
            this.checkPermission(permission);
        }
        return true;
    }

    public ByteString getOwnerAddress() throws InvalidProtocolBufferException {
        return ((AccountContract.AccountPermissionUpdateContract)this.any.unpack(AccountContract.AccountPermissionUpdateContract.class)).getOwnerAddress();
    }

    public long calcFee() {
        return this.chainBaseManager.getDynamicPropertiesStore().getUpdateAccountPermissionFee();
    }
}

