/*
 * Decompiled with CFR 0.152.
 */
package org.tron.program;

import com.beust.jcommander.JCommander;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.crypto.ECKey;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Utils;
import org.tron.core.config.args.Args;
import org.tron.keystore.CipherException;
import org.tron.keystore.Credentials;
import org.tron.keystore.WalletUtils;

public class KeystoreFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)"KeystoreFactory");
    private static final String FilePath = "Wallet";

    private boolean priKeyValid(String priKey) {
        if (StringUtils.isEmpty((CharSequence)priKey)) {
            logger.warn("Warning: PrivateKey is empty !!");
            return false;
        }
        if (priKey.length() != 64) {
            logger.warn("Warning: PrivateKey length need 64 but " + priKey.length() + " !!");
            return false;
        }
        return true;
    }

    private void genKeystore() throws CipherException, IOException {
        String password = WalletUtils.inputPassword2Twice();
        ECKey eCkey = new ECKey(Utils.random);
        File file = new File(FilePath);
        if (!file.exists()) {
            if (!file.mkdir()) {
                throw new IOException("Make directory faild!");
            }
        } else if (!file.isDirectory()) {
            if (file.delete()) {
                if (!file.mkdir()) {
                    throw new IOException("Make directory faild!");
                }
            } else {
                throw new IOException("File is exists and can not delete!");
            }
        }
        String fileName = WalletUtils.generateWalletFile(password, eCkey, file, true);
        System.out.println("Gen a keystore its name " + fileName);
        Credentials credentials = WalletUtils.loadCredentials(password, new File(file, fileName));
        System.out.println("Your address is " + credentials.getAddress());
    }

    private void importPrivatekey() throws CipherException, IOException {
        String input;
        String privateKey;
        Scanner in = new Scanner(System.in);
        System.out.println("Please input private key.");
        while (!this.priKeyValid(privateKey = (input = in.nextLine().trim()).split("\\s+")[0])) {
            System.out.println("Invalid private key, please input again.");
        }
        String password = WalletUtils.inputPassword2Twice();
        ECKey eCkey = ECKey.fromPrivate(ByteArray.fromHexString(privateKey));
        File file = new File(FilePath);
        if (!file.exists()) {
            if (!file.mkdir()) {
                throw new IOException("Make directory faild!");
            }
        } else if (!file.isDirectory()) {
            if (file.delete()) {
                if (!file.mkdir()) {
                    throw new IOException("Make directory faild!");
                }
            } else {
                throw new IOException("File is exists and can not delete!");
            }
        }
        String fileName = WalletUtils.generateWalletFile(password, eCkey, file, true);
        System.out.println("Gen a keystore its name " + fileName);
        Credentials credentials = WalletUtils.loadCredentials(password, new File(file, fileName));
        System.out.println("Your address is " + credentials.getAddress());
    }

    private void help() {
        System.out.println("You can enter the following command: ");
        System.out.println("GenKeystore");
        System.out.println("ImportPrivatekey");
        System.out.println("Exit or Quit");
        System.out.println("Input any one of then, you will get more tips.");
    }

    private void run() {
        Scanner in = new Scanner(System.in);
        this.help();
        block15: while (in.hasNextLine()) {
            try {
                String cmdLowerCase;
                String cmdLine = in.nextLine().trim();
                String[] cmdArray = cmdLine.split("\\s+");
                String cmd = cmdArray[0];
                if ("".equals(cmd)) continue;
                switch (cmdLowerCase = cmd.toLowerCase()) {
                    case "help": {
                        this.help();
                        continue block15;
                    }
                    case "genkeystore": {
                        this.genKeystore();
                        continue block15;
                    }
                    case "importprivatekey": {
                        this.importPrivatekey();
                        continue block15;
                    }
                    case "exit": 
                    case "quit": {
                        System.out.println("Exit !!!");
                        in.close();
                        return;
                    }
                }
                System.out.println("Invalid cmd: " + cmd);
                this.help();
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    public static void main(String[] args) {
        Args.setParam(args, "config.conf");
        KeystoreFactory cli = new KeystoreFactory();
        JCommander.newBuilder().addObject((Object)cli).build().parse(args);
        cli.run();
    }
}

