/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.interfaceOnSolidity.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.core.db.Manager;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.Util;
import org.tron.core.services.interfaceOnSolidity.WalletOnSolidity;
import org.tron.protos.Protocol;

@Component
public class GetAccountOnSolidityServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(GetAccountOnSolidityServlet.class);
    @Autowired
    private WalletOnSolidity walletOnSolidity;
    @Autowired
    private Manager dbManager;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String address = request.getParameter("address");
            Protocol.Account.Builder build = Protocol.Account.newBuilder();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("address", (Object)address);
            JsonFormat.merge(jsonObject.toJSONString(), (Message.Builder)build);
            Protocol.Account reply = this.walletOnSolidity.getAccount(build.build());
            if (reply != null) {
                response.getWriter().println(JsonFormat.printToString((Message)reply));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String account = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            Protocol.Account.Builder build = Protocol.Account.newBuilder();
            JsonFormat.merge(account, (Message.Builder)build);
            Protocol.Account reply = this.walletOnSolidity.getAccount(build.build());
            if (reply != null) {
                response.getWriter().println(JsonFormat.printToString((Message)reply));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }
}

