/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.interfaceOnSolidity;

import com.google.protobuf.ByteString;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.netty.NettyServerBuilder;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.tron.api.DatabaseGrpc;
import org.tron.api.GrpcAPI;
import org.tron.api.WalletSolidityGrpc;
import org.tron.common.application.Service;
import org.tron.common.crypto.ECKey;
import org.tron.common.utils.Sha256Hash;
import org.tron.common.utils.Utils;
import org.tron.core.Wallet;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.Manager;
import org.tron.core.exception.HeaderNotFound;
import org.tron.core.exception.StoreException;
import org.tron.core.services.interfaceOnSolidity.WalletOnSolidity;
import org.tron.protos.Protocol;

public class RpcApiServiceOnSolidity
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(RpcApiServiceOnSolidity.class);
    private int port = Args.getInstance().getRpcOnSolidityPort();
    private Server apiServer;
    @Autowired
    private Manager dbManager;
    @Autowired
    private WalletOnSolidity walletOnSolidity;

    @Override
    public void init() {
    }

    @Override
    public void init(Args args) {
    }

    @Override
    public void start() {
        try {
            NettyServerBuilder serverBuilder = (NettyServerBuilder)NettyServerBuilder.forPort((int)this.port).addService((BindableService)new DatabaseApi());
            Args args = Args.getInstance();
            if (args.getRpcThreadNum() > 0) {
                serverBuilder = (NettyServerBuilder)serverBuilder.executor((Executor)Executors.newFixedThreadPool(args.getRpcThreadNum()));
            }
            serverBuilder = (NettyServerBuilder)serverBuilder.addService((BindableService)new WalletSolidityApi());
            serverBuilder.maxConcurrentCallsPerConnection(args.getMaxConcurrentCallsPerConnection()).flowControlWindow(args.getFlowControlWindow()).maxConnectionIdle(args.getMaxConnectionIdleInMillis(), TimeUnit.MILLISECONDS).maxConnectionAge(args.getMaxConnectionAgeInMillis(), TimeUnit.MILLISECONDS).maxMessageSize(args.getMaxMessageSize()).maxHeaderListSize(args.getMaxHeaderListSize());
            this.apiServer = serverBuilder.build().start();
        }
        catch (IOException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        logger.info("RpcApiServiceOnSolidity started, listening on " + this.port);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            System.err.println("*** shutting down gRPC server on solidity since JVM is shutting down");
            System.err.println("*** server on solidity shut down");
        }));
    }

    private GrpcAPI.TransactionExtention transaction2Extention(Protocol.Transaction transaction) {
        if (transaction == null) {
            return null;
        }
        GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
        GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
        trxExtBuilder.setTransaction(transaction);
        trxExtBuilder.setTxid(Sha256Hash.of(transaction.getRawData().toByteArray()).getByteString());
        retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
        trxExtBuilder.setResult(retBuilder);
        return trxExtBuilder.build();
    }

    private GrpcAPI.BlockExtention block2Extention(Protocol.Block block) {
        if (block == null) {
            return null;
        }
        GrpcAPI.BlockExtention.Builder builder = GrpcAPI.BlockExtention.newBuilder();
        BlockCapsule blockCapsule = new BlockCapsule(block);
        builder.setBlockHeader(block.getBlockHeader());
        builder.setBlockid(ByteString.copyFrom((byte[])blockCapsule.getBlockId().getBytes()));
        for (int i = 0; i < block.getTransactionsCount(); ++i) {
            Protocol.Transaction transaction = block.getTransactions(i);
            builder.addTransactions(this.transaction2Extention(transaction));
        }
        return builder.build();
    }

    private BlockCapsule getHeadOnSolidity() throws HeaderNotFound {
        List<BlockCapsule> blocks = this.dbManager.getBlockStore().getBlockByLatestNumOnSolidity(1L);
        if (CollectionUtils.isNotEmpty(blocks)) {
            return blocks.get(0);
        }
        logger.info("Header block Not Found");
        throw new HeaderNotFound("Header block Not Found");
    }

    public static void updateNetUsage(AccountCapsule accountCapsule) {
        accountCapsule.setNetUsage(-1L);
        accountCapsule.setFreeNetUsage(-1L);
        Map<String, Long> assetMap = accountCapsule.getAssetMap();
        assetMap.forEach((assetName, balance) -> accountCapsule.putFreeAssetNetUsage((String)assetName, -1L));
    }

    public static void updateEnergyUsage(AccountCapsule accountCapsule) {
        accountCapsule.setEnergyUsage(-1L);
    }

    @Override
    public void stop() {
        if (this.apiServer != null) {
            this.apiServer.shutdown();
        }
    }

    private class WalletSolidityApi
    extends WalletSolidityGrpc.WalletSolidityImplBase {
        private WalletSolidityApi() {
        }

        @Override
        public void getAccount(Protocol.Account request, StreamObserver<Protocol.Account> responseObserver) {
            ByteString addressBs = request.getAddress();
            if (addressBs != null) {
                Protocol.Account reply = RpcApiServiceOnSolidity.this.walletOnSolidity.getAccount(request);
                if (reply == null) {
                    responseObserver.onNext(null);
                } else {
                    AccountCapsule accountCapsule = new AccountCapsule(reply);
                    RpcApiServiceOnSolidity.updateNetUsage(accountCapsule);
                    responseObserver.onNext((Object)accountCapsule.getInstance());
                }
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getAccountById(Protocol.Account request, StreamObserver<Protocol.Account> responseObserver) {
            ByteString id = request.getAccountId();
            if (id != null) {
                Protocol.Account reply = RpcApiServiceOnSolidity.this.walletOnSolidity.getAccountById(request);
                if (reply == null) {
                    responseObserver.onNext(null);
                } else {
                    AccountCapsule accountCapsule = new AccountCapsule(reply);
                    RpcApiServiceOnSolidity.updateNetUsage(accountCapsule);
                    responseObserver.onNext((Object)accountCapsule.getInstance());
                }
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void listWitnesses(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.WitnessList> responseObserver) {
            responseObserver.onNext((Object)RpcApiServiceOnSolidity.this.walletOnSolidity.getWitnessList());
            responseObserver.onCompleted();
        }

        @Override
        public void getAssetIssueList(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            responseObserver.onNext((Object)RpcApiServiceOnSolidity.this.walletOnSolidity.getAssetIssueList());
            responseObserver.onCompleted();
        }

        @Override
        public void getPaginatedAssetIssueList(GrpcAPI.PaginatedMessage request, StreamObserver<GrpcAPI.AssetIssueList> responseObserver) {
            responseObserver.onNext((Object)RpcApiServiceOnSolidity.this.walletOnSolidity.getAssetIssueList(request.getOffset(), request.getLimit()));
            responseObserver.onCompleted();
        }

        @Override
        public void getNowBlock(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.Block> responseObserver) {
            responseObserver.onNext((Object)RpcApiServiceOnSolidity.this.walletOnSolidity.getNowBlock());
            responseObserver.onCompleted();
        }

        @Override
        public void getNowBlock2(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            responseObserver.onNext((Object)RpcApiServiceOnSolidity.this.block2Extention(RpcApiServiceOnSolidity.this.walletOnSolidity.getNowBlock()));
            responseObserver.onCompleted();
        }

        @Override
        public void getBlockByNum(GrpcAPI.NumberMessage request, StreamObserver<Protocol.Block> responseObserver) {
            long num = request.getNum();
            if (num >= 0L) {
                Protocol.Block reply = RpcApiServiceOnSolidity.this.walletOnSolidity.getBlockByNum(num);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getBlockByNum2(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.BlockExtention> responseObserver) {
            long num = request.getNum();
            if (num >= 0L) {
                Protocol.Block reply = RpcApiServiceOnSolidity.this.walletOnSolidity.getBlockByNum(num);
                responseObserver.onNext((Object)RpcApiServiceOnSolidity.this.block2Extention(reply));
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getDelegatedResource(GrpcAPI.DelegatedResourceMessage request, StreamObserver<GrpcAPI.DelegatedResourceList> responseObserver) {
            responseObserver.onNext((Object)RpcApiServiceOnSolidity.this.walletOnSolidity.getDelegatedResource(request.getFromAddress(), request.getToAddress()));
            responseObserver.onCompleted();
        }

        @Override
        public void getDelegatedResourceAccountIndex(GrpcAPI.BytesMessage request, StreamObserver<Protocol.DelegatedResourceAccountIndex> responseObserver) {
            responseObserver.onNext((Object)RpcApiServiceOnSolidity.this.walletOnSolidity.getDelegatedResourceAccountIndex(request.getValue()));
            responseObserver.onCompleted();
        }

        @Override
        public void getTransactionCountByBlockNum(GrpcAPI.NumberMessage request, StreamObserver<GrpcAPI.NumberMessage> responseObserver) {
            GrpcAPI.NumberMessage.Builder builder = GrpcAPI.NumberMessage.newBuilder();
            try {
                Protocol.Block block = RpcApiServiceOnSolidity.this.dbManager.getBlockById(RpcApiServiceOnSolidity.this.dbManager.getBlockIndexStore().getOnSolidity(request.getNum())).getInstance();
                builder.setNum(block.getTransactionsCount());
            }
            catch (StoreException e) {
                logger.error(e.getMessage());
                builder.setNum(-1L);
            }
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }

        @Override
        public void getTransactionById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.Transaction> responseObserver) {
            ByteString id = request.getValue();
            if (null != id) {
                Protocol.Transaction reply = RpcApiServiceOnSolidity.this.walletOnSolidity.getTransactionById(id);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void getTransactionInfoById(GrpcAPI.BytesMessage request, StreamObserver<Protocol.TransactionInfo> responseObserver) {
            ByteString id = request.getValue();
            if (null != id) {
                Protocol.TransactionInfo reply = RpcApiServiceOnSolidity.this.walletOnSolidity.getTransactionInfoById(id);
                responseObserver.onNext((Object)reply);
            } else {
                responseObserver.onNext(null);
            }
            responseObserver.onCompleted();
        }

        @Override
        public void generateAddress(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.AddressPrKeyPairMessage> responseObserver) {
            ECKey ecKey = new ECKey(Utils.getRandom());
            byte[] priKey = ecKey.getPrivKeyBytes();
            byte[] address = ecKey.getAddress();
            String addressStr = Wallet.encode58Check(address);
            String priKeyStr = Hex.encodeHexString((byte[])priKey);
            GrpcAPI.AddressPrKeyPairMessage.Builder builder = GrpcAPI.AddressPrKeyPairMessage.newBuilder();
            builder.setAddress(addressStr);
            builder.setPrivateKey(priKeyStr);
            responseObserver.onNext((Object)builder.build());
            responseObserver.onCompleted();
        }
    }

    private class DatabaseApi
    extends DatabaseGrpc.DatabaseImplBase {
        private DatabaseApi() {
        }

        @Override
        public void getBlockReference(GrpcAPI.EmptyMessage request, StreamObserver<GrpcAPI.BlockReference> responseObserver) {
            long headBlockNum = RpcApiServiceOnSolidity.this.dbManager.getDynamicPropertiesStore().getLatestBlockHeaderNumberOnSolidity();
            byte[] blockHeaderHash = RpcApiServiceOnSolidity.this.dbManager.getDynamicPropertiesStore().getLatestBlockHeaderHashOnSolidity().getBytes();
            GrpcAPI.BlockReference ref = GrpcAPI.BlockReference.newBuilder().setBlockHash(ByteString.copyFrom((byte[])blockHeaderHash)).setBlockNum(headBlockNum).build();
            responseObserver.onNext((Object)ref);
            responseObserver.onCompleted();
        }

        @Override
        public void getNowBlock(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.Block> responseObserver) {
            Protocol.Block block = null;
            try {
                block = RpcApiServiceOnSolidity.this.getHeadOnSolidity().getInstance();
            }
            catch (StoreException e) {
                logger.error(e.getMessage());
            }
            responseObserver.onNext((Object)block);
            responseObserver.onCompleted();
        }

        @Override
        public void getBlockByNum(GrpcAPI.NumberMessage request, StreamObserver<Protocol.Block> responseObserver) {
            Protocol.Block block = null;
            try {
                block = RpcApiServiceOnSolidity.this.dbManager.getBlockById(RpcApiServiceOnSolidity.this.dbManager.getBlockIndexStore().getOnSolidity(request.getNum())).getInstance();
            }
            catch (StoreException e) {
                logger.error(e.getMessage());
            }
            responseObserver.onNext(block);
            responseObserver.onCompleted();
        }

        @Override
        public void getDynamicProperties(GrpcAPI.EmptyMessage request, StreamObserver<Protocol.DynamicProperties> responseObserver) {
            Protocol.DynamicProperties.Builder builder = Protocol.DynamicProperties.newBuilder();
            builder.setLastSolidityBlockNum(RpcApiServiceOnSolidity.this.dbManager.getDynamicPropertiesStore().getLatestBlockHeaderNumberOnSolidity());
            Protocol.DynamicProperties dynamicProperties = builder.build();
            responseObserver.onNext((Object)dynamicProperties);
            responseObserver.onCompleted();
        }
    }
}

