/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http.solidity;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class GetTransactionByIdSolidityServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(GetTransactionByIdSolidityServlet.class);
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String input = request.getParameter("value");
            Protocol.Transaction reply = this.wallet.getTransactionById(ByteString.copyFrom((byte[])ByteArray.fromHexString(input)));
            if (reply != null) {
                response.getWriter().println(Util.printTransaction(reply));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(e.getMessage());
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String input = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            GrpcAPI.BytesMessage.Builder build = GrpcAPI.BytesMessage.newBuilder();
            JsonFormat.merge(input, (Message.Builder)build);
            Protocol.Transaction reply = this.wallet.getTransactionById(build.build().getValue());
            if (reply != null) {
                response.getWriter().println(Util.printTransaction(reply));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(e.getMessage());
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }
}

