/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.Base64;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;

@Component
public class ValidateAddressServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ValidateAddressServlet.class);

    private String validAddress(String input) {
        String msg;
        byte[] address = null;
        boolean result = true;
        try {
            if (input.length() == 42) {
                address = ByteArray.fromHexString(input);
                msg = "Hex string format";
            } else if (input.length() == 34) {
                address = Wallet.decodeFromBase58Check(input);
                msg = "Base58check format";
            } else if (input.length() == 28) {
                address = Base64.getDecoder().decode(input);
                msg = "Base64 format";
            } else {
                result = false;
                msg = "Length error";
            }
            if (result && !(result = Wallet.addressValid(address))) {
                msg = "Invalid address";
            }
        }
        catch (Exception e) {
            result = false;
            msg = e.getMessage();
        }
        JSONObject jsonAddress = new JSONObject();
        jsonAddress.put("result", (Object)result);
        jsonAddress.put("message", (Object)msg);
        return jsonAddress.toJSONString();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        String input = request.getParameter("address");
        try {
            response.getWriter().println(this.validAddress(input));
        }
        catch (IOException e) {
            logger.debug("IOException: {}", (Object)e.getMessage());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String input = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            JSONObject jsonAddress = JSON.parseObject((String)input);
            response.getWriter().println(this.validAddress(jsonAddress.getString("address")));
        }
        catch (IOException e) {
            logger.debug("IOException: {}", (Object)e.getMessage());
        }
    }
}

