/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.api.GrpcAPI;
import org.tron.common.crypto.Hash;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.services.http.JsonFormat;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);

    public static String printErrorMsg(Exception e) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Error", (Object)(e.getClass() + " : " + e.getMessage()));
        return jsonObject.toJSONString();
    }

    public static String printBlockList(GrpcAPI.BlockList list) {
        List<Protocol.Block> blocks = list.getBlockList();
        JSONObject jsonObject = JSONObject.parseObject((String)JsonFormat.printToString((Message)list));
        JSONArray jsonArray = new JSONArray();
        blocks.stream().forEach(block -> jsonArray.add((Object)Util.printBlockToJSON(block)));
        jsonObject.put("block", (Object)jsonArray);
        return jsonObject.toJSONString();
    }

    public static String printBlock(Protocol.Block block) {
        return Util.printBlockToJSON(block).toJSONString();
    }

    public static JSONObject printBlockToJSON(Protocol.Block block) {
        BlockCapsule blockCapsule = new BlockCapsule(block);
        String blockID = ByteArray.toHexString(blockCapsule.getBlockId().getBytes());
        JSONObject jsonObject = JSONObject.parseObject((String)JsonFormat.printToString((Message)block));
        jsonObject.put("blockID", (Object)blockID);
        if (!blockCapsule.getTransactions().isEmpty()) {
            jsonObject.put("transactions", (Object)Util.printTransactionListToJSON(blockCapsule.getTransactions()));
        }
        return jsonObject;
    }

    public static String printTransactionList(GrpcAPI.TransactionList list) {
        List<Protocol.Transaction> transactions = list.getTransactionList();
        JSONObject jsonObject = JSONObject.parseObject((String)JsonFormat.printToString((Message)list));
        JSONArray jsonArray = new JSONArray();
        transactions.stream().forEach(transaction -> jsonArray.add((Object)Util.printTransactionToJSON(transaction)));
        jsonObject.put("transaction", (Object)jsonArray);
        return jsonObject.toJSONString();
    }

    public static JSONArray printTransactionListToJSON(List<TransactionCapsule> list) {
        JSONArray transactions = new JSONArray();
        list.stream().forEach(transactionCapsule -> transactions.add((Object)Util.printTransactionToJSON(transactionCapsule.getInstance())));
        return transactions;
    }

    public static String printEasyTransferResponse(GrpcAPI.EasyTransferResponse response) {
        JSONObject jsonResponse = JSONObject.parseObject((String)JsonFormat.printToString((Message)response));
        jsonResponse.put("transaction", (Object)Util.printTransactionToJSON(response.getTransaction()));
        return jsonResponse.toJSONString();
    }

    public static String printTransaction(Protocol.Transaction transaction) {
        return Util.printTransactionToJSON(transaction).toJSONString();
    }

    public static String printTransactionExtention(GrpcAPI.TransactionExtention transactionExtention) {
        String string = JsonFormat.printToString((Message)transactionExtention);
        JSONObject jsonObject = JSONObject.parseObject((String)string);
        if (transactionExtention.getResult().getResult()) {
            jsonObject.put("transaction", (Object)Util.printTransactionToJSON(transactionExtention.getTransaction()));
        }
        return jsonObject.toJSONString();
    }

    public static byte[] generateContractAddress(Protocol.Transaction trx, byte[] ownerAddress) {
        byte[] txRawDataHash = Sha256Hash.of(trx.getRawData().toByteArray()).getBytes();
        byte[] combined = new byte[txRawDataHash.length + ownerAddress.length];
        System.arraycopy(txRawDataHash, 0, combined, 0, txRawDataHash.length);
        System.arraycopy(ownerAddress, 0, combined, txRawDataHash.length, ownerAddress.length);
        return Hash.sha3omit12(combined);
    }

    public static JSONObject printTransactionToJSON(Protocol.Transaction transaction) {
        JSONObject jsonTransaction = JSONObject.parseObject((String)JsonFormat.printToString((Message)transaction));
        JSONArray contracts = new JSONArray();
        transaction.getRawData().getContractList().stream().forEach(contract -> {
            try {
                JSONObject contractJson = null;
                Any contractParameter = contract.getParameter();
                switch (contract.getType()) {
                    case AccountCreateContract: {
                        Contract.AccountCreateContract accountCreateContract = (Contract.AccountCreateContract)contractParameter.unpack(Contract.AccountCreateContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)accountCreateContract));
                        break;
                    }
                    case TransferContract: {
                        Contract.TransferContract transferContract = (Contract.TransferContract)contractParameter.unpack(Contract.TransferContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)transferContract));
                        break;
                    }
                    case TransferAssetContract: {
                        Contract.TransferAssetContract transferAssetContract = (Contract.TransferAssetContract)contractParameter.unpack(Contract.TransferAssetContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)transferAssetContract));
                        break;
                    }
                    case VoteAssetContract: {
                        Contract.VoteAssetContract voteAssetContract = (Contract.VoteAssetContract)contractParameter.unpack(Contract.VoteAssetContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)voteAssetContract));
                        break;
                    }
                    case VoteWitnessContract: {
                        Contract.VoteWitnessContract voteWitnessContract = (Contract.VoteWitnessContract)contractParameter.unpack(Contract.VoteWitnessContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)voteWitnessContract));
                        break;
                    }
                    case WitnessCreateContract: {
                        Contract.WitnessCreateContract witnessCreateContract = (Contract.WitnessCreateContract)contractParameter.unpack(Contract.WitnessCreateContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)witnessCreateContract));
                        break;
                    }
                    case AssetIssueContract: {
                        Contract.AssetIssueContract assetIssueContract = (Contract.AssetIssueContract)contractParameter.unpack(Contract.AssetIssueContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)assetIssueContract));
                        break;
                    }
                    case WitnessUpdateContract: {
                        Contract.WitnessUpdateContract witnessUpdateContract = (Contract.WitnessUpdateContract)contractParameter.unpack(Contract.WitnessUpdateContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)witnessUpdateContract));
                        break;
                    }
                    case ParticipateAssetIssueContract: {
                        Contract.ParticipateAssetIssueContract participateAssetIssueContract = (Contract.ParticipateAssetIssueContract)contractParameter.unpack(Contract.ParticipateAssetIssueContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)participateAssetIssueContract));
                        break;
                    }
                    case AccountUpdateContract: {
                        Contract.AccountUpdateContract accountUpdateContract = (Contract.AccountUpdateContract)contractParameter.unpack(Contract.AccountUpdateContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)accountUpdateContract));
                        break;
                    }
                    case FreezeBalanceContract: {
                        Contract.FreezeBalanceContract freezeBalanceContract = (Contract.FreezeBalanceContract)contractParameter.unpack(Contract.FreezeBalanceContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)freezeBalanceContract));
                        break;
                    }
                    case UnfreezeBalanceContract: {
                        Contract.UnfreezeBalanceContract unfreezeBalanceContract = (Contract.UnfreezeBalanceContract)contractParameter.unpack(Contract.UnfreezeBalanceContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)unfreezeBalanceContract));
                        break;
                    }
                    case UnfreezeAssetContract: {
                        Contract.UnfreezeAssetContract unfreezeAssetContract = (Contract.UnfreezeAssetContract)contractParameter.unpack(Contract.UnfreezeAssetContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)unfreezeAssetContract));
                        break;
                    }
                    case WithdrawBalanceContract: {
                        Contract.WithdrawBalanceContract withdrawBalanceContract = (Contract.WithdrawBalanceContract)contractParameter.unpack(Contract.WithdrawBalanceContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)withdrawBalanceContract));
                        break;
                    }
                    case UpdateAssetContract: {
                        Contract.UpdateAssetContract updateAssetContract = (Contract.UpdateAssetContract)contractParameter.unpack(Contract.UpdateAssetContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)updateAssetContract));
                        break;
                    }
                    case CreateSmartContract: {
                        Contract.CreateSmartContract deployContract = (Contract.CreateSmartContract)contractParameter.unpack(Contract.CreateSmartContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)deployContract));
                        byte[] ownerAddress = deployContract.getOwnerAddress().toByteArray();
                        byte[] contractAddress = Util.generateContractAddress(transaction, ownerAddress);
                        jsonTransaction.put("contract_address", (Object)ByteArray.toHexString(contractAddress));
                        break;
                    }
                    case TriggerSmartContract: {
                        Contract.TriggerSmartContract triggerSmartContract = (Contract.TriggerSmartContract)contractParameter.unpack(Contract.TriggerSmartContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)triggerSmartContract));
                        break;
                    }
                    case ProposalCreateContract: {
                        Contract.ProposalCreateContract proposalCreateContract = (Contract.ProposalCreateContract)contractParameter.unpack(Contract.ProposalCreateContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)proposalCreateContract));
                        break;
                    }
                    case ProposalApproveContract: {
                        Contract.ProposalApproveContract proposalApproveContract = (Contract.ProposalApproveContract)contractParameter.unpack(Contract.ProposalApproveContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)proposalApproveContract));
                        break;
                    }
                    case ProposalDeleteContract: {
                        Contract.ProposalDeleteContract proposalDeleteContract = (Contract.ProposalDeleteContract)contractParameter.unpack(Contract.ProposalDeleteContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)proposalDeleteContract));
                        break;
                    }
                    case ExchangeCreateContract: {
                        Contract.ExchangeCreateContract exchangeCreateContract = (Contract.ExchangeCreateContract)contractParameter.unpack(Contract.ExchangeCreateContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)exchangeCreateContract));
                        break;
                    }
                    case ExchangeInjectContract: {
                        Contract.ExchangeInjectContract exchangeInjectContract = (Contract.ExchangeInjectContract)contractParameter.unpack(Contract.ExchangeInjectContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)exchangeInjectContract));
                        break;
                    }
                    case ExchangeWithdrawContract: {
                        Contract.ExchangeWithdrawContract exchangeWithdrawContract = (Contract.ExchangeWithdrawContract)contractParameter.unpack(Contract.ExchangeWithdrawContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)exchangeWithdrawContract));
                        break;
                    }
                    case ExchangeTransactionContract: {
                        Contract.ExchangeTransactionContract exchangeTransactionContract = (Contract.ExchangeTransactionContract)contractParameter.unpack(Contract.ExchangeTransactionContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)exchangeTransactionContract));
                        break;
                    }
                    case UpdateSettingContract: {
                        Contract.UpdateSettingContract updateSettingContract = (Contract.UpdateSettingContract)contractParameter.unpack(Contract.UpdateSettingContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)updateSettingContract));
                        break;
                    }
                    case UpdateEnergyLimitContract: {
                        Contract.UpdateEnergyLimitContract updateEnergyLimitContract = (Contract.UpdateEnergyLimitContract)contractParameter.unpack(Contract.UpdateEnergyLimitContract.class);
                        contractJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)updateEnergyLimitContract));
                        break;
                    }
                }
                JSONObject parameter = new JSONObject();
                parameter.put("value", contractJson);
                parameter.put("type_url", (Object)contract.getParameterOrBuilder().getTypeUrl());
                JSONObject jsonContract = new JSONObject();
                jsonContract.put("parameter", (Object)parameter);
                jsonContract.put("type", (Object)contract.getType());
                contracts.add((Object)jsonContract);
            }
            catch (InvalidProtocolBufferException e) {
                logger.debug("InvalidProtocolBufferException: {}", (Object)e.getMessage());
            }
        });
        JSONObject rawData = JSONObject.parseObject((String)jsonTransaction.get((Object)"raw_data").toString());
        rawData.put("contract", (Object)contracts);
        jsonTransaction.put("raw_data", (Object)rawData);
        String txID = ByteArray.toHexString(Sha256Hash.hash(transaction.getRawData().toByteArray()));
        jsonTransaction.put("txID", (Object)txID);
        return jsonTransaction;
    }

    public static Protocol.Transaction packTransaction(String strTransaction) {
        JSONObject jsonTransaction = JSONObject.parseObject((String)strTransaction);
        JSONObject rawData = jsonTransaction.getJSONObject("raw_data");
        JSONArray contracts = new JSONArray();
        JSONArray rawContractArray = rawData.getJSONArray("contract");
        for (int i = 0; i < rawContractArray.size(); ++i) {
            try {
                JSONObject contract = rawContractArray.getJSONObject(i);
                JSONObject parameter = contract.getJSONObject("parameter");
                String contractType = contract.getString("type");
                Any any = null;
                switch (contractType) {
                    case "AccountCreateContract": {
                        Contract.AccountCreateContract.Builder accountCreateContractBuilder = Contract.AccountCreateContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)accountCreateContractBuilder);
                        any = Any.pack((Message)accountCreateContractBuilder.build());
                        break;
                    }
                    case "TransferContract": {
                        Contract.TransferContract.Builder transferContractBuilder = Contract.TransferContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)transferContractBuilder);
                        any = Any.pack((Message)transferContractBuilder.build());
                        break;
                    }
                    case "TransferAssetContract": {
                        Contract.TransferAssetContract.Builder transferAssetContractBuilder = Contract.TransferAssetContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)transferAssetContractBuilder);
                        any = Any.pack((Message)transferAssetContractBuilder.build());
                        break;
                    }
                    case "VoteAssetContract": {
                        Contract.VoteAssetContract.Builder voteAssetContractBuilder = Contract.VoteAssetContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)voteAssetContractBuilder);
                        any = Any.pack((Message)voteAssetContractBuilder.build());
                        break;
                    }
                    case "VoteWitnessContract": {
                        Contract.VoteWitnessContract.Builder voteWitnessContractBuilder = Contract.VoteWitnessContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)voteWitnessContractBuilder);
                        any = Any.pack((Message)voteWitnessContractBuilder.build());
                        break;
                    }
                    case "WitnessCreateContract": {
                        Contract.WitnessCreateContract.Builder witnessCreateContractBuilder = Contract.WitnessCreateContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)witnessCreateContractBuilder);
                        any = Any.pack((Message)witnessCreateContractBuilder.build());
                        break;
                    }
                    case "AssetIssueContract": {
                        Contract.AssetIssueContract.Builder assetIssueContractBuilder = Contract.AssetIssueContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)assetIssueContractBuilder);
                        any = Any.pack((Message)assetIssueContractBuilder.build());
                        break;
                    }
                    case "WitnessUpdateContract": {
                        Contract.WitnessUpdateContract.Builder witnessUpdateContractBuilder = Contract.WitnessUpdateContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)witnessUpdateContractBuilder);
                        any = Any.pack((Message)witnessUpdateContractBuilder.build());
                        break;
                    }
                    case "ParticipateAssetIssueContract": {
                        Contract.ParticipateAssetIssueContract.Builder participateAssetIssueContractBuilder = Contract.ParticipateAssetIssueContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)participateAssetIssueContractBuilder);
                        any = Any.pack((Message)participateAssetIssueContractBuilder.build());
                        break;
                    }
                    case "AccountUpdateContract": {
                        Contract.AccountUpdateContract.Builder accountUpdateContractBuilder = Contract.AccountUpdateContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)accountUpdateContractBuilder);
                        any = Any.pack((Message)accountUpdateContractBuilder.build());
                        break;
                    }
                    case "FreezeBalanceContract": {
                        Contract.FreezeBalanceContract.Builder freezeBalanceContractBuilder = Contract.FreezeBalanceContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)freezeBalanceContractBuilder);
                        any = Any.pack((Message)freezeBalanceContractBuilder.build());
                        break;
                    }
                    case "UnfreezeBalanceContract": {
                        Contract.UnfreezeBalanceContract.Builder unfreezeBalanceContractBuilder = Contract.UnfreezeBalanceContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)unfreezeBalanceContractBuilder);
                        any = Any.pack((Message)unfreezeBalanceContractBuilder.build());
                        break;
                    }
                    case "UnfreezeAssetContract": {
                        Contract.UnfreezeAssetContract.Builder unfreezeAssetContractBuilder = Contract.UnfreezeAssetContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)unfreezeAssetContractBuilder);
                        any = Any.pack((Message)unfreezeAssetContractBuilder.build());
                        break;
                    }
                    case "WithdrawBalanceContract": {
                        Contract.WithdrawBalanceContract.Builder withdrawBalanceContractBuilder = Contract.WithdrawBalanceContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)withdrawBalanceContractBuilder);
                        any = Any.pack((Message)withdrawBalanceContractBuilder.build());
                        break;
                    }
                    case "UpdateAssetContract": {
                        Contract.UpdateAssetContract.Builder updateAssetContractBuilder = Contract.UpdateAssetContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)updateAssetContractBuilder);
                        any = Any.pack((Message)updateAssetContractBuilder.build());
                        break;
                    }
                    case "SmartContract": {
                        Protocol.SmartContract.Builder smartContractBuilder = Protocol.SmartContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)smartContractBuilder);
                        any = Any.pack((Message)smartContractBuilder.build());
                        break;
                    }
                    case "TriggerSmartContract": {
                        Contract.TriggerSmartContract.Builder triggerSmartContractBuilder = Contract.TriggerSmartContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)triggerSmartContractBuilder);
                        any = Any.pack((Message)triggerSmartContractBuilder.build());
                        break;
                    }
                    case "CreateSmartContract": {
                        Contract.CreateSmartContract.Builder createSmartContractBuilder = Contract.CreateSmartContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)createSmartContractBuilder);
                        any = Any.pack((Message)createSmartContractBuilder.build());
                        break;
                    }
                    case "ExchangeCreateContract": {
                        Contract.ExchangeCreateContract.Builder exchangeCreateContractBuilder = Contract.ExchangeCreateContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)exchangeCreateContractBuilder);
                        any = Any.pack((Message)exchangeCreateContractBuilder.build());
                        break;
                    }
                    case "ExchangeInjectContract": {
                        Contract.ExchangeInjectContract.Builder exchangeInjectContractBuilder = Contract.ExchangeInjectContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)exchangeInjectContractBuilder);
                        any = Any.pack((Message)exchangeInjectContractBuilder.build());
                        break;
                    }
                    case "ExchangeTransactionContract": {
                        Contract.ExchangeTransactionContract.Builder exchangeTransactionContractBuilder = Contract.ExchangeTransactionContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)exchangeTransactionContractBuilder);
                        any = Any.pack((Message)exchangeTransactionContractBuilder.build());
                        break;
                    }
                    case "ExchangeWithdrawContract": {
                        Contract.ExchangeWithdrawContract.Builder exchangeWithdrawContractBuilder = Contract.ExchangeWithdrawContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)exchangeWithdrawContractBuilder);
                        any = Any.pack((Message)exchangeWithdrawContractBuilder.build());
                        break;
                    }
                    case "ProposalCreateContract": {
                        Contract.ProposalCreateContract.Builder ProposalCreateContractBuilder = Contract.ProposalCreateContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)ProposalCreateContractBuilder);
                        any = Any.pack((Message)ProposalCreateContractBuilder.build());
                        break;
                    }
                    case "ProposalApproveContract": {
                        Contract.ProposalApproveContract.Builder ProposalApproveContractBuilder = Contract.ProposalApproveContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)ProposalApproveContractBuilder);
                        any = Any.pack((Message)ProposalApproveContractBuilder.build());
                        break;
                    }
                    case "ProposalDeleteContract": {
                        Contract.ProposalDeleteContract.Builder ProposalDeleteContractBuilder = Contract.ProposalDeleteContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)ProposalDeleteContractBuilder);
                        any = Any.pack((Message)ProposalDeleteContractBuilder.build());
                        break;
                    }
                    case "UpdateSettingContract": {
                        Contract.UpdateSettingContract.Builder UpdateSettingContractBuilder = Contract.UpdateSettingContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)UpdateSettingContractBuilder);
                        any = Any.pack((Message)UpdateSettingContractBuilder.build());
                        break;
                    }
                    case "UpdateEnergyLimitContract": {
                        Contract.UpdateEnergyLimitContract.Builder UpdateEnergyLimitContractBuilder = Contract.UpdateEnergyLimitContract.newBuilder();
                        JsonFormat.merge(parameter.getJSONObject("value").toJSONString(), (Message.Builder)UpdateEnergyLimitContractBuilder);
                        any = Any.pack((Message)UpdateEnergyLimitContractBuilder.build());
                        break;
                    }
                }
                if (any == null) continue;
                String value = ByteArray.toHexString(any.getValue().toByteArray());
                parameter.put("value", (Object)value);
                contract.put("parameter", (Object)parameter);
                contracts.add((Object)contract);
                continue;
            }
            catch (JsonFormat.ParseException e) {
                logger.debug("ParseException: {}", (Object)e.getMessage());
            }
        }
        rawData.put("contract", (Object)contracts);
        jsonTransaction.put("raw_data", (Object)rawData);
        Protocol.Transaction.Builder transactionBuilder = Protocol.Transaction.newBuilder();
        try {
            JsonFormat.merge(jsonTransaction.toJSONString(), (Message.Builder)transactionBuilder);
            return transactionBuilder.build();
        }
        catch (JsonFormat.ParseException e) {
            logger.debug("ParseException: {}", (Object)e.getMessage());
            return null;
        }
    }
}

