/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.util.encoders.Hex;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.crypto.Hash;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.Util;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

@Component
public class TriggerSmartContractServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(TriggerSmartContractServlet.class);
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
    }

    public static String parseMethod(String methodSign, String params) {
        byte[] selector = new byte[4];
        System.arraycopy(Hash.sha3(methodSign.getBytes()), 0, selector, 0, 4);
        System.out.println(methodSign + ":" + Hex.toHexString((byte[])selector));
        if (StringUtils.isEmpty((CharSequence)params)) {
            return Hex.toHexString((byte[])selector);
        }
        String result = Hex.toHexString((byte[])selector) + params;
        return result;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Contract.TriggerSmartContract.Builder build = Contract.TriggerSmartContract.newBuilder();
        GrpcAPI.TransactionExtention.Builder trxExtBuilder = GrpcAPI.TransactionExtention.newBuilder();
        GrpcAPI.Return.Builder retBuilder = GrpcAPI.Return.newBuilder();
        try {
            String contract = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            JsonFormat.merge(contract, (Message.Builder)build);
            JSONObject jsonObject = JSONObject.parseObject((String)contract);
            String selector = jsonObject.getString("function_selector");
            String parameter = jsonObject.getString("parameter");
            String data = TriggerSmartContractServlet.parseMethod(selector, parameter);
            build.setData(ByteString.copyFrom((byte[])ByteArray.fromHexString(data)));
            long feeLimit = jsonObject.getLongValue("fee_limit");
            TransactionCapsule trxCap = this.wallet.createTransactionCapsule((Message)build.build(), Protocol.Transaction.Contract.ContractType.TriggerSmartContract);
            Protocol.Transaction.Builder txBuilder = trxCap.getInstance().toBuilder();
            Protocol.Transaction.raw.Builder rawBuilder = trxCap.getInstance().getRawData().toBuilder();
            rawBuilder.setFeeLimit(feeLimit);
            txBuilder.setRawData(rawBuilder);
            Protocol.Transaction trx = this.wallet.triggerContract(build.build(), new TransactionCapsule(txBuilder.build()), trxExtBuilder, retBuilder);
            trxExtBuilder.setTransaction(trx);
            trxExtBuilder.setTxid(trxCap.getTransactionId().getByteString());
            retBuilder.setResult(true).setCode(GrpcAPI.Return.response_code.SUCCESS);
        }
        catch (ContractValidateException e) {
            retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.CONTRACT_VALIDATE_ERROR).setMessage(ByteString.copyFromUtf8((String)e.getMessage()));
        }
        catch (Exception e) {
            retBuilder.setResult(false).setCode(GrpcAPI.Return.response_code.OTHER_ERROR).setMessage(ByteString.copyFromUtf8((String)(e.getClass() + " : " + e.getMessage())));
        }
        trxExtBuilder.setResult(retBuilder);
        response.getWriter().println(Util.printTransactionExtention(trxExtBuilder.build()));
    }
}

