/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.core.Wallet;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class TransactionSignServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(TransactionSignServlet.class);
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String contract = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            JSONObject input = JSONObject.parseObject((String)contract);
            String strTransaction = input.getJSONObject("transaction").toJSONString();
            Protocol.Transaction transaction = Util.packTransaction(strTransaction);
            JSONObject jsonTransaction = JSONObject.parseObject((String)JsonFormat.printToString((Message)transaction));
            input.put("transaction", (Object)jsonTransaction);
            Protocol.TransactionSign.Builder build = Protocol.TransactionSign.newBuilder();
            JsonFormat.merge(input.toJSONString(), (Message.Builder)build);
            TransactionCapsule reply = this.wallet.getTransactionSign(build.build());
            if (reply != null) {
                response.getWriter().println(Util.printTransaction(reply.getInstance()));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }
}

