/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.text.StringCharacterIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.tron.common.utils.ByteArray;

public class JsonFormat {
    private static final int BUFFER_SIZE = 4096;
    private static final Pattern DIGITS = Pattern.compile("[0-9]", 2);

    public static void print(Message message, Appendable output) throws IOException {
        JsonGenerator generator = new JsonGenerator(output);
        generator.print("{");
        JsonFormat.print(message, generator);
        generator.print("}");
    }

    public static void print(UnknownFieldSet fields, Appendable output) throws IOException {
        JsonGenerator generator = new JsonGenerator(output);
        generator.print("{");
        JsonFormat.printUnknownFields(fields, generator);
        generator.print("}");
    }

    protected static void print(Message message, JsonGenerator generator) throws IOException {
        Iterator iter = message.getAllFields().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry field = iter.next();
            JsonFormat.printField((Descriptors.FieldDescriptor)field.getKey(), field.getValue(), generator);
            if (!iter.hasNext()) continue;
            generator.print(",");
        }
        if (message.getUnknownFields().asMap().size() > 0) {
            generator.print(", ");
        }
        JsonFormat.printUnknownFields(message.getUnknownFields(), generator);
    }

    public static String printToString(Message message) {
        try {
            StringBuilder text = new StringBuilder();
            JsonFormat.print(message, (Appendable)text);
            return text.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Writing to a StringBuilder threw an IOException (should never happen).", e);
        }
    }

    public static String printToString(UnknownFieldSet fields) {
        try {
            StringBuilder text = new StringBuilder();
            JsonFormat.print(fields, (Appendable)text);
            return text.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Writing to a StringBuilder threw an IOException (should never happen).", e);
        }
    }

    public static String printErrorMsg(Exception ex) {
        StringBuilder text = new StringBuilder();
        text.append("{");
        text.append("\"Error\":");
        text.append("\"");
        text.append(ex.getMessage());
        text.append("\"");
        text.append("}");
        return text.toString();
    }

    public static void printField(Descriptors.FieldDescriptor field, Object value, JsonGenerator generator) throws IOException {
        JsonFormat.printSingleField(field, value, generator);
    }

    private static void printSingleField(Descriptors.FieldDescriptor field, Object value, JsonGenerator generator) throws IOException {
        if (field.isExtension()) {
            generator.print("\"");
            if (field.getContainingType().getOptions().getMessageSetWireFormat() && field.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && field.isOptional() && field.getExtensionScope() == field.getMessageType()) {
                generator.print(field.getMessageType().getFullName());
            } else {
                generator.print(field.getFullName());
            }
            generator.print("\"");
        } else {
            generator.print("\"");
            if (field.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                generator.print(field.getMessageType().getName());
            } else {
                generator.print(field.getName());
            }
            generator.print("\"");
        }
        if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            generator.print(": ");
            generator.indent();
        } else {
            generator.print(": ");
        }
        if (field.isRepeated()) {
            generator.print("[");
            Iterator iter = ((List)value).iterator();
            while (iter.hasNext()) {
                JsonFormat.printFieldValue(field, iter.next(), generator);
                if (!iter.hasNext()) continue;
                generator.print(",");
            }
            generator.print("]");
        } else {
            JsonFormat.printFieldValue(field, value, generator);
            if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                generator.outdent();
            }
        }
    }

    private static void printFieldValue(Descriptors.FieldDescriptor field, Object value, JsonGenerator generator) throws IOException {
        switch (field.getType()) {
            case INT32: 
            case INT64: 
            case SINT32: 
            case SINT64: 
            case SFIXED32: 
            case SFIXED64: 
            case FLOAT: 
            case DOUBLE: 
            case BOOL: {
                generator.print(value.toString());
                break;
            }
            case UINT32: 
            case FIXED32: {
                generator.print(JsonFormat.unsignedToString((Integer)value));
                break;
            }
            case UINT64: 
            case FIXED64: {
                generator.print(JsonFormat.unsignedToString((Long)value));
                break;
            }
            case STRING: {
                generator.print("\"");
                generator.print(JsonFormat.escapeText((String)value));
                generator.print("\"");
                break;
            }
            case BYTES: {
                generator.print("\"");
                generator.print(JsonFormat.escapeBytes((ByteString)value));
                generator.print("\"");
                break;
            }
            case ENUM: {
                generator.print("\"");
                generator.print(((Descriptors.EnumValueDescriptor)value).getName());
                generator.print("\"");
                break;
            }
            case MESSAGE: 
            case GROUP: {
                generator.print("{");
                JsonFormat.print((Message)value, generator);
                generator.print("}");
                break;
            }
        }
    }

    protected static void printUnknownFields(UnknownFieldSet unknownFields, JsonGenerator generator) throws IOException {
        boolean firstField = true;
        for (Map.Entry entry : unknownFields.asMap().entrySet()) {
            UnknownFieldSet.Field field = (UnknownFieldSet.Field)entry.getValue();
            if (firstField) {
                firstField = false;
            } else {
                generator.print(", ");
            }
            generator.print("\"");
            generator.print(((Integer)entry.getKey()).toString());
            generator.print("\"");
            generator.print(": [");
            boolean firstValue = true;
            Iterator iterator = field.getVarintList().iterator();
            while (iterator.hasNext()) {
                long value = (Long)iterator.next();
                if (firstValue) {
                    firstValue = false;
                } else {
                    generator.print(", ");
                }
                generator.print(JsonFormat.unsignedToString(value));
            }
            iterator = field.getFixed32List().iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                if (firstValue) {
                    firstValue = false;
                } else {
                    generator.print(", ");
                }
                generator.print(String.format((Locale)null, "0x%08x", value));
            }
            iterator = field.getFixed64List().iterator();
            while (iterator.hasNext()) {
                long value = (Long)iterator.next();
                if (firstValue) {
                    firstValue = false;
                } else {
                    generator.print(", ");
                }
                generator.print(String.format((Locale)null, "0x%016x", value));
            }
            for (ByteString value : field.getLengthDelimitedList()) {
                if (firstValue) {
                    firstValue = false;
                } else {
                    generator.print(", ");
                }
                generator.print("\"");
                generator.print(JsonFormat.escapeBytes(value));
                generator.print("\"");
            }
            for (UnknownFieldSet value : field.getGroupList()) {
                if (firstValue) {
                    firstValue = false;
                } else {
                    generator.print(", ");
                }
                generator.print("{");
                JsonFormat.printUnknownFields(value, generator);
                generator.print("}");
            }
            generator.print("]");
        }
    }

    private static String unsignedToString(int value) {
        if (value >= 0) {
            return Integer.toString(value);
        }
        return Long.toString((long)value & 0xFFFFFFFFL);
    }

    private static String unsignedToString(long value) {
        if (value >= 0L) {
            return Long.toString(value);
        }
        return BigInteger.valueOf(value & Long.MAX_VALUE).setBit(63).toString();
    }

    public static void merge(Readable input, Message.Builder builder) throws IOException {
        JsonFormat.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public static void merge(CharSequence input, Message.Builder builder) throws ParseException {
        JsonFormat.merge(input, ExtensionRegistry.getEmptyRegistry(), builder);
    }

    public static void merge(Readable input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
        JsonFormat.merge(JsonFormat.toStringBuilder(input), extensionRegistry, builder);
    }

    public static void merge(CharSequence input, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        Tokenizer tokenizer = new Tokenizer(input);
        tokenizer.consume("{");
        while (!tokenizer.tryConsume("}")) {
            JsonFormat.mergeField(tokenizer, extensionRegistry, builder);
        }
        if (!tokenizer.atEnd()) {
            throw tokenizer.parseException("Expecting the end of the stream, but there seems to be more data!  Check the input for a valid JSON format.");
        }
    }

    protected static StringBuilder toStringBuilder(Readable input) throws IOException {
        int n;
        StringBuilder text = new StringBuilder();
        CharBuffer buffer = CharBuffer.allocate(4096);
        while ((n = input.read(buffer)) != -1) {
            buffer.flip();
            text.append(buffer, 0, n);
        }
        return text;
    }

    protected static void mergeField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        ExtensionRegistry.ExtensionInfo extension;
        String lowerName;
        Descriptors.Descriptor type = builder.getDescriptorForType();
        boolean unknown = false;
        String name = tokenizer.consumeIdentifier();
        Descriptors.FieldDescriptor field = type.findFieldByName(name);
        if (field == null && (field = type.findFieldByName(lowerName = name.toLowerCase(Locale.US))) != null && field.getType() != Descriptors.FieldDescriptor.Type.GROUP) {
            field = null;
        }
        if (field != null && field.getType() == Descriptors.FieldDescriptor.Type.GROUP && !field.getMessageType().getName().equals(name)) {
            field = null;
        }
        if (field == null && DIGITS.matcher(name).matches()) {
            field = type.findFieldByNumber(Integer.parseInt(name));
            unknown = true;
        }
        if ((extension = extensionRegistry.findExtensionByName(name)) != null) {
            if (extension.descriptor.getContainingType() != type) {
                throw tokenizer.parseExceptionPreviousToken("Extension \"" + name + "\" does not extend message type \"" + type.getFullName() + "\".");
            }
            field = extension.descriptor;
        }
        if (field == null) {
            JsonFormat.handleMissingField(tokenizer, extensionRegistry, builder);
        }
        if (field != null) {
            tokenizer.consume(":");
            boolean array = tokenizer.tryConsume("[");
            if (array) {
                while (!tokenizer.tryConsume("]")) {
                    JsonFormat.handleValue(tokenizer, extensionRegistry, builder, field, extension, unknown);
                    tokenizer.tryConsume(",");
                }
            } else {
                JsonFormat.handleValue(tokenizer, extensionRegistry, builder, field, extension, unknown);
            }
        }
        if (tokenizer.tryConsume(",")) {
            JsonFormat.mergeField(tokenizer, extensionRegistry, builder);
        }
    }

    private static void handleMissingField(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, Message.Builder builder) throws ParseException {
        tokenizer.tryConsume(":");
        if ("{".equals(tokenizer.currentToken())) {
            tokenizer.consume("{");
            do {
                tokenizer.consumeIdentifier();
                JsonFormat.handleMissingField(tokenizer, extensionRegistry, builder);
            } while (tokenizer.tryConsume(","));
            tokenizer.consume("}");
        } else if ("[".equals(tokenizer.currentToken())) {
            tokenizer.consume("[");
            do {
                JsonFormat.handleMissingField(tokenizer, extensionRegistry, builder);
            } while (tokenizer.tryConsume(","));
            tokenizer.consume("]");
        } else if ("null".equals(tokenizer.currentToken())) {
            tokenizer.consume("null");
        } else if (tokenizer.lookingAtInteger()) {
            tokenizer.consumeInt64();
        } else if (tokenizer.lookingAtBoolean()) {
            tokenizer.consumeBoolean();
        } else {
            tokenizer.consumeString();
        }
    }

    private static void handleValue(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, Message.Builder builder, Descriptors.FieldDescriptor field, ExtensionRegistry.ExtensionInfo extension, boolean unknown) throws ParseException {
        Object value = null;
        value = field.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE ? JsonFormat.handleObject(tokenizer, extensionRegistry, builder, field, extension, unknown) : JsonFormat.handlePrimitive(tokenizer, field);
        if (value != null) {
            if (field.isRepeated()) {
                builder.addRepeatedField(field, value);
            } else {
                builder.setField(field, value);
            }
        }
    }

    private static Object handlePrimitive(Tokenizer tokenizer, Descriptors.FieldDescriptor field) throws ParseException {
        Object value = null;
        if ("null".equals(tokenizer.currentToken())) {
            tokenizer.consume("null");
            return value;
        }
        switch (field.getType()) {
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                value = tokenizer.consumeInt32();
                break;
            }
            case INT64: 
            case SINT64: 
            case SFIXED64: {
                value = tokenizer.consumeInt64();
                break;
            }
            case UINT32: 
            case FIXED32: {
                value = tokenizer.consumeUInt32();
                break;
            }
            case UINT64: 
            case FIXED64: {
                value = tokenizer.consumeUInt64();
                break;
            }
            case FLOAT: {
                value = Float.valueOf(tokenizer.consumeFloat());
                break;
            }
            case DOUBLE: {
                value = tokenizer.consumeDouble();
                break;
            }
            case BOOL: {
                value = tokenizer.consumeBoolean();
                break;
            }
            case STRING: {
                value = tokenizer.consumeString();
                break;
            }
            case BYTES: {
                value = tokenizer.consumeByteString();
                break;
            }
            case ENUM: {
                Descriptors.EnumDescriptor enumType = field.getEnumType();
                if (tokenizer.lookingAtInteger()) {
                    int number = tokenizer.consumeInt32();
                    value = enumType.findValueByNumber(number);
                    if (value != null) break;
                    throw tokenizer.parseExceptionPreviousToken("Enum type \"" + enumType.getFullName() + "\" has no value with number " + number + ".");
                }
                String id = tokenizer.consumeIdentifier();
                if (StringUtils.isAllLowerCase((CharSequence)id)) {
                    char b = id.charAt(0);
                    b = (char)(b + 65 - 97);
                    String s = id.substring(1);
                    id = b + s;
                }
                if ((value = enumType.findValueByName(id)) != null) break;
                throw tokenizer.parseExceptionPreviousToken("Enum type \"" + enumType.getFullName() + "\" has no value named \"" + id + "\".");
            }
            case MESSAGE: 
            case GROUP: {
                throw new RuntimeException("Can't get here.");
            }
        }
        return value;
    }

    private static Object handleObject(Tokenizer tokenizer, ExtensionRegistry extensionRegistry, Message.Builder builder, Descriptors.FieldDescriptor field, ExtensionRegistry.ExtensionInfo extension, boolean unknown) throws ParseException {
        Message.Builder subBuilder = extension == null ? builder.newBuilderForField(field) : extension.defaultInstance.newBuilderForType();
        if (unknown) {
            ByteString data = tokenizer.consumeByteString();
            try {
                subBuilder.mergeFrom(data);
                return subBuilder.build();
            }
            catch (InvalidProtocolBufferException e) {
                throw tokenizer.parseException("Failed to build " + field.getFullName() + " from " + data);
            }
        }
        tokenizer.consume("{");
        String endToken = "}";
        while (!tokenizer.tryConsume(endToken)) {
            if (tokenizer.atEnd()) {
                throw tokenizer.parseException("Expected \"" + endToken + "\".");
            }
            JsonFormat.mergeField(tokenizer, extensionRegistry, subBuilder);
            if (!tokenizer.tryConsume(",")) continue;
        }
        return subBuilder.build();
    }

    static String escapeBytes(ByteString input) {
        return ByteArray.toHexString(input.toByteArray());
    }

    static String unicodeEscaped(char ch) {
        if (ch < '\u0010') {
            return "\\u000" + Integer.toHexString(ch);
        }
        if (ch < '\u0100') {
            return "\\u00" + Integer.toHexString(ch);
        }
        if (ch < '\u1000') {
            return "\\u0" + Integer.toHexString(ch);
        }
        return "\\u" + Integer.toHexString(ch);
    }

    static ByteString unescapeBytes(CharSequence input) throws InvalidEscapeSequence {
        try {
            return ByteString.copyFrom((byte[])ByteArray.fromHexString(input.toString()));
        }
        catch (Exception e) {
            throw new InvalidEscapeSequence("invalidate hex String");
        }
    }

    static String escapeText(String input) {
        StringBuilder builder = new StringBuilder(input.length());
        StringCharacterIterator iter = new StringCharacterIterator(input);
        char c = iter.first();
        while (c != '\uffff') {
            switch (c) {
                case '\b': {
                    builder.append("\\b");
                    break;
                }
                case '\f': {
                    builder.append("\\f");
                    break;
                }
                case '\n': {
                    builder.append("\\n");
                    break;
                }
                case '\r': {
                    builder.append("\\r");
                    break;
                }
                case '\t': {
                    builder.append("\\t");
                    break;
                }
                case '\\': {
                    builder.append("\\\\");
                    break;
                }
                case '\"': {
                    builder.append("\\\"");
                    break;
                }
                default: {
                    if (c >= '\u0000' && c <= '\u001f') {
                        JsonFormat.appendEscapedUnicode(builder, c);
                        break;
                    }
                    if (Character.isHighSurrogate(c)) {
                        JsonFormat.appendEscapedUnicode(builder, c);
                        c = iter.next();
                        if (c == '\uffff') {
                            throw new IllegalArgumentException("invalid unicode string: unexpected high surrogate pair value without corresponding low value.");
                        }
                        JsonFormat.appendEscapedUnicode(builder, c);
                        break;
                    }
                    builder.append(c);
                }
            }
            c = iter.next();
        }
        return builder.toString();
    }

    static void appendEscapedUnicode(StringBuilder builder, char ch) {
        String prefix = "\\u";
        if (ch < '\u0010') {
            prefix = "\\u000";
        } else if (ch < '\u0100') {
            prefix = "\\u00";
        } else if (ch < '\u1000') {
            prefix = "\\u0";
        }
        builder.append(prefix).append(Integer.toHexString(ch));
    }

    static String unescapeText(String input) throws InvalidEscapeSequence {
        StringBuilder builder = new StringBuilder();
        char[] array = input.toCharArray();
        block11: for (int i = 0; i < array.length; ++i) {
            char c = array[i];
            if (c == '\\') {
                if (i + 1 < array.length) {
                    c = array[++i];
                    switch (c) {
                        case 'b': {
                            builder.append('\b');
                            continue block11;
                        }
                        case 'f': {
                            builder.append('\f');
                            continue block11;
                        }
                        case 'n': {
                            builder.append('\n');
                            continue block11;
                        }
                        case 'r': {
                            builder.append('\r');
                            continue block11;
                        }
                        case 't': {
                            builder.append('\t');
                            continue block11;
                        }
                        case '\\': {
                            builder.append('\\');
                            continue block11;
                        }
                        case '\"': {
                            builder.append('\"');
                            continue block11;
                        }
                        case '\'': {
                            builder.append('\'');
                            continue block11;
                        }
                        case 'u': {
                            if (i + 4 < array.length) {
                                int code2 = Integer.parseInt(new String(array, ++i, 4), 16);
                                builder.append((char)code2);
                                i += 3;
                                continue block11;
                            }
                            throw new InvalidEscapeSequence("Invalid escape sequence: '\\u' at end of string.");
                        }
                        default: {
                            throw new InvalidEscapeSequence("Invalid escape sequence: '\\" + c + "'");
                        }
                    }
                }
                throw new InvalidEscapeSequence("Invalid escape sequence: '\\' at end of string.");
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static boolean isOctal(char c) {
        return '0' <= c && c <= '7';
    }

    private static boolean isHex(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    private static int digitValue(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'z') {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }

    static int parseInt32(String text) throws NumberFormatException {
        return (int)JsonFormat.parseInteger(text, true, false);
    }

    static int parseUInt32(String text) throws NumberFormatException {
        return (int)JsonFormat.parseInteger(text, false, false);
    }

    static long parseInt64(String text) throws NumberFormatException {
        return JsonFormat.parseInteger(text, true, true);
    }

    static long parseUInt64(String text) throws NumberFormatException {
        return JsonFormat.parseInteger(text, false, true);
    }

    private static long parseInteger(String text, boolean isSigned, boolean isLong) throws NumberFormatException {
        int pos = 0;
        boolean negative = false;
        if (text.startsWith("-", pos)) {
            if (!isSigned) {
                throw new NumberFormatException("Number must be positive: " + text);
            }
            ++pos;
            negative = true;
        }
        int radix = 10;
        if (text.startsWith("0x", pos)) {
            pos += 2;
            radix = 16;
        } else if (text.startsWith("0", pos)) {
            radix = 8;
        }
        String numberText = text.substring(pos);
        long result = 0L;
        if (numberText.length() < 16) {
            result = Long.parseLong(numberText, radix);
            if (negative) {
                result = -result;
            }
            if (!isLong) {
                if (isSigned) {
                    if (result > Integer.MAX_VALUE || result < Integer.MIN_VALUE) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (result >= 0x100000000L || result < 0L) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            }
        } else {
            BigInteger bigValue = new BigInteger(numberText, radix);
            if (negative) {
                bigValue = bigValue.negate();
            }
            if (!isLong) {
                if (isSigned) {
                    if (bigValue.bitLength() > 31) {
                        throw new NumberFormatException("Number out of range for 32-bit signed integer: " + text);
                    }
                } else if (bigValue.bitLength() > 32) {
                    throw new NumberFormatException("Number out of range for 32-bit unsigned integer: " + text);
                }
            } else if (isSigned) {
                if (bigValue.bitLength() > 63) {
                    throw new NumberFormatException("Number out of range for 64-bit signed integer: " + text);
                }
            } else if (bigValue.bitLength() > 64) {
                throw new NumberFormatException("Number out of range for 64-bit unsigned integer: " + text);
            }
            result = bigValue.longValueExact();
        }
        return result;
    }

    static class InvalidEscapeSequence
    extends IOException {
        private static final long serialVersionUID = 1L;

        public InvalidEscapeSequence(String description) {
            super(description);
        }
    }

    public static class ParseException
    extends IOException {
        private static final long serialVersionUID = 1L;

        public ParseException(String message) {
            super(message);
        }
    }

    protected static class Tokenizer {
        private static final Pattern WHITESPACE = Pattern.compile("(\\s|(#.*$))++", 8);
        private static final Pattern TOKEN = Pattern.compile("[a-zA-Z_][0-9a-zA-Z_+-]*+|[.]?[0-9+-][0-9a-zA-Z_.+-]*+|\"([^\"\n\\\\]|\\\\.)*+(\"|\\\\?$)|'([^'\n\\\\]|\\\\.)*+('|\\\\?$)", 8);
        private static final Pattern DOUBLE_INFINITY = Pattern.compile("-?inf(inity)?", 2);
        private static final Pattern FLOAT_INFINITY = Pattern.compile("-?inf(inity)?f?", 2);
        private static final Pattern FLOAT_NAN = Pattern.compile("nanf?", 2);
        private final CharSequence text;
        private final Matcher matcher;
        private String currentToken;
        private int pos = 0;
        private int line = 0;
        private int column = 0;
        private int previousLine = 0;
        private int previousColumn = 0;

        public Tokenizer(CharSequence text) {
            this.text = text;
            this.matcher = WHITESPACE.matcher(text);
            this.skipWhitespace();
            this.nextToken();
        }

        public boolean atEnd() {
            return this.currentToken.length() == 0;
        }

        public void nextToken() {
            this.previousLine = this.line;
            this.previousColumn = this.column;
            while (this.pos < this.matcher.regionStart()) {
                if (this.text.charAt(this.pos) == '\n') {
                    ++this.line;
                    this.column = 0;
                } else {
                    ++this.column;
                }
                ++this.pos;
            }
            if (this.matcher.regionStart() == this.matcher.regionEnd()) {
                this.currentToken = "";
            } else {
                this.matcher.usePattern(TOKEN);
                if (this.matcher.lookingAt()) {
                    this.currentToken = this.matcher.group();
                    this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
                } else {
                    this.currentToken = String.valueOf(this.text.charAt(this.pos));
                    this.matcher.region(this.pos + 1, this.matcher.regionEnd());
                }
                this.skipWhitespace();
            }
        }

        private void skipWhitespace() {
            this.matcher.usePattern(WHITESPACE);
            if (this.matcher.lookingAt()) {
                this.matcher.region(this.matcher.end(), this.matcher.regionEnd());
            }
        }

        public boolean tryConsume(String token) {
            if (this.currentToken.equals(token)) {
                this.nextToken();
                return true;
            }
            return false;
        }

        public void consume(String token) throws ParseException {
            if (!this.tryConsume(token)) {
                throw this.parseException("Expected \"" + token + "\".");
            }
        }

        public boolean lookingAtInteger() {
            if (this.currentToken.length() == 0) {
                return false;
            }
            char c = this.currentToken.charAt(0);
            return '0' <= c && c <= '9' || c == '-' || c == '+';
        }

        public boolean lookingAtBoolean() {
            if (this.currentToken.length() == 0) {
                return false;
            }
            return "true".equals(this.currentToken) || "false".equals(this.currentToken);
        }

        static ByteString unescapeBytes(CharSequence input) throws InvalidEscapeSequence {
            try {
                return ByteString.copyFrom((byte[])ByteArray.fromHexString(input.toString()));
            }
            catch (Exception e) {
                throw new InvalidEscapeSequence("INVALID hex String");
            }
        }

        public String currentToken() {
            return this.currentToken;
        }

        public String consumeIdentifier() throws ParseException {
            for (int i = 0; i < this.currentToken.length(); ++i) {
                char c = this.currentToken.charAt(i);
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_' || c == '.' || c == '\"') continue;
                throw this.parseException("Expected identifier. -" + c);
            }
            String result = this.currentToken;
            result = result.replaceAll("\"|'", "");
            this.nextToken();
            return result;
        }

        public int consumeInt32() throws ParseException {
            try {
                int result = JsonFormat.parseInt32(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public int consumeUInt32() throws ParseException {
            try {
                int result = JsonFormat.parseUInt32(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public long consumeInt64() throws ParseException {
            try {
                long result = JsonFormat.parseInt64(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public long consumeUInt64() throws ParseException {
            try {
                long result = JsonFormat.parseUInt64(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.integerParseException(e);
            }
        }

        public double consumeDouble() throws ParseException {
            if (DOUBLE_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (this.currentToken.equalsIgnoreCase("nan")) {
                this.nextToken();
                return Double.NaN;
            }
            try {
                double result = Double.parseDouble(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.floatParseException(e);
            }
        }

        public float consumeFloat() throws ParseException {
            if (FLOAT_INFINITY.matcher(this.currentToken).matches()) {
                boolean negative = this.currentToken.startsWith("-");
                this.nextToken();
                return negative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
            if (FLOAT_NAN.matcher(this.currentToken).matches()) {
                this.nextToken();
                return Float.NaN;
            }
            try {
                float result = Float.parseFloat(this.currentToken);
                this.nextToken();
                return result;
            }
            catch (NumberFormatException e) {
                throw this.floatParseException(e);
            }
        }

        public boolean consumeBoolean() throws ParseException {
            if (this.currentToken.equals("true")) {
                this.nextToken();
                return true;
            }
            if (this.currentToken.equals("false")) {
                this.nextToken();
                return false;
            }
            throw this.parseException("Expected \"true\" or \"false\".");
        }

        public String consumeString() throws ParseException {
            char quote;
            char c = quote = this.currentToken.length() > 0 ? this.currentToken.charAt(0) : (char)'\u0000';
            if (quote != '\"' && quote != '\'') {
                throw this.parseException("Expected string.");
            }
            if (this.currentToken.length() < 2 || this.currentToken.charAt(this.currentToken.length() - 1) != quote) {
                throw this.parseException("String missing ending quote.");
            }
            try {
                String escaped = this.currentToken.substring(1, this.currentToken.length() - 1);
                String result = JsonFormat.unescapeText(escaped);
                this.nextToken();
                return result;
            }
            catch (InvalidEscapeSequence e) {
                throw this.parseException(e.getMessage());
            }
        }

        public ByteString consumeByteString() throws ParseException {
            char quote;
            char c = quote = this.currentToken.length() > 0 ? this.currentToken.charAt(0) : (char)'\u0000';
            if (quote != '\"' && quote != '\'') {
                throw this.parseException("Expected string.");
            }
            if (this.currentToken.length() < 2 || this.currentToken.charAt(this.currentToken.length() - 1) != quote) {
                throw this.parseException("String missing ending quote.");
            }
            try {
                String escaped = this.currentToken.substring(1, this.currentToken.length() - 1);
                ByteString result = Tokenizer.unescapeBytes(escaped);
                this.nextToken();
                return result;
            }
            catch (InvalidEscapeSequence e) {
                throw this.parseException(e.getMessage());
            }
        }

        public ParseException parseException(String description) {
            return new ParseException(this.line + 1 + ":" + (this.column + 1) + ": " + description);
        }

        public ParseException parseExceptionPreviousToken(String description) {
            return new ParseException(this.previousLine + 1 + ":" + (this.previousColumn + 1) + ": " + description);
        }

        private ParseException integerParseException(NumberFormatException e) {
            return this.parseException("Couldn't parse integer: " + e.getMessage());
        }

        private ParseException floatParseException(NumberFormatException e) {
            return this.parseException("Couldn't parse number: " + e.getMessage());
        }
    }

    protected static class JsonGenerator {
        private Appendable output;
        private boolean atStartOfLine = true;
        private StringBuilder indent = new StringBuilder();

        public JsonGenerator(Appendable output) {
            this.output = output;
        }

        public void indent() {
            this.indent.append("  ");
        }

        public void outdent() {
            int length = this.indent.length();
            if (length == 0) {
                throw new IllegalArgumentException(" Outdent() without matching Indent().");
            }
            this.indent.delete(length - 2, length);
        }

        public void print(CharSequence text) throws IOException {
            int size = text.length();
            int pos = 0;
            for (int i = 0; i < size; ++i) {
                if (text.charAt(i) != '\n') continue;
                this.write(text.subSequence(pos, size), i - pos + 1);
                pos = i + 1;
                this.atStartOfLine = true;
            }
            this.write(text.subSequence(pos, size), size - pos);
        }

        private void write(CharSequence data, int size) throws IOException {
            if (size == 0) {
                return;
            }
            if (this.atStartOfLine) {
                this.atStartOfLine = false;
                this.output.append(this.indent);
            }
            this.output.append(data);
        }
    }
}

