/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class GetContractServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(GetContractServlet.class);
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String input = request.getParameter("value");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("value", (Object)input);
            GrpcAPI.BytesMessage.Builder build = GrpcAPI.BytesMessage.newBuilder();
            JsonFormat.merge(jsonObject.toJSONString(), (Message.Builder)build);
            Protocol.SmartContract smartContract = this.wallet.getContract(build.build());
            JSONObject jsonSmartContract = JSONObject.parseObject((String)JsonFormat.printToString((Message)smartContract));
            response.getWriter().println(jsonSmartContract.toJSONString());
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String input = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            GrpcAPI.BytesMessage.Builder build = GrpcAPI.BytesMessage.newBuilder();
            JsonFormat.merge(input, (Message.Builder)build);
            Protocol.SmartContract smartContract = this.wallet.getContract(build.build());
            JSONObject jsonSmartContract = JSONObject.parseObject((String)JsonFormat.printToString((Message)smartContract));
            response.getWriter().println(jsonSmartContract.toJSONString());
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }
}

