/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.db.Manager;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.Util;

@Component
public class GetAccountResourceServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(GetAccountResourceServlet.class);
    @Autowired
    private Wallet wallet;
    @Autowired
    private Manager dbManager;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String address = request.getParameter("address");
            GrpcAPI.AccountResourceMessage reply = this.wallet.getAccountResource(ByteString.copyFrom((byte[])ByteArray.fromHexString(address)));
            if (reply != null) {
                response.getWriter().println(JsonFormat.printToString((Message)reply));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String input = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            JSONObject jsonObject = JSONObject.parseObject((String)input);
            String address = jsonObject.getString("address");
            GrpcAPI.AccountResourceMessage reply = this.wallet.getAccountResource(ByteString.copyFrom((byte[])ByteArray.fromHexString(address)));
            if (reply != null) {
                response.getWriter().println(JsonFormat.printToString((Message)reply));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }
}

