/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.Util;
import org.tron.protos.Protocol;

@Component
public class GetAccountByIdServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(GetAccountByIdServlet.class);
    @Autowired
    private Wallet wallet;

    private String convertOutput(Protocol.Account account) {
        if (account.getAssetIssuedID().isEmpty()) {
            return JsonFormat.printToString((Message)account);
        }
        JSONObject accountJson = JSONObject.parseObject((String)JsonFormat.printToString((Message)account));
        String assetId = accountJson.get((Object)"asset_issued_ID").toString();
        accountJson.put("asset_issued_ID", (Object)ByteString.copyFrom((byte[])ByteArray.fromHexString(assetId)).toStringUtf8());
        return accountJson.toJSONString();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String accountId = request.getParameter("accountId");
            Protocol.Account.Builder build = Protocol.Account.newBuilder();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("accountId", (Object)accountId);
            JsonFormat.merge(jsonObject.toJSONString(), (Message.Builder)build);
            Protocol.Account reply = this.wallet.getAccountById(build.build());
            if (reply != null) {
                response.getWriter().println(this.convertOutput(reply));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String account = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            Protocol.Account.Builder build = Protocol.Account.newBuilder();
            JsonFormat.merge(account, (Message.Builder)build);
            Protocol.Account reply = this.wallet.getAccountById(build.build());
            if (reply != null) {
                response.getWriter().println(this.convertOutput(reply));
            } else {
                response.getWriter().println("{}");
            }
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }
}

