/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.tron.common.crypto.ECKey;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Utils;
import org.tron.core.Wallet;
import org.tron.core.services.http.Util;

@Component
public class GenerateAddressServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(GenerateAddressServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            ECKey ecKey = new ECKey(Utils.getRandom());
            byte[] priKey = ecKey.getPrivKeyBytes();
            byte[] address = ecKey.getAddress();
            String priKeyStr = Hex.encodeHexString((byte[])priKey);
            String base58check = Wallet.encode58Check(address);
            String hexString = ByteArray.toHexString(address);
            JSONObject jsonAddress = new JSONObject();
            jsonAddress.put("address", (Object)base58check);
            jsonAddress.put("hexAddress", (Object)hexString);
            jsonAddress.put("privateKey", (Object)priKeyStr);
            response.getWriter().println(jsonAddress.toJSONString());
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doGet(request, response);
    }
}

