/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services.http;

import com.alibaba.fastjson.JSONObject;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.tron.api.GrpcAPI;
import org.tron.common.utils.ByteArray;
import org.tron.core.Wallet;
import org.tron.core.services.http.JsonFormat;
import org.tron.core.services.http.Util;

@Component
public class CreateAddressServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(CreateAddressServlet.class);
    @Autowired
    private Wallet wallet;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String input = request.getParameter("value");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("value", (Object)input);
            GrpcAPI.BytesMessage.Builder build = GrpcAPI.BytesMessage.newBuilder();
            JsonFormat.merge(jsonObject.toJSONString(), (Message.Builder)build);
            byte[] address = this.wallet.createAdresss(build.getValue().toByteArray());
            String base58check = Wallet.encode58Check(address);
            String hexString = ByteArray.toHexString(address);
            JSONObject jsonAddress = new JSONObject();
            jsonAddress.put("base58checkAddress", (Object)base58check);
            jsonAddress.put("value", (Object)hexString);
            response.getWriter().println(jsonAddress.toJSONString());
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            String input = request.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            GrpcAPI.BytesMessage.Builder build = GrpcAPI.BytesMessage.newBuilder();
            JsonFormat.merge(input, (Message.Builder)build);
            byte[] address = this.wallet.createAdresss(build.getValue().toByteArray());
            String base58check = Wallet.encode58Check(address);
            String hexString = ByteArray.toHexString(address);
            JSONObject jsonAddress = new JSONObject();
            jsonAddress.put("base58checkAddress", (Object)base58check);
            jsonAddress.put("value", (Object)hexString);
            response.getWriter().println(jsonAddress.toJSONString());
        }
        catch (Exception e) {
            logger.debug("Exception: {}", (Object)e.getMessage());
            try {
                response.getWriter().println(Util.printErrorMsg(e));
            }
            catch (IOException ioe) {
                logger.debug("IOException: {}", (Object)ioe.getMessage());
            }
        }
    }
}

