/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.services;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.BlockCapsule;

@Service
public class WitnessProductBlockService {
    private static final Logger logger = LoggerFactory.getLogger(WitnessProductBlockService.class);
    private Cache<Long, BlockCapsule> historyBlockCapsuleCache = CacheBuilder.newBuilder().initialCapacity(200).maximumSize(200L).build();
    private Map<String, CheatWitnessInfo> cheatWitnessInfoMap = new HashMap<String, CheatWitnessInfo>();

    public void validWitnessProductTwoBlock(BlockCapsule block) {
        try {
            BlockCapsule blockCapsule = (BlockCapsule)this.historyBlockCapsuleCache.getIfPresent((Object)block.getNum());
            if (blockCapsule != null && Arrays.equals(blockCapsule.getWitnessAddress().toByteArray(), block.getWitnessAddress().toByteArray()) && !Arrays.equals(block.getBlockId().getBytes(), blockCapsule.getBlockId().getBytes())) {
                String key = ByteArray.toHexString(block.getWitnessAddress().toByteArray());
                if (!this.cheatWitnessInfoMap.containsKey(key)) {
                    CheatWitnessInfo cheatWitnessInfo = new CheatWitnessInfo();
                    this.cheatWitnessInfoMap.put(key, cheatWitnessInfo);
                }
                this.cheatWitnessInfoMap.get(key).clear().setTime(System.currentTimeMillis()).setLatestBlockNum(block.getNum()).add(block).add(blockCapsule).increment();
            } else {
                this.historyBlockCapsuleCache.put((Object)block.getNum(), (Object)block);
            }
        }
        catch (Exception e) {
            logger.error("valid witness same time product two block fail! blockNum: {}, blockHash: {}", new Object[]{block.getNum(), block.getBlockId().toString(), e});
        }
    }

    public Map<String, CheatWitnessInfo> queryCheatWitnessInfo() {
        return this.cheatWitnessInfoMap;
    }

    public static class CheatWitnessInfo {
        private AtomicInteger times = new AtomicInteger(0);
        private long latestBlockNum;
        private Set<BlockCapsule> blockCapsuleSet = new HashSet<BlockCapsule>();
        private long time;

        public CheatWitnessInfo increment() {
            this.times.incrementAndGet();
            return this;
        }

        public AtomicInteger getTimes() {
            return this.times;
        }

        public CheatWitnessInfo setTimes(AtomicInteger times) {
            this.times = times;
            return this;
        }

        public long getLatestBlockNum() {
            return this.latestBlockNum;
        }

        public CheatWitnessInfo setLatestBlockNum(long latestBlockNum) {
            this.latestBlockNum = latestBlockNum;
            return this;
        }

        public Set<BlockCapsule> getBlockCapsuleSet() {
            return new HashSet<BlockCapsule>(this.blockCapsuleSet);
        }

        public CheatWitnessInfo clear() {
            this.blockCapsuleSet.clear();
            return this;
        }

        public CheatWitnessInfo add(BlockCapsule blockCapsule) {
            this.blockCapsuleSet.add(blockCapsule);
            return this;
        }

        public CheatWitnessInfo setBlockCapsuleSet(Set<BlockCapsule> blockCapsuleSet) {
            this.blockCapsuleSet = new HashSet<BlockCapsule>(blockCapsuleSet);
            return this;
        }

        public long getTime() {
            return this.time;
        }

        public CheatWitnessInfo setTime(long time) {
            this.time = time;
            return this;
        }

        public String toString() {
            return "{times=" + this.times.get() + ", time=" + this.time + ", latestBlockNum=" + this.latestBlockNum + ", blockCapsuleSet=" + this.blockCapsuleSet + '}';
        }
    }
}

