/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.peer;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.tron.common.overlay.server.Channel;
import org.tron.common.overlay.server.MessageQueue;
import org.tron.core.net.message.TronMessage;
import org.tron.core.net.peer.PeerConnection;
import org.tron.core.net.peer.PeerConnectionDelegate;

@Component
@Scope(value="prototype")
public class TronHandler
extends SimpleChannelInboundHandler<TronMessage> {
    protected PeerConnection peer;
    private MessageQueue msgQueue = null;
    public PeerConnectionDelegate peerDel;

    public void setPeerDel(PeerConnectionDelegate peerDel) {
        this.peerDel = peerDel;
    }

    public void channelRead0(ChannelHandlerContext ctx, TronMessage msg) throws Exception {
        this.msgQueue.receivedMessage(msg);
        this.peerDel.onMessage(this.peer, msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.peer.processException(cause);
    }

    public void setMsgQueue(MessageQueue msgQueue) {
        this.msgQueue = msgQueue;
    }

    public void setChannel(Channel channel) {
        this.peer = (PeerConnection)channel;
    }
}

