/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.node;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.tron.core.config.args.Args;
import org.tron.core.net.message.TransactionMessage;
import org.tron.core.net.message.TransactionsMessage;
import org.tron.core.net.node.Item;
import org.tron.core.net.node.NodeImpl;
import org.tron.core.net.peer.PeerConnection;
import org.tron.protos.Protocol;

@Component
public class TrxHandler {
    private static final Logger logger = LoggerFactory.getLogger(TrxHandler.class);
    private NodeImpl nodeImpl;
    private static int MAX_TRX_SIZE = 50000;
    private static int MAX_SMART_CONTRACT_SUBMIT_SIZE = 100;
    private static int TIME_OUT = 600000;
    private BlockingQueue<TrxEvent> smartContractQueue = new LinkedBlockingQueue<TrxEvent>(MAX_TRX_SIZE);
    private BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private int threadNum = Args.getInstance().getValidateSignThreadNum();
    private ExecutorService trxHandlePool = new ThreadPoolExecutor(this.threadNum, this.threadNum, 0L, TimeUnit.MILLISECONDS, this.queue);
    private ScheduledExecutorService smartContractExecutor = Executors.newSingleThreadScheduledExecutor();

    public void init(NodeImpl nodeImpl) {
        this.nodeImpl = nodeImpl;
        this.handleSmartContract();
    }

    private void handleSmartContract() {
        this.smartContractExecutor.scheduleWithFixedDelay(() -> {
            try {
                while (this.queue.size() < MAX_SMART_CONTRACT_SUBMIT_SIZE) {
                    TrxEvent event = this.smartContractQueue.take();
                    if (System.currentTimeMillis() - event.getTime() > (long)TIME_OUT) {
                        logger.warn("Drop smart contract {} from peer {}.");
                        continue;
                    }
                    this.trxHandlePool.submit(() -> this.nodeImpl.onHandleTransactionMessage(event.getPeer(), event.getMsg()));
                }
            }
            catch (Exception e) {
                logger.error("Handle smart contract exception", (Throwable)e);
            }
        }, 1000L, 20L, TimeUnit.MILLISECONDS);
    }

    public void handleTransactionsMessage(PeerConnection peer, TransactionsMessage msg) {
        for (Protocol.Transaction trx : msg.getTransactions().getTransactionsList()) {
            Item item = new Item(new TransactionMessage(trx).getMessageId(), Protocol.Inventory.InventoryType.TRX);
            if (!peer.getAdvObjWeRequested().containsKey(item)) {
                logger.warn("Receive trx {} from peer {} without fetch request.", (Object)msg.getMessageId(), (Object)peer.getInetAddress());
                peer.setSyncFlag(false);
                peer.disconnect(Protocol.ReasonCode.BAD_PROTOCOL);
                return;
            }
            peer.getAdvObjWeRequested().remove(item);
            int type = trx.getRawData().getContract(0).getType().getNumber();
            if (type == 31 || type == 30) {
                if (this.smartContractQueue.offer(new TrxEvent(peer, new TransactionMessage(trx)))) continue;
                logger.warn("Add smart contract failed, smartContractQueue size {} queueSize {}", (Object)this.smartContractQueue.size(), (Object)this.queue.size());
                continue;
            }
            this.trxHandlePool.submit(() -> this.nodeImpl.onHandleTransactionMessage(peer, new TransactionMessage(trx)));
        }
    }

    public boolean isBusy() {
        return this.queue.size() + this.smartContractQueue.size() > MAX_TRX_SIZE;
    }

    class TrxEvent {
        private PeerConnection peer;
        private TransactionMessage msg;
        private long time;

        public TrxEvent(PeerConnection peer, TransactionMessage msg) {
            this.peer = peer;
            this.msg = msg;
            this.time = System.currentTimeMillis();
        }

        public PeerConnection getPeer() {
            return this.peer;
        }

        public TransactionMessage getMsg() {
            return this.msg;
        }

        public long getTime() {
            return this.time;
        }
    }
}

