/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.node;

import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.common.overlay.message.Message;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.Manager;
import org.tron.core.exception.AccountResourceInsufficientException;
import org.tron.core.exception.BadBlockException;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.BadNumberBlockException;
import org.tron.core.exception.BadTransactionException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractSizeNotEqualToOneException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.DupTransactionException;
import org.tron.core.exception.ItemNotFoundException;
import org.tron.core.exception.NonCommonBlockException;
import org.tron.core.exception.ReceiptCheckErrException;
import org.tron.core.exception.StoreException;
import org.tron.core.exception.TaposException;
import org.tron.core.exception.TooBigTransactionException;
import org.tron.core.exception.TooBigTransactionResultException;
import org.tron.core.exception.TransactionExpirationException;
import org.tron.core.exception.TronException;
import org.tron.core.exception.UnLinkedBlockException;
import org.tron.core.exception.VMIllegalException;
import org.tron.core.exception.ValidateScheduleException;
import org.tron.core.exception.ValidateSignatureException;
import org.tron.core.net.message.BlockMessage;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.TransactionMessage;
import org.tron.core.net.node.NodeDelegate;

public class NodeDelegateImpl
implements NodeDelegate {
    private static final Logger logger = LoggerFactory.getLogger(NodeDelegateImpl.class);
    private Manager dbManager;

    public NodeDelegateImpl(Manager dbManager) {
        this.dbManager = dbManager;
    }

    @Override
    public synchronized LinkedList<Sha256Hash> handleBlock(BlockCapsule block, boolean syncMode) throws BadBlockException, UnLinkedBlockException, InterruptedException, NonCommonBlockException {
        if (block.getInstance().getSerializedSize() > 2000100) {
            throw new BadBlockException("block size over limit");
        }
        long gap = block.getTimeStamp() - System.currentTimeMillis();
        if (gap >= 3000L) {
            throw new BadBlockException("block time error");
        }
        try {
            this.dbManager.preValidateTransactionSign(block);
            this.dbManager.pushBlock(block);
            if (!syncMode) {
                List<TransactionCapsule> trx = null;
                trx = block.getTransactions();
                return trx.stream().map(TransactionCapsule::getTransactionId).collect(Collectors.toCollection(LinkedList::new));
            }
            return null;
        }
        catch (AccountResourceInsufficientException e) {
            throw new BadBlockException("AccountResourceInsufficientException," + e.getMessage());
        }
        catch (ValidateScheduleException e) {
            throw new BadBlockException("validate schedule exception," + e.getMessage());
        }
        catch (ValidateSignatureException e) {
            throw new BadBlockException("validate signature exception," + e.getMessage());
        }
        catch (ContractValidateException e) {
            throw new BadBlockException("ContractValidate exception," + e.getMessage());
        }
        catch (ContractExeException e) {
            throw new BadBlockException("Contract Execute exception," + e.getMessage());
        }
        catch (TaposException e) {
            throw new BadBlockException("tapos exception," + e.getMessage());
        }
        catch (DupTransactionException e) {
            throw new BadBlockException("DupTransaction exception," + e.getMessage());
        }
        catch (TooBigTransactionException e) {
            throw new BadBlockException("TooBigTransaction exception," + e.getMessage());
        }
        catch (TooBigTransactionResultException e) {
            throw new BadBlockException("TooBigTransaction exception," + e.getMessage());
        }
        catch (TransactionExpirationException e) {
            throw new BadBlockException("Expiration exception," + e.getMessage());
        }
        catch (BadNumberBlockException e) {
            throw new BadBlockException("bad number exception," + e.getMessage());
        }
        catch (ReceiptCheckErrException e) {
            throw new BadBlockException("TransactionTrace Exception," + e.getMessage());
        }
        catch (VMIllegalException e) {
            throw new BadBlockException(e.getMessage());
        }
    }

    @Override
    public boolean handleTransaction(TransactionCapsule trx) throws BadTransactionException {
        if (this.dbManager.getDynamicPropertiesStore().supportVM()) {
            trx.resetResult();
        }
        logger.debug("handle transaction");
        if (this.dbManager.getTransactionIdCache().getIfPresent((Object)trx.getTransactionId()) != null) {
            logger.warn("This transaction has been processed");
            return false;
        }
        this.dbManager.getTransactionIdCache().put((Object)trx.getTransactionId(), (Object)true);
        try {
            this.dbManager.pushTransaction(trx);
        }
        catch (ContractSizeNotEqualToOneException | VMIllegalException | ValidateSignatureException e) {
            throw new BadTransactionException(e.getMessage());
        }
        catch (AccountResourceInsufficientException | ContractExeException | ContractValidateException | DupTransactionException | ReceiptCheckErrException | TaposException | TooBigTransactionException | TooBigTransactionResultException | TransactionExpirationException e) {
            logger.warn("Handle transaction {} failed, reason: {}", (Object)trx.getTransactionId(), (Object)e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public LinkedList<BlockCapsule.BlockId> getLostBlockIds(List<BlockCapsule.BlockId> blockChainSummary) throws StoreException {
        BlockCapsule.BlockId unForkedBlockId;
        if (this.dbManager.getHeadBlockNum() == 0L) {
            return new LinkedList<BlockCapsule.BlockId>();
        }
        if (blockChainSummary.isEmpty() || blockChainSummary.size() == 1 && blockChainSummary.get(0).equals(this.dbManager.getGenesisBlockId())) {
            unForkedBlockId = this.dbManager.getGenesisBlockId();
        } else {
            if (blockChainSummary.size() == 1 && blockChainSummary.get(0).getNum() == 0L) {
                return new LinkedList<BlockCapsule.BlockId>(Arrays.asList(this.dbManager.getGenesisBlockId()));
            }
            Collections.reverse(blockChainSummary);
            unForkedBlockId = blockChainSummary.stream().filter(blockId -> this.containBlockInMainChain((BlockCapsule.BlockId)blockId)).findFirst().orElse(null);
            if (unForkedBlockId == null) {
                return new LinkedList<BlockCapsule.BlockId>();
            }
        }
        long unForkedBlockIdNum = unForkedBlockId.getNum();
        long len = Longs.min((long[])new long[]{this.dbManager.getHeadBlockNum(), unForkedBlockIdNum + 2000L});
        LinkedList<BlockCapsule.BlockId> blockIds = new LinkedList<BlockCapsule.BlockId>();
        for (long i = unForkedBlockIdNum; i <= len; ++i) {
            BlockCapsule.BlockId id = this.dbManager.getBlockIdByNum(i);
            blockIds.add(id);
        }
        return blockIds;
    }

    @Override
    public Deque<BlockCapsule.BlockId> getBlockChainSummary(BlockCapsule.BlockId beginBlockId, Deque<BlockCapsule.BlockId> blockIdsToFetch) throws TronException {
        long highNoForkBlkNum;
        long highBlkNum;
        LinkedList<BlockCapsule.BlockId> retSummary = new LinkedList<BlockCapsule.BlockId>();
        ArrayList<BlockCapsule.BlockId> blockIds = new ArrayList<BlockCapsule.BlockId>(blockIdsToFetch);
        long syncBeginNumber = this.dbManager.getSyncBeginNumber();
        long lowBlkNum = syncBeginNumber < 0L ? 0L : syncBeginNumber;
        LinkedList<Object> forkList = new LinkedList();
        if (!beginBlockId.equals(this.getGenesisBlock().getBlockId())) {
            if (this.containBlockInMainChain(beginBlockId)) {
                highBlkNum = beginBlockId.getNum();
                if (highBlkNum == 0L) {
                    throw new TronException("This block don't equal my genesis block hash, but it is in my DB, the block id is :" + beginBlockId.getString());
                }
                highNoForkBlkNum = highBlkNum;
                if (beginBlockId.getNum() < lowBlkNum) {
                    lowBlkNum = beginBlockId.getNum();
                }
            } else {
                forkList = this.dbManager.getBlockChainHashesOnFork(beginBlockId);
                if (forkList.isEmpty()) {
                    throw new UnLinkedBlockException("We want to find forkList of this block: " + beginBlockId.getString() + " ,but in KhasoDB we can not find it, It maybe a very old beginBlockId, we are sync once, we switch and pop it after that time. ");
                }
                highNoForkBlkNum = ((BlockCapsule.BlockId)forkList.peekLast()).getNum();
                forkList.pollLast();
                Collections.reverse(forkList);
                highBlkNum = highNoForkBlkNum + (long)forkList.size();
                if (highNoForkBlkNum < lowBlkNum) {
                    throw new UnLinkedBlockException("It is a too old block that we take it as a forked block long long ago\n lowBlkNum:" + lowBlkNum + "\n highNoForkBlkNum" + highNoForkBlkNum);
                }
            }
        } else {
            highNoForkBlkNum = highBlkNum = this.dbManager.getHeadBlockNum();
        }
        if (!blockIds.isEmpty() && highBlkNum != ((BlockCapsule.BlockId)blockIds.get(0)).getNum() - 1L) {
            logger.error("Check ERROR: highBlkNum:" + highBlkNum + ",blockIdToSyncFirstNum is " + ((BlockCapsule.BlockId)blockIds.get(0)).getNum() + ",blockIdToSyncEnd is " + ((BlockCapsule.BlockId)blockIds.get(blockIds.size() - 1)).getNum());
        }
        long realHighBlkNum = highBlkNum + (long)blockIds.size();
        do {
            if (lowBlkNum <= highNoForkBlkNum) {
                retSummary.offer(this.dbManager.getBlockIdByNum(lowBlkNum));
                continue;
            }
            if (lowBlkNum <= highBlkNum) {
                retSummary.offer((BlockCapsule.BlockId)forkList.get((int)(lowBlkNum - highNoForkBlkNum - 1L)));
                continue;
            }
            retSummary.offer((BlockCapsule.BlockId)blockIds.get((int)(lowBlkNum - highBlkNum - 1L)));
        } while ((lowBlkNum += (realHighBlkNum - lowBlkNum + 2L) / 2L) <= realHighBlkNum);
        return retSummary;
    }

    @Override
    public Message getData(Sha256Hash hash, MessageTypes type) throws StoreException {
        switch (type) {
            case BLOCK: {
                return new BlockMessage(this.dbManager.getBlockById(hash));
            }
            case TRX: {
                TransactionCapsule tx = this.dbManager.getTransactionStore().get(hash.getBytes());
                if (tx != null) {
                    return new TransactionMessage(tx.getData());
                }
                throw new ItemNotFoundException("transaction is not found");
            }
        }
        throw new BadItemException("message type not block or trx.");
    }

    @Override
    public void syncToCli(long unSyncNum) {
        logger.info("There are " + unSyncNum + " blocks we need to sync.");
        if (unSyncNum == 0L) {
            logger.info("Sync Block Completed !!!");
        }
        this.dbManager.setSyncMode(unSyncNum == 0L);
    }

    @Override
    public long getBlockTime(BlockCapsule.BlockId id) {
        try {
            return this.dbManager.getBlockById(id).getTimeStamp();
        }
        catch (BadItemException e) {
            return this.dbManager.getGenesisBlock().getTimeStamp();
        }
        catch (ItemNotFoundException e) {
            return this.dbManager.getGenesisBlock().getTimeStamp();
        }
    }

    @Override
    public BlockCapsule.BlockId getHeadBlockId() {
        return this.dbManager.getHeadBlockId();
    }

    @Override
    public BlockCapsule.BlockId getSolidBlockId() {
        return this.dbManager.getSolidBlockId();
    }

    @Override
    public long getHeadBlockTimeStamp() {
        return this.dbManager.getHeadBlockTimeStamp();
    }

    @Override
    public boolean containBlock(BlockCapsule.BlockId id) {
        return this.dbManager.containBlock(id);
    }

    @Override
    public boolean containBlockInMainChain(BlockCapsule.BlockId id) {
        return this.dbManager.containBlockInMainChain(id);
    }

    @Override
    public boolean contain(Sha256Hash hash, MessageTypes type) {
        if (type.equals((Object)MessageTypes.BLOCK)) {
            return this.dbManager.containBlock(hash);
        }
        if (type.equals((Object)MessageTypes.TRX)) {
            return this.dbManager.getTransactionStore().has(hash.getBytes());
        }
        return false;
    }

    @Override
    public BlockCapsule getGenesisBlock() {
        return this.dbManager.getGenesisBlock();
    }

    @Override
    public boolean canChainRevoke(long num) {
        return num >= this.dbManager.getSyncBeginNumber();
    }
}

