/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.net.message;

import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.exception.BadItemException;
import org.tron.core.net.message.MessageTypes;
import org.tron.core.net.message.TronMessage;
import org.tron.protos.Protocol;

public class TransactionMessage
extends TronMessage {
    private TransactionCapsule transactionCapsule;

    public TransactionMessage(byte[] data) throws BadItemException {
        this.transactionCapsule = new TransactionCapsule(data);
        this.data = data;
        this.type = MessageTypes.TRX.asByte();
    }

    public TransactionMessage(Protocol.Transaction trx) {
        this.transactionCapsule = new TransactionCapsule(trx);
        this.type = MessageTypes.TRX.asByte();
        this.data = trx.toByteArray();
    }

    @Override
    public String toString() {
        return super.toString() + "messageId: " + super.getMessageId();
    }

    @Override
    public Sha256Hash getMessageId() {
        return this.transactionCapsule.getTransactionId();
    }

    @Override
    public Class<?> getAnswerMessage() {
        return null;
    }

    public TransactionCapsule getTransactionCapsule() {
        return this.transactionCapsule;
    }
}

