/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db2.core;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.tron.common.storage.leveldb.LevelDbDataSourceImpl;
import org.tron.core.config.args.Args;
import org.tron.core.db.AbstractRevokingStore;
import org.tron.core.db.RevokingStore;
import org.tron.core.db2.common.IRevokingDB;
import org.tron.core.exception.ItemNotFoundException;

public class RevokingDBWithCachingOldValue
implements IRevokingDB {
    private AbstractRevokingStore revokingDatabase;
    private LevelDbDataSourceImpl dbSource;

    public RevokingDBWithCachingOldValue(String dbName) {
        this(dbName, RevokingStore.getInstance());
    }

    public RevokingDBWithCachingOldValue(String dbName, AbstractRevokingStore revokingDatabase) {
        this.dbSource = new LevelDbDataSourceImpl(Args.getInstance().getOutputDirectoryByDbName(dbName), dbName);
        this.dbSource.initDB();
        this.revokingDatabase = revokingDatabase;
    }

    @Override
    public void put(byte[] key, byte[] newValue) {
        if (Objects.isNull(key) || Objects.isNull(newValue)) {
            return;
        }
        byte[] value = this.dbSource.getData(key);
        if (ArrayUtils.isNotEmpty((byte[])value)) {
            this.onModify(key, value);
        }
        this.dbSource.putData(key, newValue);
        if (ArrayUtils.isEmpty((byte[])value)) {
            this.onCreate(key);
        }
    }

    @Override
    public void delete(byte[] key) {
        this.onDelete(key);
        this.dbSource.deleteData(key);
    }

    @Override
    public boolean hasOnSolidity(byte[] key) {
        return false;
    }

    @Override
    public boolean has(byte[] key) {
        return this.dbSource.getData(key) != null;
    }

    @Override
    public byte[] get(byte[] key) throws ItemNotFoundException {
        byte[] value = this.dbSource.getData(key);
        if (ArrayUtils.isEmpty((byte[])value)) {
            throw new ItemNotFoundException();
        }
        return value;
    }

    @Override
    public byte[] getUnchecked(byte[] key) {
        try {
            return this.get(key);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
    }

    @Override
    public byte[] getOnSolidity(byte[] key) throws ItemNotFoundException {
        return null;
    }

    @Override
    public byte[] getUncheckedOnSolidity(byte[] key) {
        return null;
    }

    @Override
    public void close() {
        this.dbSource.closeDB();
    }

    @Override
    public void reset() {
        this.dbSource.resetDb();
    }

    private void onCreate(byte[] key) {
        this.revokingDatabase.onCreate(new AbstractRevokingStore.RevokingTuple(this.dbSource, key), null);
    }

    private void onModify(byte[] key, byte[] value) {
        this.revokingDatabase.onModify(new AbstractRevokingStore.RevokingTuple(this.dbSource, key), value);
    }

    private void onDelete(byte[] key) {
        byte[] value = this.dbSource.getData(key);
        if (Objects.nonNull(value)) {
            this.revokingDatabase.onRemove(new AbstractRevokingStore.RevokingTuple(this.dbSource, key), value);
        }
    }

    @Override
    public Iterator<Map.Entry<byte[], byte[]>> iterator() {
        return this.dbSource.iterator();
    }

    @Override
    public Set<byte[]> getlatestValues(long limit) {
        return this.dbSource.getlatestValues(limit);
    }

    @Override
    public Set<byte[]> getValuesNext(byte[] key, long limit) {
        return this.dbSource.getValuesNext(key, limit);
    }

    public LevelDbDataSourceImpl getDbSource() {
        return this.dbSource;
    }
}

