/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db2.core;

import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.tron.common.utils.ByteUtil;
import org.tron.core.config.args.Args;
import org.tron.core.db.common.WrappedByteArray;
import org.tron.core.db2.common.IRevokingDB;
import org.tron.core.db2.common.LevelDB;
import org.tron.core.db2.common.Value;
import org.tron.core.db2.core.Snapshot;
import org.tron.core.db2.core.SnapshotImpl;
import org.tron.core.db2.core.SnapshotRoot;
import org.tron.core.exception.ItemNotFoundException;

public class RevokingDBWithCachingNewValue
implements IRevokingDB {
    private Snapshot head;
    private String dbName;

    public RevokingDBWithCachingNewValue(String dbName) {
        this.dbName = dbName;
        this.head = new SnapshotRoot(Args.getInstance().getOutputDirectoryByDbName(dbName), dbName);
    }

    public synchronized Snapshot getHead() {
        return this.head;
    }

    public synchronized void setHead(Snapshot head) {
        this.head = head;
    }

    @Override
    public synchronized void close() {
        this.head.close();
    }

    @Override
    public synchronized void reset() {
        this.head.reset();
        this.head.close();
        this.head = new SnapshotRoot(Args.getInstance().getOutputDirectoryByDbName(this.dbName), this.dbName);
    }

    @Override
    public synchronized void put(byte[] key, byte[] value) {
        this.head.put(key, value);
    }

    @Override
    public synchronized void delete(byte[] key) {
        this.head.remove(key);
    }

    @Override
    public synchronized byte[] get(byte[] key) throws ItemNotFoundException {
        byte[] value = this.getUnchecked(key);
        if (value == null) {
            throw new ItemNotFoundException();
        }
        return value;
    }

    @Override
    public synchronized byte[] getUnchecked(byte[] key) {
        return this.head.get(key);
    }

    @Override
    public byte[] getOnSolidity(byte[] key) throws ItemNotFoundException {
        byte[] value = this.getUncheckedOnSolidity(key);
        if (value == null) {
            throw new ItemNotFoundException();
        }
        return value;
    }

    @Override
    public byte[] getUncheckedOnSolidity(byte[] key) {
        Snapshot solidity = this.head.getSolidity();
        return solidity.get(key);
    }

    @Override
    public synchronized boolean hasOnSolidity(byte[] key) {
        return this.getUncheckedOnSolidity(key) != null;
    }

    @Override
    public synchronized boolean has(byte[] key) {
        return this.getUnchecked(key) != null;
    }

    @Override
    public synchronized Iterator<Map.Entry<byte[], byte[]>> iterator() {
        return this.head.iterator();
    }

    public synchronized Iterator<Map.Entry<byte[], byte[]>> iteratorOnSolidity() {
        return this.head.getSolidity().iterator();
    }

    @Override
    public Set<byte[]> getlatestValues(long limit) {
        return this.getlatestValues(this.head, limit);
    }

    public Set<byte[]> getlatestValuesOnSolidity(long limit) {
        return this.getlatestValues(this.head.getSolidity(), limit);
    }

    private synchronized Set<byte[]> getlatestValues(Snapshot head, long limit) {
        if (limit <= 0L) {
            return Collections.emptySet();
        }
        HashSet<byte[]> result = new HashSet<byte[]>();
        Snapshot snapshot = head;
        long tmp = limit;
        while (tmp > 0L && snapshot.getPrevious() != null) {
            if (!((SnapshotImpl)snapshot).db.isEmpty()) {
                --tmp;
                Streams.stream((Iterable)((SnapshotImpl)snapshot).db).map(Map.Entry::getValue).map(Value::getBytes).forEach(result::add);
            }
            snapshot = snapshot.getPrevious();
        }
        if (snapshot.getPrevious() == null && tmp != 0L) {
            result.addAll(((LevelDB)((SnapshotRoot)snapshot).db).getDb().getlatestValues(tmp));
        }
        return result;
    }

    private Set<byte[]> getValuesNext(Snapshot head, byte[] key, long limit) {
        if (limit <= 0L) {
            return Collections.emptySet();
        }
        HashMap<WrappedByteArray, WrappedByteArray> collection = new HashMap<WrappedByteArray, WrappedByteArray>();
        if (head.getPrevious() != null) {
            ((SnapshotImpl)head).collect(collection);
        }
        HashMap<WrappedByteArray, WrappedByteArray> levelDBMap = new HashMap<WrappedByteArray, WrappedByteArray>();
        ((LevelDB)((SnapshotRoot)head.getRoot()).db).getDb().getNext(key, limit).entrySet().stream().map(e -> Maps.immutableEntry((Object)WrappedByteArray.of((byte[])e.getKey()), (Object)WrappedByteArray.of((byte[])e.getValue()))).forEach(e -> {
            WrappedByteArray cfr_ignored_0 = (WrappedByteArray)levelDBMap.put((WrappedByteArray)e.getKey(), (WrappedByteArray)e.getValue());
        });
        levelDBMap.putAll(collection);
        return levelDBMap.entrySet().stream().sorted((e1, e2) -> ByteUtil.compare(((WrappedByteArray)e1.getKey()).getBytes(), ((WrappedByteArray)e2.getKey()).getBytes())).filter(e -> ByteUtil.greaterOrEquals(((WrappedByteArray)e.getKey()).getBytes(), key)).limit(limit).map(Map.Entry::getValue).map(WrappedByteArray::getBytes).collect(Collectors.toSet());
    }

    @Override
    public Set<byte[]> getValuesNext(byte[] key, long limit) {
        return this.getValuesNext(this.head, key, limit);
    }

    public synchronized Set<byte[]> getValuesNextOnSolidity(byte[] key, long limit) {
        return this.getValuesNext(this.head.getSolidity(), key, limit);
    }

    public String getDbName() {
        return this.dbName;
    }
}

