/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.api.index;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.index.Index;
import com.googlecode.cqengine.index.disk.DiskIndex;
import com.googlecode.cqengine.persistence.Persistence;
import com.googlecode.cqengine.persistence.disk.DiskPersistence;
import com.googlecode.cqengine.query.QueryFactory;
import java.io.File;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.db.api.index.AbstractIndex;
import org.tron.core.db.common.WrappedByteArray;
import org.tron.core.db2.core.ITronChainBase;
import org.tron.protos.Protocol;

@Component
public class WitnessIndex
extends AbstractIndex<WitnessCapsule, Protocol.Witness> {
    private static final Logger logger = LoggerFactory.getLogger(WitnessIndex.class);
    public static SimpleAttribute<WrappedByteArray, String> Witness_ADDRESS;
    public static Attribute<WrappedByteArray, String> PUBLIC_KEY;
    public static Attribute<WrappedByteArray, String> Witness_URL;

    @Autowired
    public WitnessIndex(@Qualifier(value="witnessStore") ITronChainBase<WitnessCapsule> database) {
        super(database);
    }

    @PostConstruct
    public void init() {
        this.initIndex((Persistence<WrappedByteArray, Comparable>)DiskPersistence.onPrimaryKeyInFile(Witness_ADDRESS, (File)this.indexPath));
        this.index.addIndex((Index)DiskIndex.onAttribute(PUBLIC_KEY));
        this.index.addIndex((Index)DiskIndex.onAttribute(Witness_URL));
    }

    @Override
    public void setAttribute() {
        Witness_ADDRESS = QueryFactory.attribute((String)"witness address", bytes -> ByteArray.toHexString(((Protocol.Witness)this.getObject((WrappedByteArray)bytes)).getAddress().toByteArray()));
        PUBLIC_KEY = QueryFactory.attribute((String)"public key", bytes -> ByteArray.toHexString(((Protocol.Witness)this.getObject((WrappedByteArray)bytes)).getPubKey().toByteArray()));
        Witness_URL = QueryFactory.attribute((String)"witness url", bytes -> ((Protocol.Witness)this.getObject((WrappedByteArray)bytes)).getUrl());
    }
}

