/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.api.index;

import com.google.common.collect.Iterables;
import com.googlecode.cqengine.ConcurrentIndexedCollection;
import com.googlecode.cqengine.persistence.Persistence;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.resultset.ResultSet;
import java.io.File;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Objects;
import org.tron.core.capsule.ProtoCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.api.index.Index;
import org.tron.core.db.common.WrappedByteArray;
import org.tron.core.db.common.WrappedResultSet;
import org.tron.core.db2.core.ITronChainBase;

public abstract class AbstractIndex<E extends ProtoCapsule<T>, T>
implements Index.Iface<T> {
    protected ITronChainBase<E> database;
    protected ConcurrentIndexedCollection<WrappedByteArray> index;
    private File parent = new File(Args.getInstance().getOutputDirectory() + "index");
    protected File indexPath;

    public AbstractIndex() {
        if (!this.parent.exists()) {
            this.parent.mkdirs();
        }
        this.indexPath = new File(this.parent, this.getName() + ".index");
        this.setAttribute();
    }

    public AbstractIndex(ITronChainBase<E> database) {
        this.database = database;
        String dbName = database.getDbName();
        File parentDir = Paths.get(Args.getInstance().getOutputDirectoryByDbName(dbName), Args.getInstance().getStorage().getIndexDirectory()).toFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        this.indexPath = new File(parentDir, this.getName() + ".index");
        this.setAttribute();
    }

    public void initIndex(Persistence<WrappedByteArray, ? extends Comparable> persistence) {
        this.index = new ConcurrentIndexedCollection(persistence);
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    protected T getObject(byte[] key) {
        try {
            ProtoCapsule e = (ProtoCapsule)this.database.get(key);
            if (Objects.isNull(e)) {
                return null;
            }
            return e.getInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected T getObject(WrappedByteArray byteArray) {
        return this.getObject(byteArray.getBytes());
    }

    @Override
    public void fill() {
        int size = Iterables.size(this.database);
        if (size != 0 && !this.indexPath.exists()) {
            this.database.forEach(e -> this.add((byte[])e.getKey()));
        }
    }

    @Override
    public boolean add(byte[] bytes) {
        return this.add(WrappedByteArray.of(bytes));
    }

    @Override
    public synchronized boolean add(WrappedByteArray bytes) {
        return this.index.add((Object)bytes);
    }

    @Override
    public boolean update(WrappedByteArray bytes) {
        return this.add(bytes);
    }

    @Override
    public boolean update(byte[] bytes) {
        return this.add(WrappedByteArray.of(bytes));
    }

    @Override
    public boolean remove(byte[] bytes) {
        return this.remove(WrappedByteArray.of(bytes));
    }

    @Override
    public boolean remove(WrappedByteArray bytes) {
        return this.index.remove((Object)bytes);
    }

    @Override
    public long size() {
        return this.index.size();
    }

    @Override
    public ResultSet<T> retrieve(Query<WrappedByteArray> query) {
        final ResultSet resultSet = this.index.retrieve(query);
        return new WrappedResultSet<T>(resultSet){

            public Iterator<T> iterator() {
                return Iterables.filter((Iterable)Iterables.transform((Iterable)resultSet, AbstractIndex.this::getObject), Objects::nonNull).iterator();
            }
        };
    }

    @Override
    public ResultSet<T> retrieve(Query<WrappedByteArray> query, QueryOptions options) {
        final ResultSet resultSet = this.index.retrieve(query, options);
        return new WrappedResultSet<T>(resultSet){

            public Iterator<T> iterator() {
                return Iterables.filter((Iterable)Iterables.transform((Iterable)resultSet, AbstractIndex.this::getObject), Objects::nonNull).iterator();
            }
        };
    }

    @Override
    public Iterator<T> iterator() {
        return Iterables.filter((Iterable)Iterables.transform(this.index, this::getObject), Objects::nonNull).iterator();
    }

    protected abstract void setAttribute();
}

