/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.googlecode.cqengine.query.Query;
import com.googlecode.cqengine.query.QueryFactory;
import com.googlecode.cqengine.query.option.AttributeOrder;
import com.googlecode.cqengine.resultset.ResultSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.tron.core.db.api.IndexHelper;
import org.tron.core.db.api.index.Index;
import org.tron.core.db.api.index.TransactionIndex;
import org.tron.core.db.common.WrappedByteArray;
import org.tron.core.exception.NonUniqueObjectException;
import org.tron.protos.Protocol;

@Component
public class StoreAPI {
    private static final Logger logger = LoggerFactory.getLogger(StoreAPI.class);
    @Autowired(required=false)
    private IndexHelper indexHelper;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Protocol.Transaction getTransactionById(String id) throws NonUniqueObjectException {
        if (StringUtils.isEmpty((Object)id)) {
            logger.info("id is empty");
            return null;
        }
        Index.Iface<Protocol.Transaction> index = this.indexHelper.getTransactionIndex();
        try (ResultSet<Protocol.Transaction> resultSet = index.retrieve((Query<WrappedByteArray>)QueryFactory.equal(TransactionIndex.Transaction_ID, (Object)id));){
            if (resultSet.isEmpty()) {
                Protocol.Transaction transaction = null;
                return transaction;
            }
            Protocol.Transaction transaction = (Protocol.Transaction)resultSet.uniqueResult();
            return transaction;
        }
        catch (com.googlecode.cqengine.resultset.common.NonUniqueObjectException e) {
            throw new NonUniqueObjectException(e);
        }
    }

    public List<Protocol.Transaction> getTransactionsFromThis(String address, long offset, long limit) {
        if (StringUtils.isEmpty((Object)address)) {
            logger.info("address is empty");
            return Lists.newArrayList();
        }
        Index.Iface<Protocol.Transaction> index = this.indexHelper.getTransactionIndex();
        try (ResultSet<Protocol.Transaction> resultSet = index.retrieve((Query<WrappedByteArray>)QueryFactory.equal(TransactionIndex.OWNERS, (Object)address), QueryFactory.queryOptions((Object)QueryFactory.orderBy((AttributeOrder)QueryFactory.ascending(TransactionIndex.TIMESTAMP))));){
            if (limit > 1000L) {
                limit = 1000L;
            }
            ImmutableList immutableList = ImmutableList.copyOf(Streams.stream(resultSet).skip(offset).limit(limit).iterator());
            return immutableList;
        }
    }

    public List<Protocol.Transaction> getTransactionsToThis(String address, long offset, long limit) {
        if (StringUtils.isEmpty((Object)address)) {
            logger.info("address is empty");
            return Lists.newArrayList();
        }
        Index.Iface<Protocol.Transaction> index = this.indexHelper.getTransactionIndex();
        try (ResultSet<Protocol.Transaction> resultSet = index.retrieve((Query<WrappedByteArray>)QueryFactory.equal(TransactionIndex.TOS, (Object)address), QueryFactory.queryOptions((Object)QueryFactory.orderBy((AttributeOrder)QueryFactory.ascending(TransactionIndex.TIMESTAMP))));){
            if (limit > 1000L) {
                limit = 1000L;
            }
            ImmutableList immutableList = ImmutableList.copyOf(Streams.stream(resultSet).skip(offset).limit(limit).iterator());
            return immutableList;
        }
    }
}

