/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.core.capsule.WitnessCapsule;
import org.tron.core.db.TronStoreWithRevoking;

@Component
public class WitnessStore
extends TronStoreWithRevoking<WitnessCapsule> {
    private static final Logger logger = LoggerFactory.getLogger(WitnessStore.class);

    @Autowired
    protected WitnessStore(@Value(value="witness") String dbName) {
        super(dbName);
    }

    public List<WitnessCapsule> getAllWitnesses() {
        return Streams.stream(this.iterator()).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public List<WitnessCapsule> getAllWitnessesOnSolidity() {
        return Streams.stream(this.iteratorOnSolidity()).map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public WitnessCapsule get(byte[] key) {
        byte[] value = this.revokingDB.getUnchecked(key);
        return ArrayUtils.isEmpty((byte[])value) ? null : new WitnessCapsule(value);
    }
}

