/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.db.TronStoreWithRevoking;

@Component
public class WitnessScheduleStore
extends TronStoreWithRevoking<BytesCapsule> {
    private static final Logger logger = LoggerFactory.getLogger(WitnessScheduleStore.class);
    private static final byte[] ACTIVE_WITNESSES = "active_witnesses".getBytes();
    private static final byte[] CURRENT_SHUFFLED_WITNESSES = "current_shuffled_witnesses".getBytes();
    private static final int ADDRESS_BYTE_ARRAY_LENGTH = 21;

    @Autowired
    private WitnessScheduleStore(@Value(value="witness_schedule") String dbName) {
        super(dbName);
    }

    private void saveData(byte[] species, List<ByteString> witnessesAddressList) {
        byte[] ba = new byte[witnessesAddressList.size() * 21];
        int i = 0;
        for (ByteString address : witnessesAddressList) {
            System.arraycopy(address.toByteArray(), 0, ba, i * 21, 21);
            ++i;
        }
        this.put(species, new BytesCapsule(ba));
    }

    private List<ByteString> getData(byte[] species) {
        ArrayList witnessesAddressList = new ArrayList();
        return Optional.ofNullable(this.getUnchecked(species)).map(BytesCapsule::getData).map(ba -> {
            int len = ((byte[])ba).length / 21;
            for (int i = 0; i < len; ++i) {
                byte[] b = new byte[21];
                System.arraycopy(ba, i * 21, b, 0, 21);
                witnessesAddressList.add(ByteString.copyFrom((byte[])b));
            }
            logger.debug("getWitnesses:" + ByteArray.toStr(species) + witnessesAddressList);
            return witnessesAddressList;
        }).orElseThrow(() -> new IllegalArgumentException("not found " + ByteArray.toStr(species) + "Witnesses"));
    }

    public void saveActiveWitnesses(List<ByteString> witnessesAddressList) {
        this.saveData(ACTIVE_WITNESSES, witnessesAddressList);
    }

    public List<ByteString> getActiveWitnesses() {
        return this.getData(ACTIVE_WITNESSES);
    }

    public void saveCurrentShuffledWitnesses(List<ByteString> witnessesAddressList) {
        this.saveData(CURRENT_SHUFFLED_WITNESSES, witnessesAddressList);
    }

    public List<ByteString> getCurrentShuffledWitnesses() {
        return this.getData(CURRENT_SHUFFLED_WITNESSES);
    }
}

