/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.tron.common.storage.leveldb.LevelDbDataSourceImpl;
import org.tron.core.config.args.Args;
import org.tron.core.db.api.IndexHelper;
import org.tron.core.db2.core.ITronChainBase;
import org.tron.core.exception.BadItemException;
import org.tron.core.exception.ItemNotFoundException;

public abstract class TronDatabase<T>
implements ITronChainBase<T> {
    private static final Logger logger = LoggerFactory.getLogger(TronDatabase.class);
    protected LevelDbDataSourceImpl dbSource;
    private String dbName;
    @Autowired(required=false)
    protected IndexHelper indexHelper;

    protected TronDatabase(String dbName) {
        this.dbName = dbName;
        this.dbSource = new LevelDbDataSourceImpl(Args.getInstance().getOutputDirectoryByDbName(dbName), dbName);
        this.dbSource.initDB();
    }

    protected TronDatabase() {
    }

    public LevelDbDataSourceImpl getDbSource() {
        return this.dbSource;
    }

    @Override
    public void reset() {
        this.dbSource.resetDb();
    }

    @Override
    public void close() {
        this.dbSource.closeDB();
    }

    @Override
    public abstract void put(byte[] var1, T var2);

    @Override
    public abstract void delete(byte[] var1);

    @Override
    public abstract T get(byte[] var1) throws InvalidProtocolBufferException, ItemNotFoundException, BadItemException;

    @Override
    public T getUnchecked(byte[] key) {
        return null;
    }

    @Override
    public abstract boolean has(byte[] var1);

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Iterator<Map.Entry<byte[], T>> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDbName() {
        return this.dbName;
    }
}

