/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.tron.common.runtime.Runtime;
import org.tron.common.runtime.RuntimeImpl;
import org.tron.common.runtime.vm.program.InternalTransaction;
import org.tron.common.runtime.vm.program.Program;
import org.tron.common.runtime.vm.program.ProgramResult;
import org.tron.common.runtime.vm.program.invoke.ProgramInvokeFactory;
import org.tron.common.runtime.vm.program.invoke.ProgramInvokeFactoryImpl;
import org.tron.common.storage.Deposit;
import org.tron.common.storage.DepositImpl;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.ContractCapsule;
import org.tron.core.capsule.ReceiptCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.config.args.Args;
import org.tron.core.db.EnergyProcessor;
import org.tron.core.db.Manager;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractExeException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.ReceiptCheckErrException;
import org.tron.core.exception.VMIllegalException;
import org.tron.protos.Contract;
import org.tron.protos.Protocol;

public class TransactionTrace {
    private static final Logger logger = LoggerFactory.getLogger((String)"TransactionTrace");
    private TransactionCapsule trx;
    private ReceiptCapsule receipt;
    private Manager dbManager;
    private Runtime runtime;
    private EnergyProcessor energyProcessor;
    private InternalTransaction.TrxType trxType;
    private long txStartTimeInMs;
    private TimeResultType timeResultType = TimeResultType.NORMAL;

    public TransactionCapsule getTrx() {
        return this.trx;
    }

    public TransactionTrace(TransactionCapsule trx, Manager dbManager) {
        this.trx = trx;
        Protocol.Transaction.Contract.ContractType contractType = this.trx.getInstance().getRawData().getContract(0).getType();
        switch (contractType.getNumber()) {
            case 31: {
                this.trxType = InternalTransaction.TrxType.TRX_CONTRACT_CALL_TYPE;
                break;
            }
            case 30: {
                this.trxType = InternalTransaction.TrxType.TRX_CONTRACT_CREATION_TYPE;
                break;
            }
            default: {
                this.trxType = InternalTransaction.TrxType.TRX_PRECOMPILED_TYPE;
            }
        }
        this.dbManager = dbManager;
        this.receipt = new ReceiptCapsule(Sha256Hash.ZERO_HASH);
        this.energyProcessor = new EnergyProcessor(this.dbManager);
    }

    private boolean needVM() {
        return this.trxType == InternalTransaction.TrxType.TRX_CONTRACT_CALL_TYPE || this.trxType == InternalTransaction.TrxType.TRX_CONTRACT_CREATION_TYPE;
    }

    public void init(BlockCapsule blockCap) {
        this.txStartTimeInMs = System.currentTimeMillis();
        DepositImpl deposit = DepositImpl.createRoot(this.dbManager);
        this.runtime = new RuntimeImpl(this, blockCap, (Deposit)deposit, (ProgramInvokeFactory)new ProgramInvokeFactoryImpl());
    }

    public void checkIsConstant() throws ContractValidateException, VMIllegalException {
        if (this.runtime.isCallConstant()) {
            throw new VMIllegalException("cannot call constant method ");
        }
    }

    public void setBill(long energyUsage) {
        if (energyUsage < 0L) {
            energyUsage = 0L;
        }
        this.receipt.setEnergyUsageTotal(energyUsage);
    }

    public void setNetBill(long netUsage, long netFee) {
        this.receipt.setNetUsage(netUsage);
        this.receipt.setNetFee(netFee);
    }

    public void exec() throws ContractExeException, ContractValidateException, VMIllegalException {
        this.runtime.execute();
        this.runtime.go();
        if (InternalTransaction.TrxType.TRX_PRECOMPILED_TYPE != this.runtime.getTrxType()) {
            if (Protocol.Transaction.Result.contractResult.OUT_OF_TIME.equals((Object)this.receipt.getResult())) {
                this.setTimeResultType(TimeResultType.OUT_OF_TIME);
            } else if (System.currentTimeMillis() - this.txStartTimeInMs > (long)Args.getInstance().getLongRunningTime()) {
                this.setTimeResultType(TimeResultType.LONG_RUNNING);
            }
        }
    }

    public void finalization() throws ContractExeException {
        try {
            this.pay();
        }
        catch (BalanceInsufficientException e) {
            throw new ContractExeException(e.getMessage());
        }
        this.runtime.finalization();
    }

    public void pay() throws BalanceInsufficientException {
        byte[] originAccount;
        byte[] callerAccount;
        long percent = 0L;
        long originEnergyLimit = 0L;
        switch (this.trxType) {
            case TRX_CONTRACT_CREATION_TYPE: {
                originAccount = callerAccount = TransactionCapsule.getOwner(this.trx.getInstance().getRawData().getContract(0));
                break;
            }
            case TRX_CONTRACT_CALL_TYPE: {
                Contract.TriggerSmartContract callContract = ContractCapsule.getTriggerContractFromTransaction(this.trx.getInstance());
                ContractCapsule contractCapsule = this.dbManager.getContractStore().get(callContract.getContractAddress().toByteArray());
                callerAccount = callContract.getOwnerAddress().toByteArray();
                originAccount = contractCapsule.getOriginAddress();
                percent = Math.max(100L - contractCapsule.getConsumeUserResourcePercent(), 0L);
                percent = Math.min(percent, 100L);
                originEnergyLimit = contractCapsule.getOriginEnergyLimit();
                break;
            }
            default: {
                return;
            }
        }
        AccountCapsule origin = this.dbManager.getAccountStore().get(originAccount);
        AccountCapsule caller = this.dbManager.getAccountStore().get(callerAccount);
        this.receipt.payEnergyBill(this.dbManager, origin, caller, percent, originEnergyLimit, this.energyProcessor, this.dbManager.getWitnessController().getHeadSlot());
    }

    public boolean checkNeedRetry() {
        if (!this.needVM()) {
            return false;
        }
        return !this.trx.getContractRet().equals((Object)Protocol.Transaction.Result.contractResult.OUT_OF_TIME) && this.receipt.getResult().equals((Object)Protocol.Transaction.Result.contractResult.OUT_OF_TIME);
    }

    public void check() throws ReceiptCheckErrException {
        if (!this.needVM()) {
            return;
        }
        if (Objects.isNull((Object)this.trx.getContractRet())) {
            throw new ReceiptCheckErrException("null resultCode");
        }
        if (!this.trx.getContractRet().equals((Object)this.receipt.getResult())) {
            logger.info("this tx resultCode in received block: {}\nthis tx resultCode in self: {}", (Object)this.trx.getContractRet(), (Object)this.receipt.getResult());
            throw new ReceiptCheckErrException("Different resultCode");
        }
    }

    public ReceiptCapsule getReceipt() {
        return this.receipt;
    }

    public void setResult() {
        if (!this.needVM()) {
            return;
        }
        RuntimeException exception = this.runtime.getResult().getException();
        if (Objects.isNull(exception) && StringUtils.isEmpty((Object)this.runtime.getRuntimeError()) && !this.runtime.getResult().isRevert()) {
            this.receipt.setResult(Protocol.Transaction.Result.contractResult.SUCCESS);
            return;
        }
        if (this.runtime.getResult().isRevert()) {
            this.receipt.setResult(Protocol.Transaction.Result.contractResult.REVERT);
            return;
        }
        if (exception instanceof Program.IllegalOperationException) {
            this.receipt.setResult(Protocol.Transaction.Result.contractResult.ILLEGAL_OPERATION);
            return;
        }
        if (exception instanceof Program.OutOfEnergyException) {
            this.receipt.setResult(Protocol.Transaction.Result.contractResult.OUT_OF_ENERGY);
            return;
        }
        if (exception instanceof Program.BadJumpDestinationException) {
            this.receipt.setResult(Protocol.Transaction.Result.contractResult.BAD_JUMP_DESTINATION);
            return;
        }
        if (exception instanceof Program.OutOfTimeException) {
            this.receipt.setResult(Protocol.Transaction.Result.contractResult.OUT_OF_TIME);
            return;
        }
        if (exception instanceof Program.OutOfMemoryException) {
            this.receipt.setResult(Protocol.Transaction.Result.contractResult.OUT_OF_MEMORY);
            return;
        }
        if (exception instanceof Program.PrecompiledContractException) {
            this.receipt.setResult(Protocol.Transaction.Result.contractResult.PRECOMPILED_CONTRACT);
            return;
        }
        if (exception instanceof Program.StackTooSmallException) {
            this.receipt.setResult(Protocol.Transaction.Result.contractResult.STACK_TOO_SMALL);
            return;
        }
        if (exception instanceof Program.StackTooLargeException) {
            this.receipt.setResult(Protocol.Transaction.Result.contractResult.STACK_TOO_LARGE);
            return;
        }
        if (exception instanceof Program.JVMStackOverFlowException) {
            this.receipt.setResult(Protocol.Transaction.Result.contractResult.JVM_STACK_OVER_FLOW);
            return;
        }
        this.receipt.setResult(Protocol.Transaction.Result.contractResult.UNKNOWN);
    }

    public String getRuntimeError() {
        return this.runtime.getRuntimeError();
    }

    public ProgramResult getRuntimeResult() {
        return this.runtime.getResult();
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public TimeResultType getTimeResultType() {
        return this.timeResultType;
    }

    public void setTimeResultType(TimeResultType timeResultType) {
        this.timeResultType = timeResultType;
    }

    public static enum TimeResultType {
        NORMAL,
        LONG_RUNNING,
        OUT_OF_TIME;

    }
}

