/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tron.core.capsule.AccountCapsule;
import org.tron.core.db.Manager;

public class StorageMarket {
    private static final Logger logger = LoggerFactory.getLogger(StorageMarket.class);
    private Manager dbManager;
    private long supply = 1000000000000000L;

    public StorageMarket(Manager manager) {
        this.dbManager = manager;
    }

    private long exchange_to_supply(boolean isTRX, long quant) {
        logger.info("isTRX: " + isTRX);
        long balance = isTRX ? this.dbManager.getDynamicPropertiesStore().getTotalStoragePool() : this.dbManager.getDynamicPropertiesStore().getTotalStorageReserved();
        logger.info("balance: " + balance);
        long newBalance = balance + quant;
        logger.info("balance + quant: " + (balance + quant));
        double issuedSupply = (double)(-this.supply) * (1.0 - Math.pow(1.0 + (double)quant / (double)newBalance, 5.0E-4));
        logger.info("issuedSupply: " + issuedSupply);
        long out = (long)issuedSupply;
        this.supply += out;
        return out;
    }

    private long exchange_to_supply2(boolean isTRX, long quant) {
        logger.info("isTRX: " + isTRX);
        long balance = isTRX ? this.dbManager.getDynamicPropertiesStore().getTotalStoragePool() : this.dbManager.getDynamicPropertiesStore().getTotalStorageReserved();
        logger.info("balance: " + balance);
        long newBalance = balance - quant;
        logger.info("balance - quant: " + (balance - quant));
        double issuedSupply = (double)(-this.supply) * (1.0 - Math.pow(1.0 + (double)quant / (double)newBalance, 5.0E-4));
        logger.info("issuedSupply: " + issuedSupply);
        long out = (long)issuedSupply;
        this.supply += out;
        return out;
    }

    private long exchange_from_supply(boolean isTRX, long supplyQuant) {
        long balance = isTRX ? this.dbManager.getDynamicPropertiesStore().getTotalStoragePool() : this.dbManager.getDynamicPropertiesStore().getTotalStorageReserved();
        this.supply -= supplyQuant;
        double exchangeBalance = (double)balance * (Math.pow(1.0 + (double)supplyQuant / (double)this.supply, 2000.0) - 1.0);
        logger.info("exchangeBalance: " + exchangeBalance);
        long out = (long)exchangeBalance;
        long newBalance = balance - out;
        if (isTRX) {
            out = Math.round(exchangeBalance / 100000.0) * 100000L;
            logger.info("---out: " + out);
        }
        return out;
    }

    public long exchange(long from, boolean isTRX) {
        long relay = this.exchange_to_supply(isTRX, from);
        return this.exchange_from_supply(!isTRX, relay);
    }

    public long calculateTax(long duration, long limit) {
        double ratePerYear = (double)this.dbManager.getDynamicPropertiesStore().getStorageExchangeTaxRate() / 100.0;
        double millisecondPerYear = 3.1536E10;
        double feeRate = (double)duration / millisecondPerYear * ratePerYear;
        long storageTax = (long)((double)limit * feeRate);
        logger.info("storageTax: " + storageTax);
        return storageTax;
    }

    public long tryPayTax(long duration, long limit) {
        long storageTax = this.calculateTax(duration, limit);
        long tax = this.exchange(storageTax, false);
        logger.info("tax: " + tax);
        long newTotalTax = this.dbManager.getDynamicPropertiesStore().getTotalStorageTax() + tax;
        long newTotalPool = this.dbManager.getDynamicPropertiesStore().getTotalStoragePool() - tax;
        long newTotalReserved = this.dbManager.getDynamicPropertiesStore().getTotalStorageReserved() + storageTax;
        logger.info("reserved: " + this.dbManager.getDynamicPropertiesStore().getTotalStorageReserved());
        boolean eq = this.dbManager.getDynamicPropertiesStore().getTotalStorageReserved() == 0x2000000000L;
        logger.info("reserved == 128GB: " + eq);
        logger.info("newTotalTax: " + newTotalTax + "  newTotalPool: " + newTotalPool + "  newTotalReserved: " + newTotalReserved);
        return storageTax;
    }

    public long payTax(long duration, long limit) {
        long storageTax = this.calculateTax(duration, limit);
        long tax = this.exchange(storageTax, false);
        logger.info("tax: " + tax);
        long newTotalTax = this.dbManager.getDynamicPropertiesStore().getTotalStorageTax() + tax;
        long newTotalPool = this.dbManager.getDynamicPropertiesStore().getTotalStoragePool() - tax;
        long newTotalReserved = this.dbManager.getDynamicPropertiesStore().getTotalStorageReserved() + storageTax;
        logger.info("reserved: " + this.dbManager.getDynamicPropertiesStore().getTotalStorageReserved());
        boolean eq = this.dbManager.getDynamicPropertiesStore().getTotalStorageReserved() == 0x2000000000L;
        logger.info("reserved == 128GB: " + eq);
        logger.info("newTotalTax: " + newTotalTax + "  newTotalPool: " + newTotalPool + "  newTotalReserved: " + newTotalReserved);
        this.dbManager.getDynamicPropertiesStore().saveTotalStorageTax(newTotalTax);
        this.dbManager.getDynamicPropertiesStore().saveTotalStoragePool(newTotalPool);
        this.dbManager.getDynamicPropertiesStore().saveTotalStorageReserved(newTotalReserved);
        return storageTax;
    }

    public long tryBuyStorageBytes(long storageBought) {
        long relay = this.exchange_to_supply2(false, storageBought);
        return this.exchange_from_supply(true, relay);
    }

    public long tryBuyStorage(long quant) {
        return this.exchange(quant, true);
    }

    public long trySellStorage(long bytes) {
        return this.exchange(bytes, false);
    }

    public AccountCapsule buyStorageBytes(AccountCapsule accountCapsule, long storageBought) {
        long now = this.dbManager.getHeadBlockTimeStamp();
        long currentStorageLimit = accountCapsule.getStorageLimit();
        long relay = this.exchange_to_supply2(false, storageBought);
        long quant = this.exchange_from_supply(true, relay);
        long newBalance = accountCapsule.getBalance() - quant;
        logger.info("newBalance\uff1a " + newBalance);
        long newStorageLimit = currentStorageLimit + storageBought;
        logger.info("storageBought: " + storageBought + "  newStorageLimit: " + newStorageLimit);
        accountCapsule.setLatestExchangeStorageTime(now);
        accountCapsule.setStorageLimit(newStorageLimit);
        accountCapsule.setBalance(newBalance);
        this.dbManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
        long newTotalPool = this.dbManager.getDynamicPropertiesStore().getTotalStoragePool() + quant;
        long newTotalReserved = this.dbManager.getDynamicPropertiesStore().getTotalStorageReserved() - storageBought;
        logger.info("newTotalPool: " + newTotalPool + "  newTotalReserved: " + newTotalReserved);
        this.dbManager.getDynamicPropertiesStore().saveTotalStoragePool(newTotalPool);
        this.dbManager.getDynamicPropertiesStore().saveTotalStorageReserved(newTotalReserved);
        return accountCapsule;
    }

    public void buyStorage(AccountCapsule accountCapsule, long quant) {
        long now = this.dbManager.getHeadBlockTimeStamp();
        long currentStorageLimit = accountCapsule.getStorageLimit();
        long newBalance = accountCapsule.getBalance() - quant;
        logger.info("newBalance\uff1a " + newBalance);
        long storageBought = this.exchange(quant, true);
        long newStorageLimit = currentStorageLimit + storageBought;
        logger.info("storageBought: " + storageBought + "  newStorageLimit: " + newStorageLimit);
        accountCapsule.setLatestExchangeStorageTime(now);
        accountCapsule.setStorageLimit(newStorageLimit);
        accountCapsule.setBalance(newBalance);
        this.dbManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
        long newTotalPool = this.dbManager.getDynamicPropertiesStore().getTotalStoragePool() + quant;
        long newTotalReserved = this.dbManager.getDynamicPropertiesStore().getTotalStorageReserved() - storageBought;
        logger.info("newTotalPool: " + newTotalPool + "  newTotalReserved: " + newTotalReserved);
        this.dbManager.getDynamicPropertiesStore().saveTotalStoragePool(newTotalPool);
        this.dbManager.getDynamicPropertiesStore().saveTotalStorageReserved(newTotalReserved);
    }

    public void sellStorage(AccountCapsule accountCapsule, long bytes) {
        long now = this.dbManager.getHeadBlockTimeStamp();
        long currentStorageLimit = accountCapsule.getStorageLimit();
        long quant = this.exchange(bytes, false);
        long newBalance = accountCapsule.getBalance() + quant;
        long newStorageLimit = currentStorageLimit - bytes;
        logger.info("quant: " + quant + "  newStorageLimit: " + newStorageLimit);
        accountCapsule.setLatestExchangeStorageTime(now);
        accountCapsule.setStorageLimit(newStorageLimit);
        accountCapsule.setBalance(newBalance);
        this.dbManager.getAccountStore().put(accountCapsule.createDbKey(), accountCapsule);
        long newTotalPool = this.dbManager.getDynamicPropertiesStore().getTotalStoragePool() - quant;
        long newTotalReserved = this.dbManager.getDynamicPropertiesStore().getTotalStorageReserved() + bytes;
        logger.info("newTotalPool: " + newTotalPool + "  newTotalReserved: " + newTotalReserved);
        this.dbManager.getDynamicPropertiesStore().saveTotalStoragePool(newTotalPool);
        this.dbManager.getDynamicPropertiesStore().saveTotalStorageReserved(newTotalReserved);
    }

    public long getAccountLeftStorageInByteFromBought(AccountCapsule accountCapsule) {
        return accountCapsule.getStorageLimit() - accountCapsule.getStorageUsage();
    }
}

