/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import org.tron.core.capsule.AccountCapsule;
import org.tron.core.capsule.TransactionCapsule;
import org.tron.core.db.Manager;
import org.tron.core.db.TransactionTrace;
import org.tron.core.exception.AccountResourceInsufficientException;
import org.tron.core.exception.BalanceInsufficientException;
import org.tron.core.exception.ContractValidateException;
import org.tron.core.exception.TooBigTransactionResultException;

abstract class ResourceProcessor {
    protected Manager dbManager;
    protected long precision;
    protected long windowSize;
    protected long averageWindowSize;

    public ResourceProcessor(Manager manager) {
        this.dbManager = manager;
        this.precision = 1000000L;
        this.windowSize = 28800L;
        this.averageWindowSize = 20L;
    }

    abstract void updateUsage(AccountCapsule var1);

    abstract void consume(TransactionCapsule var1, TransactionTrace var2) throws ContractValidateException, AccountResourceInsufficientException, TooBigTransactionResultException;

    protected long increase(long lastUsage, long usage, long lastTime, long now) {
        return this.increase(lastUsage, usage, lastTime, now, this.windowSize);
    }

    protected long increase(long lastUsage, long usage, long lastTime, long now, long windowSize) {
        long averageLastUsage = this.divideCeil(lastUsage * this.precision, windowSize);
        long averageUsage = this.divideCeil(usage * this.precision, windowSize);
        if (lastTime != now) {
            assert (now > lastTime);
            if (lastTime + windowSize > now) {
                long delta = now - lastTime;
                double decay = (double)(windowSize - delta) / (double)windowSize;
                averageLastUsage = Math.round((double)averageLastUsage * decay);
            } else {
                averageLastUsage = 0L;
            }
        }
        return this.getUsage(averageLastUsage += averageUsage, windowSize);
    }

    private long divideCeil(long numerator, long denominator) {
        return numerator / denominator + (long)(numerator % denominator > 0L ? 1 : 0);
    }

    private long getUsage(long usage) {
        return usage * this.windowSize / this.precision;
    }

    private long getUsage(long usage, long windowSize) {
        return usage * windowSize / this.precision;
    }

    protected boolean consumeFee(AccountCapsule accountCapsule, long fee) {
        try {
            long latestOperationTime = this.dbManager.getHeadBlockTimeStamp();
            accountCapsule.setLatestOperationTime(latestOperationTime);
            this.dbManager.adjustBalance(accountCapsule, -fee);
            this.dbManager.adjustBalance(this.dbManager.getAccountStore().getBlackhole().createDbKey(), fee);
            return true;
        }
        catch (BalanceInsufficientException e) {
            return false;
        }
    }
}

