/*
 * Decompiled with CFR 0.152.
 */
package org.tron.core.db;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.tron.common.utils.ByteArray;
import org.tron.common.utils.Sha256Hash;
import org.tron.core.capsule.BlockCapsule;
import org.tron.core.capsule.BytesCapsule;
import org.tron.core.db.TronStoreWithRevoking;
import org.tron.core.exception.ItemNotFoundException;

@Component
public class BlockIndexStore
extends TronStoreWithRevoking<BytesCapsule> {
    @Autowired
    public BlockIndexStore(@Value(value="block-index") String dbName) {
        super(dbName);
    }

    public void put(BlockCapsule.BlockId id) {
        this.put(ByteArray.fromLong(id.getNum()), new BytesCapsule(id.getBytes()));
    }

    public BlockCapsule.BlockId get(Long num) throws ItemNotFoundException {
        BytesCapsule value = (BytesCapsule)this.getUnchecked(ByteArray.fromLong(num));
        if (value == null || value.getData() == null) {
            throw new ItemNotFoundException("number: " + num + " is not found!");
        }
        return new BlockCapsule.BlockId(Sha256Hash.wrap(value.getData()), (long)num);
    }

    public BlockCapsule.BlockId getOnSolidity(Long num) throws ItemNotFoundException {
        BytesCapsule value = (BytesCapsule)this.getUncheckedOnSolidity(ByteArray.fromLong(num));
        if (value == null || value.getData() == null) {
            throw new ItemNotFoundException("number: " + num + " is not found!");
        }
        return new BlockCapsule.BlockId(Sha256Hash.wrap(value.getData()), (long)num);
    }

    @Override
    public BytesCapsule get(byte[] key) throws ItemNotFoundException {
        byte[] value = this.revokingDB.getUnchecked(key);
        if (ArrayUtils.isEmpty((byte[])value)) {
            throw new ItemNotFoundException("number: " + Arrays.toString(key) + " is not found!");
        }
        return new BytesCapsule(value);
    }
}

